// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model



public class RegisterWorkspaceDirectoryRequest private constructor(builder: Builder) {
    /**
     * The identifier of the directory. You cannot register a directory if it does not have a status of Active. If the directory does not have a status of Active, you will receive an InvalidResourceStateException error. If you have already registered the maximum number of directories that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister directories that you are not using for WorkSpaces, and try again.
     */
    public val directoryId: kotlin.String? = builder.directoryId
    /**
     * Indicates whether self-service capabilities are enabled or disabled.
     */
    public val enableSelfService: kotlin.Boolean? = builder.enableSelfService
    /**
     * Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set `EnableWorkDocs` to disabled, and try again.
     */
    public val enableWorkDocs: kotlin.Boolean? = builder.enableWorkDocs
    /**
     * The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions are not met, you will receive an OperationNotSupportedException error.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The tags associated with the directory.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images, this value must be set to `DEDICATED` and your Amazon Web Services account must be enabled for BYOL. If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For more information about BYOL images, see [Bring Your Own Windows Desktop Images](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
     */
    public val tenancy: aws.sdk.kotlin.services.workspaces.model.Tenancy? = builder.tenancy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.RegisterWorkspaceDirectoryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterWorkspaceDirectoryRequest(")
        append("directoryId=$directoryId,")
        append("enableSelfService=$enableSelfService,")
        append("enableWorkDocs=$enableWorkDocs,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("tenancy=$tenancy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = directoryId?.hashCode() ?: 0
        result = 31 * result + (enableSelfService?.hashCode() ?: 0)
        result = 31 * result + (enableWorkDocs?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterWorkspaceDirectoryRequest

        if (directoryId != other.directoryId) return false
        if (enableSelfService != other.enableSelfService) return false
        if (enableWorkDocs != other.enableWorkDocs) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (tenancy != other.tenancy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.RegisterWorkspaceDirectoryRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the directory. You cannot register a directory if it does not have a status of Active. If the directory does not have a status of Active, you will receive an InvalidResourceStateException error. If you have already registered the maximum number of directories that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister directories that you are not using for WorkSpaces, and try again.
         */
        public var directoryId: kotlin.String? = null
        /**
         * Indicates whether self-service capabilities are enabled or disabled.
         */
        public var enableSelfService: kotlin.Boolean? = null
        /**
         * Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set `EnableWorkDocs` to disabled, and try again.
         */
        public var enableWorkDocs: kotlin.Boolean? = null
        /**
         * The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions are not met, you will receive an OperationNotSupportedException error.
         */
        public var subnetIds: List<String>? = null
        /**
         * The tags associated with the directory.
         */
        public var tags: List<Tag>? = null
        /**
         * Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images, this value must be set to `DEDICATED` and your Amazon Web Services account must be enabled for BYOL. If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For more information about BYOL images, see [Bring Your Own Windows Desktop Images](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
         */
        public var tenancy: aws.sdk.kotlin.services.workspaces.model.Tenancy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.RegisterWorkspaceDirectoryRequest) : this() {
            this.directoryId = x.directoryId
            this.enableSelfService = x.enableSelfService
            this.enableWorkDocs = x.enableWorkDocs
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.tenancy = x.tenancy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.RegisterWorkspaceDirectoryRequest = RegisterWorkspaceDirectoryRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
