// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model



/**
 * Describes the permissions for a connection alias. Connection aliases are used for cross-Region redirection. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
 */
public class ConnectionAliasPermission private constructor(builder: Builder) {
    /**
     * Indicates whether the specified Amazon Web Services account is allowed to associate the connection alias with a directory.
     */
    public val allowAssociation: kotlin.Boolean = requireNotNull(builder.allowAssociation) { "A non-null value must be provided for allowAssociation" }
    /**
     * The identifier of the Amazon Web Services account that the connection alias is shared with.
     */
    public val sharedAccountId: kotlin.String = requireNotNull(builder.sharedAccountId) { "A non-null value must be provided for sharedAccountId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.ConnectionAliasPermission = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectionAliasPermission(")
        append("allowAssociation=$allowAssociation,")
        append("sharedAccountId=$sharedAccountId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowAssociation.hashCode()
        result = 31 * result + (sharedAccountId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectionAliasPermission

        if (allowAssociation != other.allowAssociation) return false
        if (sharedAccountId != other.sharedAccountId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.ConnectionAliasPermission = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the specified Amazon Web Services account is allowed to associate the connection alias with a directory.
         */
        public var allowAssociation: kotlin.Boolean? = null
        /**
         * The identifier of the Amazon Web Services account that the connection alias is shared with.
         */
        public var sharedAccountId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.ConnectionAliasPermission) : this() {
            this.allowAssociation = x.allowAssociation
            this.sharedAccountId = x.sharedAccountId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.ConnectionAliasPermission = ConnectionAliasPermission(this)

        internal fun correctErrors(): Builder {
            if (allowAssociation == null) allowAssociation = false
            if (sharedAccountId == null) sharedAccountId = ""
            return this
        }
    }
}
