// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model



/**
 * Describes a connection alias association that is used for cross-Region redirection. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
 */
public class ConnectionAliasAssociation private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Web Services account that associated the connection alias with a directory.
     */
    public val associatedAccountId: kotlin.String? = builder.associatedAccountId
    /**
     * The association status of the connection alias.
     */
    public val associationStatus: aws.sdk.kotlin.services.workspaces.model.AssociationStatus? = builder.associationStatus
    /**
     * The identifier of the connection alias association. You use the connection identifier in the DNS TXT record when you're configuring your DNS routing policies.
     */
    public val connectionIdentifier: kotlin.String? = builder.connectionIdentifier
    /**
     * The identifier of the directory associated with a connection alias.
     */
    public val resourceId: kotlin.String? = builder.resourceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.ConnectionAliasAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectionAliasAssociation(")
        append("associatedAccountId=$associatedAccountId,")
        append("associationStatus=$associationStatus,")
        append("connectionIdentifier=$connectionIdentifier,")
        append("resourceId=$resourceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedAccountId?.hashCode() ?: 0
        result = 31 * result + (associationStatus?.hashCode() ?: 0)
        result = 31 * result + (connectionIdentifier?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectionAliasAssociation

        if (associatedAccountId != other.associatedAccountId) return false
        if (associationStatus != other.associationStatus) return false
        if (connectionIdentifier != other.connectionIdentifier) return false
        if (resourceId != other.resourceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.ConnectionAliasAssociation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the Amazon Web Services account that associated the connection alias with a directory.
         */
        public var associatedAccountId: kotlin.String? = null
        /**
         * The association status of the connection alias.
         */
        public var associationStatus: aws.sdk.kotlin.services.workspaces.model.AssociationStatus? = null
        /**
         * The identifier of the connection alias association. You use the connection identifier in the DNS TXT record when you're configuring your DNS routing policies.
         */
        public var connectionIdentifier: kotlin.String? = null
        /**
         * The identifier of the directory associated with a connection alias.
         */
        public var resourceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.ConnectionAliasAssociation) : this() {
            this.associatedAccountId = x.associatedAccountId
            this.associationStatus = x.associationStatus
            this.connectionIdentifier = x.connectionIdentifier
            this.resourceId = x.resourceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.ConnectionAliasAssociation = ConnectionAliasAssociation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
