// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model



/**
 * Describes a directory that is used with Amazon WorkSpaces.
 */
public class WorkspaceDirectory private constructor(builder: Builder) {
    /**
     * The directory alias.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory for WorkSpaces login.
     */
    public val certificateBasedAuthProperties: aws.sdk.kotlin.services.workspaces.model.CertificateBasedAuthProperties? = builder.certificateBasedAuthProperties
    /**
     * The user name for the service account.
     */
    public val customerUserName: kotlin.String? = builder.customerUserName
    /**
     * The directory identifier.
     */
    public val directoryId: kotlin.String? = builder.directoryId
    /**
     * The name of the directory.
     */
    public val directoryName: kotlin.String? = builder.directoryName
    /**
     * The directory type.
     */
    public val directoryType: aws.sdk.kotlin.services.workspaces.model.WorkspaceDirectoryType? = builder.directoryType
    /**
     * The IP addresses of the DNS servers for the directory.
     */
    public val dnsIpAddresses: List<String>? = builder.dnsIpAddresses
    /**
     * The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other services, such as Amazon EC2, on your behalf.
     */
    public val iamRoleId: kotlin.String? = builder.iamRoleId
    /**
     * The identifiers of the IP access control groups associated with the directory.
     */
    public val ipGroupIds: List<String>? = builder.ipGroupIds
    /**
     * The registration code for the directory. This is the code that users enter in their Amazon WorkSpaces client application to connect to the directory.
     */
    public val registrationCode: kotlin.String? = builder.registrationCode
    /**
     * Describes the enablement status, user access URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.
     */
    public val samlProperties: aws.sdk.kotlin.services.workspaces.model.SamlProperties? = builder.samlProperties
    /**
     * The default self-service permissions for WorkSpaces in the directory.
     */
    public val selfservicePermissions: aws.sdk.kotlin.services.workspaces.model.SelfservicePermissions? = builder.selfservicePermissions
    /**
     * The state of the directory's registration with Amazon WorkSpaces. After a directory is deregistered, the `DEREGISTERED` state is returned very briefly before the directory metadata is cleaned up, so this state is rarely returned. To confirm that a directory is deregistered, check for the directory ID by using [ DescribeWorkspaceDirectories](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html). If the directory ID isn't returned, then the directory has been successfully deregistered.
     */
    public val state: aws.sdk.kotlin.services.workspaces.model.WorkspaceDirectoryState? = builder.state
    /**
     * The identifiers of the subnets used with the directory.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * Specifies whether the directory is dedicated or shared. To use Bring Your Own License (BYOL), this value must be set to `DEDICATED`. For more information, see [Bring Your Own Windows Desktop Images](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
     */
    public val tenancy: aws.sdk.kotlin.services.workspaces.model.Tenancy? = builder.tenancy
    /**
     * The devices and operating systems that users can use to access WorkSpaces.
     */
    public val workspaceAccessProperties: aws.sdk.kotlin.services.workspaces.model.WorkspaceAccessProperties? = builder.workspaceAccessProperties
    /**
     * The default creation properties for all WorkSpaces in the directory.
     */
    public val workspaceCreationProperties: aws.sdk.kotlin.services.workspaces.model.DefaultWorkspaceCreationProperties? = builder.workspaceCreationProperties
    /**
     * The identifier of the security group that is assigned to new WorkSpaces.
     */
    public val workspaceSecurityGroupId: kotlin.String? = builder.workspaceSecurityGroupId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.WorkspaceDirectory = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspaceDirectory(")
        append("alias=$alias,")
        append("certificateBasedAuthProperties=$certificateBasedAuthProperties,")
        append("customerUserName=$customerUserName,")
        append("directoryId=$directoryId,")
        append("directoryName=$directoryName,")
        append("directoryType=$directoryType,")
        append("dnsIpAddresses=$dnsIpAddresses,")
        append("iamRoleId=$iamRoleId,")
        append("ipGroupIds=$ipGroupIds,")
        append("registrationCode=$registrationCode,")
        append("samlProperties=$samlProperties,")
        append("selfservicePermissions=$selfservicePermissions,")
        append("state=$state,")
        append("subnetIds=$subnetIds,")
        append("tenancy=$tenancy,")
        append("workspaceAccessProperties=$workspaceAccessProperties,")
        append("workspaceCreationProperties=$workspaceCreationProperties,")
        append("workspaceSecurityGroupId=$workspaceSecurityGroupId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (certificateBasedAuthProperties?.hashCode() ?: 0)
        result = 31 * result + (customerUserName?.hashCode() ?: 0)
        result = 31 * result + (directoryId?.hashCode() ?: 0)
        result = 31 * result + (directoryName?.hashCode() ?: 0)
        result = 31 * result + (directoryType?.hashCode() ?: 0)
        result = 31 * result + (dnsIpAddresses?.hashCode() ?: 0)
        result = 31 * result + (iamRoleId?.hashCode() ?: 0)
        result = 31 * result + (ipGroupIds?.hashCode() ?: 0)
        result = 31 * result + (registrationCode?.hashCode() ?: 0)
        result = 31 * result + (samlProperties?.hashCode() ?: 0)
        result = 31 * result + (selfservicePermissions?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        result = 31 * result + (workspaceAccessProperties?.hashCode() ?: 0)
        result = 31 * result + (workspaceCreationProperties?.hashCode() ?: 0)
        result = 31 * result + (workspaceSecurityGroupId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspaceDirectory

        if (alias != other.alias) return false
        if (certificateBasedAuthProperties != other.certificateBasedAuthProperties) return false
        if (customerUserName != other.customerUserName) return false
        if (directoryId != other.directoryId) return false
        if (directoryName != other.directoryName) return false
        if (directoryType != other.directoryType) return false
        if (dnsIpAddresses != other.dnsIpAddresses) return false
        if (iamRoleId != other.iamRoleId) return false
        if (ipGroupIds != other.ipGroupIds) return false
        if (registrationCode != other.registrationCode) return false
        if (samlProperties != other.samlProperties) return false
        if (selfservicePermissions != other.selfservicePermissions) return false
        if (state != other.state) return false
        if (subnetIds != other.subnetIds) return false
        if (tenancy != other.tenancy) return false
        if (workspaceAccessProperties != other.workspaceAccessProperties) return false
        if (workspaceCreationProperties != other.workspaceCreationProperties) return false
        if (workspaceSecurityGroupId != other.workspaceSecurityGroupId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.WorkspaceDirectory = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The directory alias.
         */
        public var alias: kotlin.String? = null
        /**
         * The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory for WorkSpaces login.
         */
        public var certificateBasedAuthProperties: aws.sdk.kotlin.services.workspaces.model.CertificateBasedAuthProperties? = null
        /**
         * The user name for the service account.
         */
        public var customerUserName: kotlin.String? = null
        /**
         * The directory identifier.
         */
        public var directoryId: kotlin.String? = null
        /**
         * The name of the directory.
         */
        public var directoryName: kotlin.String? = null
        /**
         * The directory type.
         */
        public var directoryType: aws.sdk.kotlin.services.workspaces.model.WorkspaceDirectoryType? = null
        /**
         * The IP addresses of the DNS servers for the directory.
         */
        public var dnsIpAddresses: List<String>? = null
        /**
         * The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other services, such as Amazon EC2, on your behalf.
         */
        public var iamRoleId: kotlin.String? = null
        /**
         * The identifiers of the IP access control groups associated with the directory.
         */
        public var ipGroupIds: List<String>? = null
        /**
         * The registration code for the directory. This is the code that users enter in their Amazon WorkSpaces client application to connect to the directory.
         */
        public var registrationCode: kotlin.String? = null
        /**
         * Describes the enablement status, user access URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.
         */
        public var samlProperties: aws.sdk.kotlin.services.workspaces.model.SamlProperties? = null
        /**
         * The default self-service permissions for WorkSpaces in the directory.
         */
        public var selfservicePermissions: aws.sdk.kotlin.services.workspaces.model.SelfservicePermissions? = null
        /**
         * The state of the directory's registration with Amazon WorkSpaces. After a directory is deregistered, the `DEREGISTERED` state is returned very briefly before the directory metadata is cleaned up, so this state is rarely returned. To confirm that a directory is deregistered, check for the directory ID by using [ DescribeWorkspaceDirectories](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html). If the directory ID isn't returned, then the directory has been successfully deregistered.
         */
        public var state: aws.sdk.kotlin.services.workspaces.model.WorkspaceDirectoryState? = null
        /**
         * The identifiers of the subnets used with the directory.
         */
        public var subnetIds: List<String>? = null
        /**
         * Specifies whether the directory is dedicated or shared. To use Bring Your Own License (BYOL), this value must be set to `DEDICATED`. For more information, see [Bring Your Own Windows Desktop Images](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
         */
        public var tenancy: aws.sdk.kotlin.services.workspaces.model.Tenancy? = null
        /**
         * The devices and operating systems that users can use to access WorkSpaces.
         */
        public var workspaceAccessProperties: aws.sdk.kotlin.services.workspaces.model.WorkspaceAccessProperties? = null
        /**
         * The default creation properties for all WorkSpaces in the directory.
         */
        public var workspaceCreationProperties: aws.sdk.kotlin.services.workspaces.model.DefaultWorkspaceCreationProperties? = null
        /**
         * The identifier of the security group that is assigned to new WorkSpaces.
         */
        public var workspaceSecurityGroupId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.WorkspaceDirectory) : this() {
            this.alias = x.alias
            this.certificateBasedAuthProperties = x.certificateBasedAuthProperties
            this.customerUserName = x.customerUserName
            this.directoryId = x.directoryId
            this.directoryName = x.directoryName
            this.directoryType = x.directoryType
            this.dnsIpAddresses = x.dnsIpAddresses
            this.iamRoleId = x.iamRoleId
            this.ipGroupIds = x.ipGroupIds
            this.registrationCode = x.registrationCode
            this.samlProperties = x.samlProperties
            this.selfservicePermissions = x.selfservicePermissions
            this.state = x.state
            this.subnetIds = x.subnetIds
            this.tenancy = x.tenancy
            this.workspaceAccessProperties = x.workspaceAccessProperties
            this.workspaceCreationProperties = x.workspaceCreationProperties
            this.workspaceSecurityGroupId = x.workspaceSecurityGroupId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.WorkspaceDirectory = WorkspaceDirectory(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.CertificateBasedAuthProperties] inside the given [block]
         */
        public fun certificateBasedAuthProperties(block: aws.sdk.kotlin.services.workspaces.model.CertificateBasedAuthProperties.Builder.() -> kotlin.Unit) {
            this.certificateBasedAuthProperties = aws.sdk.kotlin.services.workspaces.model.CertificateBasedAuthProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.SamlProperties] inside the given [block]
         */
        public fun samlProperties(block: aws.sdk.kotlin.services.workspaces.model.SamlProperties.Builder.() -> kotlin.Unit) {
            this.samlProperties = aws.sdk.kotlin.services.workspaces.model.SamlProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.SelfservicePermissions] inside the given [block]
         */
        public fun selfservicePermissions(block: aws.sdk.kotlin.services.workspaces.model.SelfservicePermissions.Builder.() -> kotlin.Unit) {
            this.selfservicePermissions = aws.sdk.kotlin.services.workspaces.model.SelfservicePermissions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.WorkspaceAccessProperties] inside the given [block]
         */
        public fun workspaceAccessProperties(block: aws.sdk.kotlin.services.workspaces.model.WorkspaceAccessProperties.Builder.() -> kotlin.Unit) {
            this.workspaceAccessProperties = aws.sdk.kotlin.services.workspaces.model.WorkspaceAccessProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.DefaultWorkspaceCreationProperties] inside the given [block]
         */
        public fun workspaceCreationProperties(block: aws.sdk.kotlin.services.workspaces.model.DefaultWorkspaceCreationProperties.Builder.() -> kotlin.Unit) {
            this.workspaceCreationProperties = aws.sdk.kotlin.services.workspaces.model.DefaultWorkspaceCreationProperties.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
