// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the association between an application and an image resource.
 */
public class ImageResourceAssociation private constructor(builder: Builder) {
    /**
     * The identifier of the associated resource.
     */
    public val associatedResourceId: kotlin.String? = builder.associatedResourceId
    /**
     * The resource type of the associated resources.
     */
    public val associatedResourceType: aws.sdk.kotlin.services.workspaces.model.ImageAssociatedResourceType? = builder.associatedResourceType
    /**
     * The time the association is created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The identifier of the image.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The time the association status was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The status of the image resource association.
     */
    public val state: aws.sdk.kotlin.services.workspaces.model.AssociationState? = builder.state
    /**
     * The reason the association deployment failed.
     */
    public val stateReason: aws.sdk.kotlin.services.workspaces.model.AssociationStateReason? = builder.stateReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.ImageResourceAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageResourceAssociation(")
        append("associatedResourceId=$associatedResourceId,")
        append("associatedResourceType=$associatedResourceType,")
        append("created=$created,")
        append("imageId=$imageId,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("state=$state,")
        append("stateReason=$stateReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedResourceId?.hashCode() ?: 0
        result = 31 * result + (associatedResourceType?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageResourceAssociation

        if (associatedResourceId != other.associatedResourceId) return false
        if (associatedResourceType != other.associatedResourceType) return false
        if (created != other.created) return false
        if (imageId != other.imageId) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.ImageResourceAssociation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the associated resource.
         */
        public var associatedResourceId: kotlin.String? = null
        /**
         * The resource type of the associated resources.
         */
        public var associatedResourceType: aws.sdk.kotlin.services.workspaces.model.ImageAssociatedResourceType? = null
        /**
         * The time the association is created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the image.
         */
        public var imageId: kotlin.String? = null
        /**
         * The time the association status was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the image resource association.
         */
        public var state: aws.sdk.kotlin.services.workspaces.model.AssociationState? = null
        /**
         * The reason the association deployment failed.
         */
        public var stateReason: aws.sdk.kotlin.services.workspaces.model.AssociationStateReason? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.ImageResourceAssociation) : this() {
            this.associatedResourceId = x.associatedResourceId
            this.associatedResourceType = x.associatedResourceType
            this.created = x.created
            this.imageId = x.imageId
            this.lastUpdatedTime = x.lastUpdatedTime
            this.state = x.state
            this.stateReason = x.stateReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.ImageResourceAssociation = ImageResourceAssociation(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.AssociationStateReason] inside the given [block]
         */
        public fun stateReason(block: aws.sdk.kotlin.services.workspaces.model.AssociationStateReason.Builder.() -> kotlin.Unit) {
            this.stateReason = aws.sdk.kotlin.services.workspaces.model.AssociationStateReason.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
