// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model



/**
 * The default client branding attributes to be imported. These attributes display on the client login screen.
 *
 * Client branding attributes are public facing. Ensure that you do not include sensitive information.
 */
public class DefaultImportClientBrandingAttributes private constructor(builder: Builder) {
    /**
     * The forgotten password link. This is the web address that users can go to if they forget the password for their WorkSpace.
     */
    public val forgotPasswordLink: kotlin.String? = builder.forgotPasswordLink
    /**
     * The login message. Specified as a key value pair, in which the key is a locale and the value is the localized message for that locale. The only key supported is `en_US`. The HTML tags supported include the following: `a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul`.
     */
    public val loginMessage: Map<String, String>? = builder.loginMessage
    /**
     * The logo. The only image format accepted is a binary data object that is converted from a `.png` file.
     */
    public val logo: kotlin.ByteArray? = builder.logo
    /**
     * The support email. The company's customer support email address.
     *
     * + In each platform type, the `SupportEmail` and `SupportLink` parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.
     * + The default email is `workspaces-feedback@amazon.com`.
     */
    public val supportEmail: kotlin.String? = builder.supportEmail
    /**
     * The support link. The link for the company's customer support page for their WorkSpace.
     *
     * + In each platform type, the `SupportEmail` and `SupportLink` parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.
     * + The default support link is `workspaces-feedback@amazon.com`.
     */
    public val supportLink: kotlin.String? = builder.supportLink

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.DefaultImportClientBrandingAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DefaultImportClientBrandingAttributes(")
        append("forgotPasswordLink=$forgotPasswordLink,")
        append("loginMessage=$loginMessage,")
        append("logo=$logo,")
        append("supportEmail=$supportEmail,")
        append("supportLink=$supportLink")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = forgotPasswordLink?.hashCode() ?: 0
        result = 31 * result + (loginMessage?.hashCode() ?: 0)
        result = 31 * result + (logo?.contentHashCode() ?: 0)
        result = 31 * result + (supportEmail?.hashCode() ?: 0)
        result = 31 * result + (supportLink?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DefaultImportClientBrandingAttributes

        if (forgotPasswordLink != other.forgotPasswordLink) return false
        if (loginMessage != other.loginMessage) return false
        if (logo != null) {
            if (other.logo == null) return false
            if (!logo.contentEquals(other.logo)) return false
        } else if (other.logo != null) return false
        if (supportEmail != other.supportEmail) return false
        if (supportLink != other.supportLink) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.DefaultImportClientBrandingAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The forgotten password link. This is the web address that users can go to if they forget the password for their WorkSpace.
         */
        public var forgotPasswordLink: kotlin.String? = null
        /**
         * The login message. Specified as a key value pair, in which the key is a locale and the value is the localized message for that locale. The only key supported is `en_US`. The HTML tags supported include the following: `a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul`.
         */
        public var loginMessage: Map<String, String>? = null
        /**
         * The logo. The only image format accepted is a binary data object that is converted from a `.png` file.
         */
        public var logo: kotlin.ByteArray? = null
        /**
         * The support email. The company's customer support email address.
         *
         * + In each platform type, the `SupportEmail` and `SupportLink` parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.
         * + The default email is `workspaces-feedback@amazon.com`.
         */
        public var supportEmail: kotlin.String? = null
        /**
         * The support link. The link for the company's customer support page for their WorkSpace.
         *
         * + In each platform type, the `SupportEmail` and `SupportLink` parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.
         * + The default support link is `workspaces-feedback@amazon.com`.
         */
        public var supportLink: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.DefaultImportClientBrandingAttributes) : this() {
            this.forgotPasswordLink = x.forgotPasswordLink
            this.loginMessage = x.loginMessage
            this.logo = x.logo
            this.supportEmail = x.supportEmail
            this.supportLink = x.supportLink
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.DefaultImportClientBrandingAttributes = DefaultImportClientBrandingAttributes(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
