// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.workspaces.auth.DefaultWorkSpacesAuthSchemeProvider
import aws.sdk.kotlin.services.workspaces.auth.WorkSpacesAuthSchemeProvider
import aws.sdk.kotlin.services.workspaces.endpoints.DefaultWorkSpacesEndpointProvider
import aws.sdk.kotlin.services.workspaces.endpoints.WorkSpacesEndpointParameters
import aws.sdk.kotlin.services.workspaces.endpoints.WorkSpacesEndpointProvider
import aws.sdk.kotlin.services.workspaces.model.AssociateConnectionAliasRequest
import aws.sdk.kotlin.services.workspaces.model.AssociateConnectionAliasResponse
import aws.sdk.kotlin.services.workspaces.model.AssociateIpGroupsRequest
import aws.sdk.kotlin.services.workspaces.model.AssociateIpGroupsResponse
import aws.sdk.kotlin.services.workspaces.model.AssociateWorkspaceApplicationRequest
import aws.sdk.kotlin.services.workspaces.model.AssociateWorkspaceApplicationResponse
import aws.sdk.kotlin.services.workspaces.model.AuthorizeIpRulesRequest
import aws.sdk.kotlin.services.workspaces.model.AuthorizeIpRulesResponse
import aws.sdk.kotlin.services.workspaces.model.CopyWorkspaceImageRequest
import aws.sdk.kotlin.services.workspaces.model.CopyWorkspaceImageResponse
import aws.sdk.kotlin.services.workspaces.model.CreateConnectClientAddInRequest
import aws.sdk.kotlin.services.workspaces.model.CreateConnectClientAddInResponse
import aws.sdk.kotlin.services.workspaces.model.CreateConnectionAliasRequest
import aws.sdk.kotlin.services.workspaces.model.CreateConnectionAliasResponse
import aws.sdk.kotlin.services.workspaces.model.CreateIpGroupRequest
import aws.sdk.kotlin.services.workspaces.model.CreateIpGroupResponse
import aws.sdk.kotlin.services.workspaces.model.CreateStandbyWorkspacesRequest
import aws.sdk.kotlin.services.workspaces.model.CreateStandbyWorkspacesResponse
import aws.sdk.kotlin.services.workspaces.model.CreateTagsRequest
import aws.sdk.kotlin.services.workspaces.model.CreateTagsResponse
import aws.sdk.kotlin.services.workspaces.model.CreateUpdatedWorkspaceImageRequest
import aws.sdk.kotlin.services.workspaces.model.CreateUpdatedWorkspaceImageResponse
import aws.sdk.kotlin.services.workspaces.model.CreateWorkspaceBundleRequest
import aws.sdk.kotlin.services.workspaces.model.CreateWorkspaceBundleResponse
import aws.sdk.kotlin.services.workspaces.model.CreateWorkspaceImageRequest
import aws.sdk.kotlin.services.workspaces.model.CreateWorkspaceImageResponse
import aws.sdk.kotlin.services.workspaces.model.CreateWorkspacesRequest
import aws.sdk.kotlin.services.workspaces.model.CreateWorkspacesResponse
import aws.sdk.kotlin.services.workspaces.model.DeleteClientBrandingRequest
import aws.sdk.kotlin.services.workspaces.model.DeleteClientBrandingResponse
import aws.sdk.kotlin.services.workspaces.model.DeleteConnectClientAddInRequest
import aws.sdk.kotlin.services.workspaces.model.DeleteConnectClientAddInResponse
import aws.sdk.kotlin.services.workspaces.model.DeleteConnectionAliasRequest
import aws.sdk.kotlin.services.workspaces.model.DeleteConnectionAliasResponse
import aws.sdk.kotlin.services.workspaces.model.DeleteIpGroupRequest
import aws.sdk.kotlin.services.workspaces.model.DeleteIpGroupResponse
import aws.sdk.kotlin.services.workspaces.model.DeleteTagsRequest
import aws.sdk.kotlin.services.workspaces.model.DeleteTagsResponse
import aws.sdk.kotlin.services.workspaces.model.DeleteWorkspaceBundleRequest
import aws.sdk.kotlin.services.workspaces.model.DeleteWorkspaceBundleResponse
import aws.sdk.kotlin.services.workspaces.model.DeleteWorkspaceImageRequest
import aws.sdk.kotlin.services.workspaces.model.DeleteWorkspaceImageResponse
import aws.sdk.kotlin.services.workspaces.model.DeployWorkspaceApplicationsRequest
import aws.sdk.kotlin.services.workspaces.model.DeployWorkspaceApplicationsResponse
import aws.sdk.kotlin.services.workspaces.model.DeregisterWorkspaceDirectoryRequest
import aws.sdk.kotlin.services.workspaces.model.DeregisterWorkspaceDirectoryResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeAccountModificationsRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeAccountModificationsResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeAccountRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeAccountResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeApplicationAssociationsRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeApplicationAssociationsResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeApplicationsRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeApplicationsResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeBundleAssociationsRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeBundleAssociationsResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeClientBrandingRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeClientBrandingResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeClientPropertiesRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeClientPropertiesResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeConnectClientAddInsRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeConnectClientAddInsResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeConnectionAliasPermissionsRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeConnectionAliasPermissionsResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeConnectionAliasesRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeConnectionAliasesResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeImageAssociationsRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeImageAssociationsResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeIpGroupsRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeIpGroupsResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeTagsRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeTagsResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceAssociationsRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceAssociationsResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceBundlesRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceBundlesResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceDirectoriesRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceDirectoriesResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceImagesRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceImagesResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceSnapshotsRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceSnapshotsResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspacesRequest
import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspacesResponse
import aws.sdk.kotlin.services.workspaces.model.DisassociateConnectionAliasRequest
import aws.sdk.kotlin.services.workspaces.model.DisassociateConnectionAliasResponse
import aws.sdk.kotlin.services.workspaces.model.DisassociateIpGroupsRequest
import aws.sdk.kotlin.services.workspaces.model.DisassociateIpGroupsResponse
import aws.sdk.kotlin.services.workspaces.model.DisassociateWorkspaceApplicationRequest
import aws.sdk.kotlin.services.workspaces.model.DisassociateWorkspaceApplicationResponse
import aws.sdk.kotlin.services.workspaces.model.ImportClientBrandingRequest
import aws.sdk.kotlin.services.workspaces.model.ImportClientBrandingResponse
import aws.sdk.kotlin.services.workspaces.model.ImportWorkspaceImageRequest
import aws.sdk.kotlin.services.workspaces.model.ImportWorkspaceImageResponse
import aws.sdk.kotlin.services.workspaces.model.ListAvailableManagementCidrRangesRequest
import aws.sdk.kotlin.services.workspaces.model.ListAvailableManagementCidrRangesResponse
import aws.sdk.kotlin.services.workspaces.model.MigrateWorkspaceRequest
import aws.sdk.kotlin.services.workspaces.model.MigrateWorkspaceResponse
import aws.sdk.kotlin.services.workspaces.model.ModifyAccountRequest
import aws.sdk.kotlin.services.workspaces.model.ModifyAccountResponse
import aws.sdk.kotlin.services.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest
import aws.sdk.kotlin.services.workspaces.model.ModifyCertificateBasedAuthPropertiesResponse
import aws.sdk.kotlin.services.workspaces.model.ModifyClientPropertiesRequest
import aws.sdk.kotlin.services.workspaces.model.ModifyClientPropertiesResponse
import aws.sdk.kotlin.services.workspaces.model.ModifySamlPropertiesRequest
import aws.sdk.kotlin.services.workspaces.model.ModifySamlPropertiesResponse
import aws.sdk.kotlin.services.workspaces.model.ModifySelfservicePermissionsRequest
import aws.sdk.kotlin.services.workspaces.model.ModifySelfservicePermissionsResponse
import aws.sdk.kotlin.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest
import aws.sdk.kotlin.services.workspaces.model.ModifyWorkspaceAccessPropertiesResponse
import aws.sdk.kotlin.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest
import aws.sdk.kotlin.services.workspaces.model.ModifyWorkspaceCreationPropertiesResponse
import aws.sdk.kotlin.services.workspaces.model.ModifyWorkspacePropertiesRequest
import aws.sdk.kotlin.services.workspaces.model.ModifyWorkspacePropertiesResponse
import aws.sdk.kotlin.services.workspaces.model.ModifyWorkspaceStateRequest
import aws.sdk.kotlin.services.workspaces.model.ModifyWorkspaceStateResponse
import aws.sdk.kotlin.services.workspaces.model.RebootWorkspacesRequest
import aws.sdk.kotlin.services.workspaces.model.RebootWorkspacesResponse
import aws.sdk.kotlin.services.workspaces.model.RebuildWorkspacesRequest
import aws.sdk.kotlin.services.workspaces.model.RebuildWorkspacesResponse
import aws.sdk.kotlin.services.workspaces.model.RegisterWorkspaceDirectoryRequest
import aws.sdk.kotlin.services.workspaces.model.RegisterWorkspaceDirectoryResponse
import aws.sdk.kotlin.services.workspaces.model.RestoreWorkspaceRequest
import aws.sdk.kotlin.services.workspaces.model.RestoreWorkspaceResponse
import aws.sdk.kotlin.services.workspaces.model.RevokeIpRulesRequest
import aws.sdk.kotlin.services.workspaces.model.RevokeIpRulesResponse
import aws.sdk.kotlin.services.workspaces.model.StartWorkspacesRequest
import aws.sdk.kotlin.services.workspaces.model.StartWorkspacesResponse
import aws.sdk.kotlin.services.workspaces.model.StopWorkspacesRequest
import aws.sdk.kotlin.services.workspaces.model.StopWorkspacesResponse
import aws.sdk.kotlin.services.workspaces.model.TerminateWorkspacesRequest
import aws.sdk.kotlin.services.workspaces.model.TerminateWorkspacesResponse
import aws.sdk.kotlin.services.workspaces.model.UpdateConnectClientAddInRequest
import aws.sdk.kotlin.services.workspaces.model.UpdateConnectClientAddInResponse
import aws.sdk.kotlin.services.workspaces.model.UpdateConnectionAliasPermissionRequest
import aws.sdk.kotlin.services.workspaces.model.UpdateConnectionAliasPermissionResponse
import aws.sdk.kotlin.services.workspaces.model.UpdateRulesOfIpGroupRequest
import aws.sdk.kotlin.services.workspaces.model.UpdateRulesOfIpGroupResponse
import aws.sdk.kotlin.services.workspaces.model.UpdateWorkspaceBundleRequest
import aws.sdk.kotlin.services.workspaces.model.UpdateWorkspaceBundleResponse
import aws.sdk.kotlin.services.workspaces.model.UpdateWorkspaceImagePermissionRequest
import aws.sdk.kotlin.services.workspaces.model.UpdateWorkspaceImagePermissionResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "WorkSpaces"
public const val SdkVersion: String = "1.0.26"
public const val ServiceApiVersion: String = "2015-04-08"

/**
 * # Amazon WorkSpaces Service
 * Amazon WorkSpaces enables you to provision virtual, cloud-based Microsoft Windows or Amazon Linux desktops for your users, known as *WorkSpaces*. WorkSpaces eliminates the need to procure and deploy hardware or install complex software. You can quickly add or remove users as your needs change. Users can access their virtual desktops from multiple devices or web browsers.
 *
 * This API Reference provides detailed information about the actions, data types, parameters, and errors of the WorkSpaces service. For more information about the supported Amazon Web Services Regions, endpoints, and service quotas of the Amazon WorkSpaces service, see [WorkSpaces endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/wsp.html) in the *Amazon Web Services General Reference*.
 *
 * You can also manage your WorkSpaces resources using the WorkSpaces console, Command Line Interface (CLI), and SDKs. For more information about administering WorkSpaces, see the [Amazon WorkSpaces Administration Guide](https://docs.aws.amazon.com/workspaces/latest/adminguide/). For more information about using the Amazon WorkSpaces client application or web browser to access provisioned WorkSpaces, see the [Amazon WorkSpaces User Guide](https://docs.aws.amazon.com/workspaces/latest/userguide/). For more information about using the CLI to manage your WorkSpaces resources, see the [WorkSpaces section of the CLI Reference](https://docs.aws.amazon.com/cli/latest/reference/workspaces/index.html).
 */
public interface WorkSpacesClient : SdkClient {
    /**
     * WorkSpacesClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, WorkSpacesClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "WorkSpaces",
                "WORKSPACES",
                "workspaces",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, WorkSpacesClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): WorkSpacesClient = DefaultWorkSpacesClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: WorkSpacesEndpointProvider = builder.endpointProvider ?: DefaultWorkSpacesEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: WorkSpacesAuthSchemeProvider = builder.authSchemeProvider ?: DefaultWorkSpacesAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "WorkSpaces"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: WorkSpacesEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: WorkSpacesAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates the specified connection alias with the specified directory to enable cross-Region redirection. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     *
     * Before performing this operation, call [ DescribeConnectionAliases](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html) to make sure that the current state of the connection alias is `CREATED`.
     */
    public suspend fun associateConnectionAlias(input: AssociateConnectionAliasRequest): AssociateConnectionAliasResponse

    /**
     * Associates the specified IP access control group with the specified directory.
     */
    public suspend fun associateIpGroups(input: AssociateIpGroupsRequest): AssociateIpGroupsResponse

    /**
     * Associates the specified application to the specified WorkSpace.
     */
    public suspend fun associateWorkspaceApplication(input: AssociateWorkspaceApplicationRequest): AssociateWorkspaceApplicationResponse

    /**
     * Adds one or more rules to the specified IP access control group.
     *
     * This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the rules.
     */
    public suspend fun authorizeIpRules(input: AuthorizeIpRulesRequest): AuthorizeIpRulesResponse

    /**
     * Copies the specified image from the specified Region to the current Region. For more information about copying images, see [ Copy a Custom WorkSpaces Image](https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html).
     *
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     *
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services Support.
     *
     * Before copying a shared image, be sure to verify that it has been shared from the correct Amazon Web Services account. To determine if an image has been shared and to see the ID of the Amazon Web Services account that owns an image, use the [DescribeWorkSpaceImages](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html) and [DescribeWorkspaceImagePermissions](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html) API operations.
     */
    public suspend fun copyWorkspaceImage(input: CopyWorkspaceImageRequest): CopyWorkspaceImageResponse

    /**
     * Creates a client-add-in for Amazon Connect within a directory. You can create only one Amazon Connect client add-in within a directory.
     *
     * This client add-in allows WorkSpaces users to seamlessly connect to Amazon Connect.
     */
    public suspend fun createConnectClientAddIn(input: CreateConnectClientAddInRequest): CreateConnectClientAddInResponse

    /**
     * Creates the specified connection alias for use with cross-Region redirection. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     */
    public suspend fun createConnectionAlias(input: CreateConnectionAliasRequest): CreateConnectionAliasResponse

    /**
     * Creates an IP access control group.
     *
     * An IP access control group provides you with the ability to control the IP addresses from which users are allowed to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and then associate the group with your directory. You can add rules when you create the group or at any time using AuthorizeIpRules.
     *
     * There is a default IP access control group associated with your directory. If you don't associate an IP access control group with your directory, the default group is used. The default group includes a default rule that allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for your directory.
     */
    public suspend fun createIpGroup(input: CreateIpGroupRequest): CreateIpGroupResponse

    /**
     * Creates a standby WorkSpace in a secondary Region.
     */
    public suspend fun createStandbyWorkspaces(input: CreateStandbyWorkspacesRequest): CreateStandbyWorkspacesResponse

    /**
     * Creates the specified tags for the specified WorkSpaces resource.
     */
    public suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse

    /**
     * Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has the latest drivers and other updates required by the Amazon WorkSpaces components.
     *
     * To determine which WorkSpace images need to be updated with the latest Amazon WorkSpaces requirements, use [ DescribeWorkspaceImages](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html).
     *
     * + Only Windows 10, Windows Server 2016, and Windows Server 2019 WorkSpace images can be programmatically updated at this time.
     * + Microsoft Windows updates and other application updates are not included in the update process.
     * + The source WorkSpace image is not deleted. You can delete the source image after you've verified your new updated image and created a new bundle.
     */
    public suspend fun createUpdatedWorkspaceImage(input: CreateUpdatedWorkspaceImageRequest): CreateUpdatedWorkspaceImageResponse

    /**
     * Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see [ Create a Custom WorkSpaces Image and Bundle](https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html).
     */
    public suspend fun createWorkspaceBundle(input: CreateWorkspaceBundleRequest): CreateWorkspaceBundleResponse

    /**
     * Creates a new WorkSpace image from an existing WorkSpace.
     */
    public suspend fun createWorkspaceImage(input: CreateWorkspaceImageRequest): CreateWorkspaceImageResponse

    /**
     * Creates one or more WorkSpaces.
     *
     * This operation is asynchronous and returns before the WorkSpaces are created.
     *
     * + The `MANUAL` running mode value is only supported by Amazon WorkSpaces Core. Contact your account team to be allow-listed to use this value. For more information, see [Amazon WorkSpaces Core](http://aws.amazon.com/workspaces/core/).
     * + You don't need to specify the `PCOIP` protocol for Linux bundles because `WSP` is the default protocol for those bundles.
     * + Ensure you review your running mode to ensure you are using a running mode that is optimal for your needs and budget. For more information on switching running modes, see [ Can I switch between hourly and monthly billing?](https://aws.amazon.com/workspaces/faqs/#:~:text=Q%3A%20Can%20I%20switch%20between%20hourly%20and%20monthly%20billing%3F)
     */
    public suspend fun createWorkspaces(input: CreateWorkspacesRequest): CreateWorkspacesResponse

    /**
     * Deletes customized client branding. Client branding allows you to customize your WorkSpace's client login portal. You can tailor your login portal company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.
     *
     * After you delete your customized client branding, your login portal reverts to the default client branding.
     */
    public suspend fun deleteClientBranding(input: DeleteClientBrandingRequest): DeleteClientBrandingResponse

    /**
     * Deletes a client-add-in for Amazon Connect that is configured within a directory.
     */
    public suspend fun deleteConnectClientAddIn(input: DeleteConnectClientAddInRequest): DeleteConnectClientAddInResponse

    /**
     * Deletes the specified connection alias. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     *
     * **If you will no longer be using a fully qualified domain name (FQDN) as the registration code for your WorkSpaces users, you must take certain precautions to prevent potential security issues.** For more information, see [ Security Considerations if You Stop Using Cross-Region Redirection](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations).
     *
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.
     */
    public suspend fun deleteConnectionAlias(input: DeleteConnectionAliasRequest): DeleteConnectionAliasResponse

    /**
     * Deletes the specified IP access control group.
     *
     * You cannot delete an IP access control group that is associated with a directory.
     */
    public suspend fun deleteIpGroup(input: DeleteIpGroupRequest): DeleteIpGroupResponse

    /**
     * Deletes the specified tags from the specified WorkSpaces resource.
     */
    public suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see [ Delete a Custom WorkSpaces Bundle or Image](https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html).
     */
    public suspend fun deleteWorkspaceBundle(input: DeleteWorkspaceBundleRequest = DeleteWorkspaceBundleRequest { }): DeleteWorkspaceBundleResponse

    /**
     * Deletes the specified image from your account. To delete an image, you must first delete any bundles that are associated with the image and unshare the image if it is shared with other accounts.
     */
    public suspend fun deleteWorkspaceImage(input: DeleteWorkspaceImageRequest): DeleteWorkspaceImageResponse

    /**
     * Deploys associated applications to the specified WorkSpace
     */
    public suspend fun deployWorkspaceApplications(input: DeployWorkspaceApplicationsRequest): DeployWorkspaceApplicationsResponse

    /**
     * Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister the directory.
     *
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the [Directory Service pricing terms](http://aws.amazon.com/directoryservice/pricing/).
     *
     * To delete empty directories, see [ Delete the Directory for Your WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html). If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.
     */
    public suspend fun deregisterWorkspaceDirectory(input: DeregisterWorkspaceDirectoryRequest): DeregisterWorkspaceDirectoryResponse

    /**
     * Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.
     */
    public suspend fun describeAccount(input: DescribeAccountRequest = DescribeAccountRequest { }): DescribeAccountResponse

    /**
     * Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the specified account.
     */
    public suspend fun describeAccountModifications(input: DescribeAccountModificationsRequest = DescribeAccountModificationsRequest { }): DescribeAccountModificationsResponse

    /**
     * Describes the associations between the application and the specified associated resources.
     */
    public suspend fun describeApplicationAssociations(input: DescribeApplicationAssociationsRequest): DescribeApplicationAssociationsResponse

    /**
     * Describes the specified applications by filtering based on their compute types, license availability, operating systems, and owners.
     */
    public suspend fun describeApplications(input: DescribeApplicationsRequest = DescribeApplicationsRequest { }): DescribeApplicationsResponse

    /**
     * Describes the associations between the applications and the specified bundle.
     */
    public suspend fun describeBundleAssociations(input: DescribeBundleAssociationsRequest): DescribeBundleAssociationsResponse

    /**
     * Describes the specified client branding. Client branding allows you to customize the log in page of various device types for your users. You can add your company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.
     *
     * Only device types that have branding information configured will be shown in the response.
     */
    public suspend fun describeClientBranding(input: DescribeClientBrandingRequest): DescribeClientBrandingResponse

    /**
     * Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
     */
    public suspend fun describeClientProperties(input: DescribeClientPropertiesRequest): DescribeClientPropertiesResponse

    /**
     * Retrieves a list of Amazon Connect client add-ins that have been created.
     */
    public suspend fun describeConnectClientAddIns(input: DescribeConnectClientAddInsRequest): DescribeConnectClientAddInsResponse

    /**
     * Describes the permissions that the owner of a connection alias has granted to another Amazon Web Services account for the specified connection alias. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     */
    public suspend fun describeConnectionAliasPermissions(input: DescribeConnectionAliasPermissionsRequest): DescribeConnectionAliasPermissionsResponse

    /**
     * Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     */
    public suspend fun describeConnectionAliases(input: DescribeConnectionAliasesRequest = DescribeConnectionAliasesRequest { }): DescribeConnectionAliasesResponse

    /**
     * Describes the associations between the applications and the specified image.
     */
    public suspend fun describeImageAssociations(input: DescribeImageAssociationsRequest): DescribeImageAssociationsResponse

    /**
     * Describes one or more of your IP access control groups.
     */
    public suspend fun describeIpGroups(input: DescribeIpGroupsRequest = DescribeIpGroupsRequest { }): DescribeIpGroupsResponse

    /**
     * Describes the specified tags for the specified WorkSpaces resource.
     */
    public suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse

    /**
     * Describes the associations betweens applications and the specified WorkSpace.
     */
    public suspend fun describeWorkspaceAssociations(input: DescribeWorkspaceAssociationsRequest): DescribeWorkspaceAssociationsResponse

    /**
     * Retrieves a list that describes the available WorkSpace bundles.
     *
     * You can filter the results using either bundle ID or owner, but not both.
     */
    public suspend fun describeWorkspaceBundles(input: DescribeWorkspaceBundlesRequest = DescribeWorkspaceBundlesRequest { }): DescribeWorkspaceBundlesResponse

    /**
     * Describes the available directories that are registered with Amazon WorkSpaces.
     */
    public suspend fun describeWorkspaceDirectories(input: DescribeWorkspaceDirectoriesRequest = DescribeWorkspaceDirectoriesRequest { }): DescribeWorkspaceDirectoriesResponse

    /**
     * Describes the permissions that the owner of an image has granted to other Amazon Web Services accounts for an image.
     */
    public suspend fun describeWorkspaceImagePermissions(input: DescribeWorkspaceImagePermissionsRequest): DescribeWorkspaceImagePermissionsResponse

    /**
     * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise, all images in the account are described.
     */
    public suspend fun describeWorkspaceImages(input: DescribeWorkspaceImagesRequest = DescribeWorkspaceImagesRequest { }): DescribeWorkspaceImagesResponse

    /**
     * Describes the snapshots for the specified WorkSpace.
     */
    public suspend fun describeWorkspaceSnapshots(input: DescribeWorkspaceSnapshotsRequest): DescribeWorkspaceSnapshotsResponse

    /**
     * Describes the specified WorkSpaces.
     *
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify only one filter at a time.
     */
    public suspend fun describeWorkspaces(input: DescribeWorkspacesRequest = DescribeWorkspacesRequest { }): DescribeWorkspacesResponse

    /**
     * Describes the connection status of the specified WorkSpaces.
     */
    public suspend fun describeWorkspacesConnectionStatus(input: DescribeWorkspacesConnectionStatusRequest = DescribeWorkspacesConnectionStatusRequest { }): DescribeWorkspacesConnectionStatusResponse

    /**
     * Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region redirection between two directories in different Regions. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     *
     * Before performing this operation, call [ DescribeConnectionAliases](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html) to make sure that the current state of the connection alias is `CREATED`.
     */
    public suspend fun disassociateConnectionAlias(input: DisassociateConnectionAliasRequest): DisassociateConnectionAliasResponse

    /**
     * Disassociates the specified IP access control group from the specified directory.
     */
    public suspend fun disassociateIpGroups(input: DisassociateIpGroupsRequest): DisassociateIpGroupsResponse

    /**
     * Disassociates the specified application from a WorkSpace.
     */
    public suspend fun disassociateWorkspaceApplication(input: DisassociateWorkspaceApplicationRequest): DisassociateWorkspaceApplicationResponse

    /**
     * Imports client branding. Client branding allows you to customize your WorkSpace's client login portal. You can tailor your login portal company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.
     *
     * After you import client branding, the default branding experience for the specified platform type is replaced with the imported experience
     *
     * + You must specify at least one platform type when importing client branding.
     * + You can import up to 6 MB of data with each request. If your request exceeds this limit, you can import client branding for different platform types using separate requests.
     * + In each platform type, the `SupportEmail` and `SupportLink` parameters are mutually exclusive. You can specify only one parameter for each platform type, but not both.
     * + Imported data can take up to a minute to appear in the WorkSpaces client.
     */
    public suspend fun importClientBranding(input: ImportClientBrandingRequest): ImportClientBrandingResponse

    /**
     * Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image. For more information about creating BYOL images, see [ Bring Your Own Windows Desktop Licenses](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
     */
    public suspend fun importWorkspaceImage(input: ImportWorkspaceImageRequest): ImportWorkspaceImageResponse

    /**
     * Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management interface when you enable Bring Your Own License (BYOL).
     *
     * This operation can be run only by Amazon Web Services accounts that are enabled for BYOL. If your account isn't enabled for BYOL, you'll receive an `AccessDeniedException` error.
     *
     * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage the WorkSpace.
     */
    public suspend fun listAvailableManagementCidrRanges(input: ListAvailableManagementCidrRangesRequest): ListAvailableManagementCidrRangesResponse

    /**
     * Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user volume.
     *
     * The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the user volume from the last available snapshot of the original WorkSpace. During migration, the original `D:\Users\%USERNAME%` user profile folder is renamed to `D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated`. A new `D:\Users\%USERNAME%\` folder is generated by the new OS. Certain files in the old user profile are moved to the new user profile.
     *
     * For available migration scenarios, details about what happens during migration, and best practices, see [Migrate a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html).
     */
    public suspend fun migrateWorkspace(input: MigrateWorkspaceRequest): MigrateWorkspaceResponse

    /**
     * Modifies the configuration of Bring Your Own License (BYOL) for the specified account.
     */
    public suspend fun modifyAccount(input: ModifyAccountRequest = ModifyAccountRequest { }): ModifyAccountResponse

    /**
     * Modifies the properties of the certificate-based authentication you want to use with your WorkSpaces.
     */
    public suspend fun modifyCertificateBasedAuthProperties(input: ModifyCertificateBasedAuthPropertiesRequest): ModifyCertificateBasedAuthPropertiesResponse

    /**
     * Modifies the properties of the specified Amazon WorkSpaces clients.
     */
    public suspend fun modifyClientProperties(input: ModifyClientPropertiesRequest): ModifyClientPropertiesResponse

    /**
     * Modifies multiple properties related to SAML 2.0 authentication, including the enablement status, user access URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.
     */
    public suspend fun modifySamlProperties(input: ModifySamlPropertiesRequest): ModifySamlPropertiesResponse

    /**
     * Modifies the self-service WorkSpace management capabilities for your users. For more information, see [Enable Self-Service WorkSpace Management Capabilities for Your Users](https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html).
     */
    public suspend fun modifySelfservicePermissions(input: ModifySelfservicePermissionsRequest): ModifySelfservicePermissionsResponse

    /**
     * Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see [ Control Device Access](https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access).
     */
    public suspend fun modifyWorkspaceAccessProperties(input: ModifyWorkspaceAccessPropertiesRequest): ModifyWorkspaceAccessPropertiesResponse

    /**
     * Modify the default properties used to create WorkSpaces.
     */
    public suspend fun modifyWorkspaceCreationProperties(input: ModifyWorkspaceCreationPropertiesRequest): ModifyWorkspaceCreationPropertiesResponse

    /**
     * Modifies the specified WorkSpace properties. For important information about how to modify the size of the root and user volumes, see [ Modify a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
     *
     * The `MANUAL` running mode value is only supported by Amazon WorkSpaces Core. Contact your account team to be allow-listed to use this value. For more information, see [Amazon WorkSpaces Core](http://aws.amazon.com/workspaces/core/).
     */
    public suspend fun modifyWorkspaceProperties(input: ModifyWorkspacePropertiesRequest): ModifyWorkspacePropertiesResponse

    /**
     * Sets the state of the specified WorkSpace.
     *
     * To maintain a WorkSpace without being interrupted, set the WorkSpace state to `ADMIN_MAINTENANCE`. WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the `ADMIN_MAINTENANCE` state.
     */
    public suspend fun modifyWorkspaceState(input: ModifyWorkspaceStateRequest): ModifyWorkspaceStateResponse

    /**
     * Reboots the specified WorkSpaces.
     *
     * You cannot reboot a WorkSpace unless its state is `AVAILABLE` or `UNHEALTHY`.
     *
     * This operation is asynchronous and returns before the WorkSpaces have rebooted.
     */
    public suspend fun rebootWorkspaces(input: RebootWorkspacesRequest): RebootWorkspacesResponse

    /**
     * Rebuilds the specified WorkSpace.
     *
     * You cannot rebuild a WorkSpace unless its state is `AVAILABLE`, `ERROR`, `UNHEALTHY`, `STOPPED`, or `REBOOTING`.
     *
     * Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see [Rebuild a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html).
     *
     * This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.
     */
    public suspend fun rebuildWorkspaces(input: RebuildWorkspacesRequest): RebuildWorkspacesResponse

    /**
     * Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is registered. If this is the first time you are registering a directory, you will need to create the workspaces_DefaultRole role before you can register a directory. For more information, see [ Creating the workspaces_DefaultRole Role](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role).
     */
    public suspend fun registerWorkspaceDirectory(input: RegisterWorkspaceDirectoryRequest): RegisterWorkspaceDirectoryResponse

    /**
     * Restores the specified WorkSpace to its last known healthy state.
     *
     * You cannot restore a WorkSpace unless its state is ` AVAILABLE`, `ERROR`, `UNHEALTHY`, or `STOPPED`.
     *
     * Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see [Restore a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html).
     *
     * This operation is asynchronous and returns before the WorkSpace is completely restored.
     */
    public suspend fun restoreWorkspace(input: RestoreWorkspaceRequest): RestoreWorkspaceResponse

    /**
     * Removes one or more rules from the specified IP access control group.
     */
    public suspend fun revokeIpRules(input: RevokeIpRulesRequest): RevokeIpRulesResponse

    /**
     * Starts the specified WorkSpaces.
     *
     * You cannot start a WorkSpace unless it has a running mode of `AutoStop` and a state of `STOPPED`.
     */
    public suspend fun startWorkspaces(input: StartWorkspacesRequest): StartWorkspacesResponse

    /**
     * Stops the specified WorkSpaces.
     *
     * You cannot stop a WorkSpace unless it has a running mode of `AutoStop` and a state of `AVAILABLE`, `IMPAIRED`, `UNHEALTHY`, or `ERROR`.
     */
    public suspend fun stopWorkspaces(input: StopWorkspacesRequest): StopWorkspacesResponse

    /**
     * Terminates the specified WorkSpaces.
     *
     * Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to archive any user data, contact Amazon Web Services Support before terminating the WorkSpace.
     *
     * You can terminate a WorkSpace that is in any state except `SUSPENDED`.
     *
     * This operation is asynchronous and returns before the WorkSpaces have been completely terminated. After a WorkSpace is terminated, the `TERMINATED` state is returned only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using [ DescribeWorkSpaces](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html). If the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.
     *
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the [Directory Service pricing terms](http://aws.amazon.com/directoryservice/pricing/).
     *
     * To delete empty directories, see [ Delete the Directory for Your WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html). If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.
     */
    public suspend fun terminateWorkspaces(input: TerminateWorkspacesRequest): TerminateWorkspacesResponse

    /**
     * Updates a Amazon Connect client add-in. Use this action to update the name and endpoint URL of a Amazon Connect client add-in.
     */
    public suspend fun updateConnectClientAddIn(input: UpdateConnectClientAddInRequest): UpdateConnectClientAddInResponse

    /**
     * Shares or unshares a connection alias with one account by specifying whether that account has permission to associate the connection alias with a directory. If the association permission is granted, the connection alias is shared with that account. If the association permission is revoked, the connection alias is unshared with the account. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     *
     * + Before performing this operation, call [ DescribeConnectionAliases](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html) to make sure that the current state of the connection alias is `CREATED`.
     * + To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.
     */
    public suspend fun updateConnectionAliasPermission(input: UpdateConnectionAliasPermissionRequest): UpdateConnectionAliasPermissionResponse

    /**
     * Replaces the current rules of the specified IP access control group with the specified rules.
     */
    public suspend fun updateRulesOfIpGroup(input: UpdateRulesOfIpGroupRequest): UpdateRulesOfIpGroupResponse

    /**
     * Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see [ Update a Custom WorkSpaces Bundle](https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html).
     *
     * Existing WorkSpaces aren't automatically updated when you update the bundle that they're based on. To update existing WorkSpaces that are based on a bundle that you've updated, you must either rebuild the WorkSpaces or delete and recreate them.
     */
    public suspend fun updateWorkspaceBundle(input: UpdateWorkspaceBundleRequest = UpdateWorkspaceBundleRequest { }): UpdateWorkspaceBundleResponse

    /**
     * Shares or unshares an image with one account in the same Amazon Web Services Region by specifying whether that account has permission to copy the image. If the copy image permission is granted, the image is shared with that account. If the copy image permission is revoked, the image is unshared with the account.
     *
     * After an image has been shared, the recipient account can copy the image to other Regions as needed.
     *
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     *
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services Support.
     *
     * For more information about sharing images, see [ Share or Unshare a Custom WorkSpaces Image](https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html).
     *
     * + To delete an image that has been shared, you must unshare the image before you delete it.
     * + Sharing Bring Your Own License (BYOL) images across Amazon Web Services accounts isn't supported at this time in Amazon Web Services GovCloud (US). To share BYOL images across accounts in Amazon Web Services GovCloud (US), contact Amazon Web Services Support.
     */
    public suspend fun updateWorkspaceImagePermission(input: UpdateWorkspaceImagePermissionRequest): UpdateWorkspaceImagePermissionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun WorkSpacesClient.withConfig(block: WorkSpacesClient.Config.Builder.() -> Unit): WorkSpacesClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultWorkSpacesClient(newConfig)
}

/**
 * Associates the specified connection alias with the specified directory to enable cross-Region redirection. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
 *
 * Before performing this operation, call [ DescribeConnectionAliases](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html) to make sure that the current state of the connection alias is `CREATED`.
 */
public suspend inline fun WorkSpacesClient.associateConnectionAlias(crossinline block: AssociateConnectionAliasRequest.Builder.() -> Unit): AssociateConnectionAliasResponse = associateConnectionAlias(AssociateConnectionAliasRequest.Builder().apply(block).build())

/**
 * Associates the specified IP access control group with the specified directory.
 */
public suspend inline fun WorkSpacesClient.associateIpGroups(crossinline block: AssociateIpGroupsRequest.Builder.() -> Unit): AssociateIpGroupsResponse = associateIpGroups(AssociateIpGroupsRequest.Builder().apply(block).build())

/**
 * Associates the specified application to the specified WorkSpace.
 */
public suspend inline fun WorkSpacesClient.associateWorkspaceApplication(crossinline block: AssociateWorkspaceApplicationRequest.Builder.() -> Unit): AssociateWorkspaceApplicationResponse = associateWorkspaceApplication(AssociateWorkspaceApplicationRequest.Builder().apply(block).build())

/**
 * Adds one or more rules to the specified IP access control group.
 *
 * This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the rules.
 */
public suspend inline fun WorkSpacesClient.authorizeIpRules(crossinline block: AuthorizeIpRulesRequest.Builder.() -> Unit): AuthorizeIpRulesResponse = authorizeIpRules(AuthorizeIpRulesRequest.Builder().apply(block).build())

/**
 * Copies the specified image from the specified Region to the current Region. For more information about copying images, see [ Copy a Custom WorkSpaces Image](https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html).
 *
 * In the China (Ningxia) Region, you can copy images only within the same Region.
 *
 * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services Support.
 *
 * Before copying a shared image, be sure to verify that it has been shared from the correct Amazon Web Services account. To determine if an image has been shared and to see the ID of the Amazon Web Services account that owns an image, use the [DescribeWorkSpaceImages](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html) and [DescribeWorkspaceImagePermissions](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html) API operations.
 */
public suspend inline fun WorkSpacesClient.copyWorkspaceImage(crossinline block: CopyWorkspaceImageRequest.Builder.() -> Unit): CopyWorkspaceImageResponse = copyWorkspaceImage(CopyWorkspaceImageRequest.Builder().apply(block).build())

/**
 * Creates a client-add-in for Amazon Connect within a directory. You can create only one Amazon Connect client add-in within a directory.
 *
 * This client add-in allows WorkSpaces users to seamlessly connect to Amazon Connect.
 */
public suspend inline fun WorkSpacesClient.createConnectClientAddIn(crossinline block: CreateConnectClientAddInRequest.Builder.() -> Unit): CreateConnectClientAddInResponse = createConnectClientAddIn(CreateConnectClientAddInRequest.Builder().apply(block).build())

/**
 * Creates the specified connection alias for use with cross-Region redirection. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
 */
public suspend inline fun WorkSpacesClient.createConnectionAlias(crossinline block: CreateConnectionAliasRequest.Builder.() -> Unit): CreateConnectionAliasResponse = createConnectionAlias(CreateConnectionAliasRequest.Builder().apply(block).build())

/**
 * Creates an IP access control group.
 *
 * An IP access control group provides you with the ability to control the IP addresses from which users are allowed to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and then associate the group with your directory. You can add rules when you create the group or at any time using AuthorizeIpRules.
 *
 * There is a default IP access control group associated with your directory. If you don't associate an IP access control group with your directory, the default group is used. The default group includes a default rule that allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for your directory.
 */
public suspend inline fun WorkSpacesClient.createIpGroup(crossinline block: CreateIpGroupRequest.Builder.() -> Unit): CreateIpGroupResponse = createIpGroup(CreateIpGroupRequest.Builder().apply(block).build())

/**
 * Creates a standby WorkSpace in a secondary Region.
 */
public suspend inline fun WorkSpacesClient.createStandbyWorkspaces(crossinline block: CreateStandbyWorkspacesRequest.Builder.() -> Unit): CreateStandbyWorkspacesResponse = createStandbyWorkspaces(CreateStandbyWorkspacesRequest.Builder().apply(block).build())

/**
 * Creates the specified tags for the specified WorkSpaces resource.
 */
public suspend inline fun WorkSpacesClient.createTags(crossinline block: CreateTagsRequest.Builder.() -> Unit): CreateTagsResponse = createTags(CreateTagsRequest.Builder().apply(block).build())

/**
 * Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has the latest drivers and other updates required by the Amazon WorkSpaces components.
 *
 * To determine which WorkSpace images need to be updated with the latest Amazon WorkSpaces requirements, use [ DescribeWorkspaceImages](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html).
 *
 * + Only Windows 10, Windows Server 2016, and Windows Server 2019 WorkSpace images can be programmatically updated at this time.
 * + Microsoft Windows updates and other application updates are not included in the update process.
 * + The source WorkSpace image is not deleted. You can delete the source image after you've verified your new updated image and created a new bundle.
 */
public suspend inline fun WorkSpacesClient.createUpdatedWorkspaceImage(crossinline block: CreateUpdatedWorkspaceImageRequest.Builder.() -> Unit): CreateUpdatedWorkspaceImageResponse = createUpdatedWorkspaceImage(CreateUpdatedWorkspaceImageRequest.Builder().apply(block).build())

/**
 * Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see [ Create a Custom WorkSpaces Image and Bundle](https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html).
 */
public suspend inline fun WorkSpacesClient.createWorkspaceBundle(crossinline block: CreateWorkspaceBundleRequest.Builder.() -> Unit): CreateWorkspaceBundleResponse = createWorkspaceBundle(CreateWorkspaceBundleRequest.Builder().apply(block).build())

/**
 * Creates a new WorkSpace image from an existing WorkSpace.
 */
public suspend inline fun WorkSpacesClient.createWorkspaceImage(crossinline block: CreateWorkspaceImageRequest.Builder.() -> Unit): CreateWorkspaceImageResponse = createWorkspaceImage(CreateWorkspaceImageRequest.Builder().apply(block).build())

/**
 * Creates one or more WorkSpaces.
 *
 * This operation is asynchronous and returns before the WorkSpaces are created.
 *
 * + The `MANUAL` running mode value is only supported by Amazon WorkSpaces Core. Contact your account team to be allow-listed to use this value. For more information, see [Amazon WorkSpaces Core](http://aws.amazon.com/workspaces/core/).
 * + You don't need to specify the `PCOIP` protocol for Linux bundles because `WSP` is the default protocol for those bundles.
 * + Ensure you review your running mode to ensure you are using a running mode that is optimal for your needs and budget. For more information on switching running modes, see [ Can I switch between hourly and monthly billing?](https://aws.amazon.com/workspaces/faqs/#:~:text=Q%3A%20Can%20I%20switch%20between%20hourly%20and%20monthly%20billing%3F)
 */
public suspend inline fun WorkSpacesClient.createWorkspaces(crossinline block: CreateWorkspacesRequest.Builder.() -> Unit): CreateWorkspacesResponse = createWorkspaces(CreateWorkspacesRequest.Builder().apply(block).build())

/**
 * Deletes customized client branding. Client branding allows you to customize your WorkSpace's client login portal. You can tailor your login portal company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.
 *
 * After you delete your customized client branding, your login portal reverts to the default client branding.
 */
public suspend inline fun WorkSpacesClient.deleteClientBranding(crossinline block: DeleteClientBrandingRequest.Builder.() -> Unit): DeleteClientBrandingResponse = deleteClientBranding(DeleteClientBrandingRequest.Builder().apply(block).build())

/**
 * Deletes a client-add-in for Amazon Connect that is configured within a directory.
 */
public suspend inline fun WorkSpacesClient.deleteConnectClientAddIn(crossinline block: DeleteConnectClientAddInRequest.Builder.() -> Unit): DeleteConnectClientAddInResponse = deleteConnectClientAddIn(DeleteConnectClientAddInRequest.Builder().apply(block).build())

/**
 * Deletes the specified connection alias. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
 *
 * **If you will no longer be using a fully qualified domain name (FQDN) as the registration code for your WorkSpaces users, you must take certain precautions to prevent potential security issues.** For more information, see [ Security Considerations if You Stop Using Cross-Region Redirection](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations).
 *
 * To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.
 */
public suspend inline fun WorkSpacesClient.deleteConnectionAlias(crossinline block: DeleteConnectionAliasRequest.Builder.() -> Unit): DeleteConnectionAliasResponse = deleteConnectionAlias(DeleteConnectionAliasRequest.Builder().apply(block).build())

/**
 * Deletes the specified IP access control group.
 *
 * You cannot delete an IP access control group that is associated with a directory.
 */
public suspend inline fun WorkSpacesClient.deleteIpGroup(crossinline block: DeleteIpGroupRequest.Builder.() -> Unit): DeleteIpGroupResponse = deleteIpGroup(DeleteIpGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified tags from the specified WorkSpaces resource.
 */
public suspend inline fun WorkSpacesClient.deleteTags(crossinline block: DeleteTagsRequest.Builder.() -> Unit): DeleteTagsResponse = deleteTags(DeleteTagsRequest.Builder().apply(block).build())

/**
 * Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see [ Delete a Custom WorkSpaces Bundle or Image](https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html).
 */
public suspend inline fun WorkSpacesClient.deleteWorkspaceBundle(crossinline block: DeleteWorkspaceBundleRequest.Builder.() -> Unit): DeleteWorkspaceBundleResponse = deleteWorkspaceBundle(DeleteWorkspaceBundleRequest.Builder().apply(block).build())

/**
 * Deletes the specified image from your account. To delete an image, you must first delete any bundles that are associated with the image and unshare the image if it is shared with other accounts.
 */
public suspend inline fun WorkSpacesClient.deleteWorkspaceImage(crossinline block: DeleteWorkspaceImageRequest.Builder.() -> Unit): DeleteWorkspaceImageResponse = deleteWorkspaceImage(DeleteWorkspaceImageRequest.Builder().apply(block).build())

/**
 * Deploys associated applications to the specified WorkSpace
 */
public suspend inline fun WorkSpacesClient.deployWorkspaceApplications(crossinline block: DeployWorkspaceApplicationsRequest.Builder.() -> Unit): DeployWorkspaceApplicationsResponse = deployWorkspaceApplications(DeployWorkspaceApplicationsRequest.Builder().apply(block).build())

/**
 * Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister the directory.
 *
 * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the [Directory Service pricing terms](http://aws.amazon.com/directoryservice/pricing/).
 *
 * To delete empty directories, see [ Delete the Directory for Your WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html). If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.
 */
public suspend inline fun WorkSpacesClient.deregisterWorkspaceDirectory(crossinline block: DeregisterWorkspaceDirectoryRequest.Builder.() -> Unit): DeregisterWorkspaceDirectoryResponse = deregisterWorkspaceDirectory(DeregisterWorkspaceDirectoryRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.
 */
public suspend inline fun WorkSpacesClient.describeAccount(crossinline block: DescribeAccountRequest.Builder.() -> Unit): DescribeAccountResponse = describeAccount(DescribeAccountRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the specified account.
 */
public suspend inline fun WorkSpacesClient.describeAccountModifications(crossinline block: DescribeAccountModificationsRequest.Builder.() -> Unit): DescribeAccountModificationsResponse = describeAccountModifications(DescribeAccountModificationsRequest.Builder().apply(block).build())

/**
 * Describes the associations between the application and the specified associated resources.
 */
public suspend inline fun WorkSpacesClient.describeApplicationAssociations(crossinline block: DescribeApplicationAssociationsRequest.Builder.() -> Unit): DescribeApplicationAssociationsResponse = describeApplicationAssociations(DescribeApplicationAssociationsRequest.Builder().apply(block).build())

/**
 * Describes the specified applications by filtering based on their compute types, license availability, operating systems, and owners.
 */
public suspend inline fun WorkSpacesClient.describeApplications(crossinline block: DescribeApplicationsRequest.Builder.() -> Unit): DescribeApplicationsResponse = describeApplications(DescribeApplicationsRequest.Builder().apply(block).build())

/**
 * Describes the associations between the applications and the specified bundle.
 */
public suspend inline fun WorkSpacesClient.describeBundleAssociations(crossinline block: DescribeBundleAssociationsRequest.Builder.() -> Unit): DescribeBundleAssociationsResponse = describeBundleAssociations(DescribeBundleAssociationsRequest.Builder().apply(block).build())

/**
 * Describes the specified client branding. Client branding allows you to customize the log in page of various device types for your users. You can add your company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.
 *
 * Only device types that have branding information configured will be shown in the response.
 */
public suspend inline fun WorkSpacesClient.describeClientBranding(crossinline block: DescribeClientBrandingRequest.Builder.() -> Unit): DescribeClientBrandingResponse = describeClientBranding(DescribeClientBrandingRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
 */
public suspend inline fun WorkSpacesClient.describeClientProperties(crossinline block: DescribeClientPropertiesRequest.Builder.() -> Unit): DescribeClientPropertiesResponse = describeClientProperties(DescribeClientPropertiesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of Amazon Connect client add-ins that have been created.
 */
public suspend inline fun WorkSpacesClient.describeConnectClientAddIns(crossinline block: DescribeConnectClientAddInsRequest.Builder.() -> Unit): DescribeConnectClientAddInsResponse = describeConnectClientAddIns(DescribeConnectClientAddInsRequest.Builder().apply(block).build())

/**
 * Describes the permissions that the owner of a connection alias has granted to another Amazon Web Services account for the specified connection alias. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
 */
public suspend inline fun WorkSpacesClient.describeConnectionAliasPermissions(crossinline block: DescribeConnectionAliasPermissionsRequest.Builder.() -> Unit): DescribeConnectionAliasPermissionsResponse = describeConnectionAliasPermissions(DescribeConnectionAliasPermissionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
 */
public suspend inline fun WorkSpacesClient.describeConnectionAliases(crossinline block: DescribeConnectionAliasesRequest.Builder.() -> Unit): DescribeConnectionAliasesResponse = describeConnectionAliases(DescribeConnectionAliasesRequest.Builder().apply(block).build())

/**
 * Describes the associations between the applications and the specified image.
 */
public suspend inline fun WorkSpacesClient.describeImageAssociations(crossinline block: DescribeImageAssociationsRequest.Builder.() -> Unit): DescribeImageAssociationsResponse = describeImageAssociations(DescribeImageAssociationsRequest.Builder().apply(block).build())

/**
 * Describes one or more of your IP access control groups.
 */
public suspend inline fun WorkSpacesClient.describeIpGroups(crossinline block: DescribeIpGroupsRequest.Builder.() -> Unit): DescribeIpGroupsResponse = describeIpGroups(DescribeIpGroupsRequest.Builder().apply(block).build())

/**
 * Describes the specified tags for the specified WorkSpaces resource.
 */
public suspend inline fun WorkSpacesClient.describeTags(crossinline block: DescribeTagsRequest.Builder.() -> Unit): DescribeTagsResponse = describeTags(DescribeTagsRequest.Builder().apply(block).build())

/**
 * Describes the associations betweens applications and the specified WorkSpace.
 */
public suspend inline fun WorkSpacesClient.describeWorkspaceAssociations(crossinline block: DescribeWorkspaceAssociationsRequest.Builder.() -> Unit): DescribeWorkspaceAssociationsResponse = describeWorkspaceAssociations(DescribeWorkspaceAssociationsRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes the available WorkSpace bundles.
 *
 * You can filter the results using either bundle ID or owner, but not both.
 */
public suspend inline fun WorkSpacesClient.describeWorkspaceBundles(crossinline block: DescribeWorkspaceBundlesRequest.Builder.() -> Unit): DescribeWorkspaceBundlesResponse = describeWorkspaceBundles(DescribeWorkspaceBundlesRequest.Builder().apply(block).build())

/**
 * Describes the available directories that are registered with Amazon WorkSpaces.
 */
public suspend inline fun WorkSpacesClient.describeWorkspaceDirectories(crossinline block: DescribeWorkspaceDirectoriesRequest.Builder.() -> Unit): DescribeWorkspaceDirectoriesResponse = describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest.Builder().apply(block).build())

/**
 * Describes the permissions that the owner of an image has granted to other Amazon Web Services accounts for an image.
 */
public suspend inline fun WorkSpacesClient.describeWorkspaceImagePermissions(crossinline block: DescribeWorkspaceImagePermissionsRequest.Builder.() -> Unit): DescribeWorkspaceImagePermissionsResponse = describeWorkspaceImagePermissions(DescribeWorkspaceImagePermissionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise, all images in the account are described.
 */
public suspend inline fun WorkSpacesClient.describeWorkspaceImages(crossinline block: DescribeWorkspaceImagesRequest.Builder.() -> Unit): DescribeWorkspaceImagesResponse = describeWorkspaceImages(DescribeWorkspaceImagesRequest.Builder().apply(block).build())

/**
 * Describes the snapshots for the specified WorkSpace.
 */
public suspend inline fun WorkSpacesClient.describeWorkspaceSnapshots(crossinline block: DescribeWorkspaceSnapshotsRequest.Builder.() -> Unit): DescribeWorkspaceSnapshotsResponse = describeWorkspaceSnapshots(DescribeWorkspaceSnapshotsRequest.Builder().apply(block).build())

/**
 * Describes the specified WorkSpaces.
 *
 * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify only one filter at a time.
 */
public suspend inline fun WorkSpacesClient.describeWorkspaces(crossinline block: DescribeWorkspacesRequest.Builder.() -> Unit): DescribeWorkspacesResponse = describeWorkspaces(DescribeWorkspacesRequest.Builder().apply(block).build())

/**
 * Describes the connection status of the specified WorkSpaces.
 */
public suspend inline fun WorkSpacesClient.describeWorkspacesConnectionStatus(crossinline block: DescribeWorkspacesConnectionStatusRequest.Builder.() -> Unit): DescribeWorkspacesConnectionStatusResponse = describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest.Builder().apply(block).build())

/**
 * Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region redirection between two directories in different Regions. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
 *
 * Before performing this operation, call [ DescribeConnectionAliases](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html) to make sure that the current state of the connection alias is `CREATED`.
 */
public suspend inline fun WorkSpacesClient.disassociateConnectionAlias(crossinline block: DisassociateConnectionAliasRequest.Builder.() -> Unit): DisassociateConnectionAliasResponse = disassociateConnectionAlias(DisassociateConnectionAliasRequest.Builder().apply(block).build())

/**
 * Disassociates the specified IP access control group from the specified directory.
 */
public suspend inline fun WorkSpacesClient.disassociateIpGroups(crossinline block: DisassociateIpGroupsRequest.Builder.() -> Unit): DisassociateIpGroupsResponse = disassociateIpGroups(DisassociateIpGroupsRequest.Builder().apply(block).build())

/**
 * Disassociates the specified application from a WorkSpace.
 */
public suspend inline fun WorkSpacesClient.disassociateWorkspaceApplication(crossinline block: DisassociateWorkspaceApplicationRequest.Builder.() -> Unit): DisassociateWorkspaceApplicationResponse = disassociateWorkspaceApplication(DisassociateWorkspaceApplicationRequest.Builder().apply(block).build())

/**
 * Imports client branding. Client branding allows you to customize your WorkSpace's client login portal. You can tailor your login portal company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.
 *
 * After you import client branding, the default branding experience for the specified platform type is replaced with the imported experience
 *
 * + You must specify at least one platform type when importing client branding.
 * + You can import up to 6 MB of data with each request. If your request exceeds this limit, you can import client branding for different platform types using separate requests.
 * + In each platform type, the `SupportEmail` and `SupportLink` parameters are mutually exclusive. You can specify only one parameter for each platform type, but not both.
 * + Imported data can take up to a minute to appear in the WorkSpaces client.
 */
public suspend inline fun WorkSpacesClient.importClientBranding(crossinline block: ImportClientBrandingRequest.Builder.() -> Unit): ImportClientBrandingResponse = importClientBranding(ImportClientBrandingRequest.Builder().apply(block).build())

/**
 * Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image. For more information about creating BYOL images, see [ Bring Your Own Windows Desktop Licenses](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
 */
public suspend inline fun WorkSpacesClient.importWorkspaceImage(crossinline block: ImportWorkspaceImageRequest.Builder.() -> Unit): ImportWorkspaceImageResponse = importWorkspaceImage(ImportWorkspaceImageRequest.Builder().apply(block).build())

/**
 * Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management interface when you enable Bring Your Own License (BYOL).
 *
 * This operation can be run only by Amazon Web Services accounts that are enabled for BYOL. If your account isn't enabled for BYOL, you'll receive an `AccessDeniedException` error.
 *
 * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage the WorkSpace.
 */
public suspend inline fun WorkSpacesClient.listAvailableManagementCidrRanges(crossinline block: ListAvailableManagementCidrRangesRequest.Builder.() -> Unit): ListAvailableManagementCidrRangesResponse = listAvailableManagementCidrRanges(ListAvailableManagementCidrRangesRequest.Builder().apply(block).build())

/**
 * Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user volume.
 *
 * The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the user volume from the last available snapshot of the original WorkSpace. During migration, the original `D:\Users\%USERNAME%` user profile folder is renamed to `D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated`. A new `D:\Users\%USERNAME%\` folder is generated by the new OS. Certain files in the old user profile are moved to the new user profile.
 *
 * For available migration scenarios, details about what happens during migration, and best practices, see [Migrate a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html).
 */
public suspend inline fun WorkSpacesClient.migrateWorkspace(crossinline block: MigrateWorkspaceRequest.Builder.() -> Unit): MigrateWorkspaceResponse = migrateWorkspace(MigrateWorkspaceRequest.Builder().apply(block).build())

/**
 * Modifies the configuration of Bring Your Own License (BYOL) for the specified account.
 */
public suspend inline fun WorkSpacesClient.modifyAccount(crossinline block: ModifyAccountRequest.Builder.() -> Unit): ModifyAccountResponse = modifyAccount(ModifyAccountRequest.Builder().apply(block).build())

/**
 * Modifies the properties of the certificate-based authentication you want to use with your WorkSpaces.
 */
public suspend inline fun WorkSpacesClient.modifyCertificateBasedAuthProperties(crossinline block: ModifyCertificateBasedAuthPropertiesRequest.Builder.() -> Unit): ModifyCertificateBasedAuthPropertiesResponse = modifyCertificateBasedAuthProperties(ModifyCertificateBasedAuthPropertiesRequest.Builder().apply(block).build())

/**
 * Modifies the properties of the specified Amazon WorkSpaces clients.
 */
public suspend inline fun WorkSpacesClient.modifyClientProperties(crossinline block: ModifyClientPropertiesRequest.Builder.() -> Unit): ModifyClientPropertiesResponse = modifyClientProperties(ModifyClientPropertiesRequest.Builder().apply(block).build())

/**
 * Modifies multiple properties related to SAML 2.0 authentication, including the enablement status, user access URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.
 */
public suspend inline fun WorkSpacesClient.modifySamlProperties(crossinline block: ModifySamlPropertiesRequest.Builder.() -> Unit): ModifySamlPropertiesResponse = modifySamlProperties(ModifySamlPropertiesRequest.Builder().apply(block).build())

/**
 * Modifies the self-service WorkSpace management capabilities for your users. For more information, see [Enable Self-Service WorkSpace Management Capabilities for Your Users](https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html).
 */
public suspend inline fun WorkSpacesClient.modifySelfservicePermissions(crossinline block: ModifySelfservicePermissionsRequest.Builder.() -> Unit): ModifySelfservicePermissionsResponse = modifySelfservicePermissions(ModifySelfservicePermissionsRequest.Builder().apply(block).build())

/**
 * Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see [ Control Device Access](https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access).
 */
public suspend inline fun WorkSpacesClient.modifyWorkspaceAccessProperties(crossinline block: ModifyWorkspaceAccessPropertiesRequest.Builder.() -> Unit): ModifyWorkspaceAccessPropertiesResponse = modifyWorkspaceAccessProperties(ModifyWorkspaceAccessPropertiesRequest.Builder().apply(block).build())

/**
 * Modify the default properties used to create WorkSpaces.
 */
public suspend inline fun WorkSpacesClient.modifyWorkspaceCreationProperties(crossinline block: ModifyWorkspaceCreationPropertiesRequest.Builder.() -> Unit): ModifyWorkspaceCreationPropertiesResponse = modifyWorkspaceCreationProperties(ModifyWorkspaceCreationPropertiesRequest.Builder().apply(block).build())

/**
 * Modifies the specified WorkSpace properties. For important information about how to modify the size of the root and user volumes, see [ Modify a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
 *
 * The `MANUAL` running mode value is only supported by Amazon WorkSpaces Core. Contact your account team to be allow-listed to use this value. For more information, see [Amazon WorkSpaces Core](http://aws.amazon.com/workspaces/core/).
 */
public suspend inline fun WorkSpacesClient.modifyWorkspaceProperties(crossinline block: ModifyWorkspacePropertiesRequest.Builder.() -> Unit): ModifyWorkspacePropertiesResponse = modifyWorkspaceProperties(ModifyWorkspacePropertiesRequest.Builder().apply(block).build())

/**
 * Sets the state of the specified WorkSpace.
 *
 * To maintain a WorkSpace without being interrupted, set the WorkSpace state to `ADMIN_MAINTENANCE`. WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the `ADMIN_MAINTENANCE` state.
 */
public suspend inline fun WorkSpacesClient.modifyWorkspaceState(crossinline block: ModifyWorkspaceStateRequest.Builder.() -> Unit): ModifyWorkspaceStateResponse = modifyWorkspaceState(ModifyWorkspaceStateRequest.Builder().apply(block).build())

/**
 * Reboots the specified WorkSpaces.
 *
 * You cannot reboot a WorkSpace unless its state is `AVAILABLE` or `UNHEALTHY`.
 *
 * This operation is asynchronous and returns before the WorkSpaces have rebooted.
 */
public suspend inline fun WorkSpacesClient.rebootWorkspaces(crossinline block: RebootWorkspacesRequest.Builder.() -> Unit): RebootWorkspacesResponse = rebootWorkspaces(RebootWorkspacesRequest.Builder().apply(block).build())

/**
 * Rebuilds the specified WorkSpace.
 *
 * You cannot rebuild a WorkSpace unless its state is `AVAILABLE`, `ERROR`, `UNHEALTHY`, `STOPPED`, or `REBOOTING`.
 *
 * Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see [Rebuild a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html).
 *
 * This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.
 */
public suspend inline fun WorkSpacesClient.rebuildWorkspaces(crossinline block: RebuildWorkspacesRequest.Builder.() -> Unit): RebuildWorkspacesResponse = rebuildWorkspaces(RebuildWorkspacesRequest.Builder().apply(block).build())

/**
 * Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is registered. If this is the first time you are registering a directory, you will need to create the workspaces_DefaultRole role before you can register a directory. For more information, see [ Creating the workspaces_DefaultRole Role](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role).
 */
public suspend inline fun WorkSpacesClient.registerWorkspaceDirectory(crossinline block: RegisterWorkspaceDirectoryRequest.Builder.() -> Unit): RegisterWorkspaceDirectoryResponse = registerWorkspaceDirectory(RegisterWorkspaceDirectoryRequest.Builder().apply(block).build())

/**
 * Restores the specified WorkSpace to its last known healthy state.
 *
 * You cannot restore a WorkSpace unless its state is ` AVAILABLE`, `ERROR`, `UNHEALTHY`, or `STOPPED`.
 *
 * Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see [Restore a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html).
 *
 * This operation is asynchronous and returns before the WorkSpace is completely restored.
 */
public suspend inline fun WorkSpacesClient.restoreWorkspace(crossinline block: RestoreWorkspaceRequest.Builder.() -> Unit): RestoreWorkspaceResponse = restoreWorkspace(RestoreWorkspaceRequest.Builder().apply(block).build())

/**
 * Removes one or more rules from the specified IP access control group.
 */
public suspend inline fun WorkSpacesClient.revokeIpRules(crossinline block: RevokeIpRulesRequest.Builder.() -> Unit): RevokeIpRulesResponse = revokeIpRules(RevokeIpRulesRequest.Builder().apply(block).build())

/**
 * Starts the specified WorkSpaces.
 *
 * You cannot start a WorkSpace unless it has a running mode of `AutoStop` and a state of `STOPPED`.
 */
public suspend inline fun WorkSpacesClient.startWorkspaces(crossinline block: StartWorkspacesRequest.Builder.() -> Unit): StartWorkspacesResponse = startWorkspaces(StartWorkspacesRequest.Builder().apply(block).build())

/**
 * Stops the specified WorkSpaces.
 *
 * You cannot stop a WorkSpace unless it has a running mode of `AutoStop` and a state of `AVAILABLE`, `IMPAIRED`, `UNHEALTHY`, or `ERROR`.
 */
public suspend inline fun WorkSpacesClient.stopWorkspaces(crossinline block: StopWorkspacesRequest.Builder.() -> Unit): StopWorkspacesResponse = stopWorkspaces(StopWorkspacesRequest.Builder().apply(block).build())

/**
 * Terminates the specified WorkSpaces.
 *
 * Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to archive any user data, contact Amazon Web Services Support before terminating the WorkSpace.
 *
 * You can terminate a WorkSpace that is in any state except `SUSPENDED`.
 *
 * This operation is asynchronous and returns before the WorkSpaces have been completely terminated. After a WorkSpace is terminated, the `TERMINATED` state is returned only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using [ DescribeWorkSpaces](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html). If the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.
 *
 * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the [Directory Service pricing terms](http://aws.amazon.com/directoryservice/pricing/).
 *
 * To delete empty directories, see [ Delete the Directory for Your WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html). If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.
 */
public suspend inline fun WorkSpacesClient.terminateWorkspaces(crossinline block: TerminateWorkspacesRequest.Builder.() -> Unit): TerminateWorkspacesResponse = terminateWorkspaces(TerminateWorkspacesRequest.Builder().apply(block).build())

/**
 * Updates a Amazon Connect client add-in. Use this action to update the name and endpoint URL of a Amazon Connect client add-in.
 */
public suspend inline fun WorkSpacesClient.updateConnectClientAddIn(crossinline block: UpdateConnectClientAddInRequest.Builder.() -> Unit): UpdateConnectClientAddInResponse = updateConnectClientAddIn(UpdateConnectClientAddInRequest.Builder().apply(block).build())

/**
 * Shares or unshares a connection alias with one account by specifying whether that account has permission to associate the connection alias with a directory. If the association permission is granted, the connection alias is shared with that account. If the association permission is revoked, the connection alias is unshared with the account. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
 *
 * + Before performing this operation, call [ DescribeConnectionAliases](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html) to make sure that the current state of the connection alias is `CREATED`.
 * + To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.
 */
public suspend inline fun WorkSpacesClient.updateConnectionAliasPermission(crossinline block: UpdateConnectionAliasPermissionRequest.Builder.() -> Unit): UpdateConnectionAliasPermissionResponse = updateConnectionAliasPermission(UpdateConnectionAliasPermissionRequest.Builder().apply(block).build())

/**
 * Replaces the current rules of the specified IP access control group with the specified rules.
 */
public suspend inline fun WorkSpacesClient.updateRulesOfIpGroup(crossinline block: UpdateRulesOfIpGroupRequest.Builder.() -> Unit): UpdateRulesOfIpGroupResponse = updateRulesOfIpGroup(UpdateRulesOfIpGroupRequest.Builder().apply(block).build())

/**
 * Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see [ Update a Custom WorkSpaces Bundle](https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html).
 *
 * Existing WorkSpaces aren't automatically updated when you update the bundle that they're based on. To update existing WorkSpaces that are based on a bundle that you've updated, you must either rebuild the WorkSpaces or delete and recreate them.
 */
public suspend inline fun WorkSpacesClient.updateWorkspaceBundle(crossinline block: UpdateWorkspaceBundleRequest.Builder.() -> Unit): UpdateWorkspaceBundleResponse = updateWorkspaceBundle(UpdateWorkspaceBundleRequest.Builder().apply(block).build())

/**
 * Shares or unshares an image with one account in the same Amazon Web Services Region by specifying whether that account has permission to copy the image. If the copy image permission is granted, the image is shared with that account. If the copy image permission is revoked, the image is unshared with the account.
 *
 * After an image has been shared, the recipient account can copy the image to other Regions as needed.
 *
 * In the China (Ningxia) Region, you can copy images only within the same Region.
 *
 * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services Support.
 *
 * For more information about sharing images, see [ Share or Unshare a Custom WorkSpaces Image](https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html).
 *
 * + To delete an image that has been shared, you must unshare the image before you delete it.
 * + Sharing Bring Your Own License (BYOL) images across Amazon Web Services accounts isn't supported at this time in Amazon Web Services GovCloud (US). To share BYOL images across accounts in Amazon Web Services GovCloud (US), contact Amazon Web Services Support.
 */
public suspend inline fun WorkSpacesClient.updateWorkspaceImagePermission(crossinline block: UpdateWorkspaceImagePermissionRequest.Builder.() -> Unit): UpdateWorkspaceImagePermissionResponse = updateWorkspaceImagePermission(UpdateWorkspaceImagePermissionRequest.Builder().apply(block).build())
