// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.workspaces.auth.WorkSpacesAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.workspaces.auth.WorkSpacesIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.workspaces.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.workspaces.model.*
import aws.sdk.kotlin.services.workspaces.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultWorkSpacesClient(override val config: WorkSpacesClient.Config) : WorkSpacesClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = WorkSpacesIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "workspaces")
        }
        toMap()
    }
    private val authSchemeAdapter = WorkSpacesAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.workspaces"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Associates the specified connection alias with the specified directory to enable cross-Region redirection. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     *
     * Before performing this operation, call [ DescribeConnectionAliases](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html) to make sure that the current state of the connection alias is `CREATED`.
     */
    override suspend fun associateConnectionAlias(input: AssociateConnectionAliasRequest): AssociateConnectionAliasResponse {
        val op = SdkHttpOperation.build<AssociateConnectionAliasRequest, AssociateConnectionAliasResponse> {
            serializer = AssociateConnectionAliasOperationSerializer()
            deserializer = AssociateConnectionAliasOperationDeserializer()
            operationName = "AssociateConnectionAlias"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified IP access control group with the specified directory.
     */
    override suspend fun associateIpGroups(input: AssociateIpGroupsRequest): AssociateIpGroupsResponse {
        val op = SdkHttpOperation.build<AssociateIpGroupsRequest, AssociateIpGroupsResponse> {
            serializer = AssociateIpGroupsOperationSerializer()
            deserializer = AssociateIpGroupsOperationDeserializer()
            operationName = "AssociateIpGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified application to the specified WorkSpace.
     */
    override suspend fun associateWorkspaceApplication(input: AssociateWorkspaceApplicationRequest): AssociateWorkspaceApplicationResponse {
        val op = SdkHttpOperation.build<AssociateWorkspaceApplicationRequest, AssociateWorkspaceApplicationResponse> {
            serializer = AssociateWorkspaceApplicationOperationSerializer()
            deserializer = AssociateWorkspaceApplicationOperationDeserializer()
            operationName = "AssociateWorkspaceApplication"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more rules to the specified IP access control group.
     *
     * This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the rules.
     */
    override suspend fun authorizeIpRules(input: AuthorizeIpRulesRequest): AuthorizeIpRulesResponse {
        val op = SdkHttpOperation.build<AuthorizeIpRulesRequest, AuthorizeIpRulesResponse> {
            serializer = AuthorizeIpRulesOperationSerializer()
            deserializer = AuthorizeIpRulesOperationDeserializer()
            operationName = "AuthorizeIpRules"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Copies the specified image from the specified Region to the current Region. For more information about copying images, see [ Copy a Custom WorkSpaces Image](https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html).
     *
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     *
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services Support.
     *
     * Before copying a shared image, be sure to verify that it has been shared from the correct Amazon Web Services account. To determine if an image has been shared and to see the ID of the Amazon Web Services account that owns an image, use the [DescribeWorkSpaceImages](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html) and [DescribeWorkspaceImagePermissions](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html) API operations.
     */
    override suspend fun copyWorkspaceImage(input: CopyWorkspaceImageRequest): CopyWorkspaceImageResponse {
        val op = SdkHttpOperation.build<CopyWorkspaceImageRequest, CopyWorkspaceImageResponse> {
            serializer = CopyWorkspaceImageOperationSerializer()
            deserializer = CopyWorkspaceImageOperationDeserializer()
            operationName = "CopyWorkspaceImage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a client-add-in for Amazon Connect within a directory. You can create only one Amazon Connect client add-in within a directory.
     *
     * This client add-in allows WorkSpaces users to seamlessly connect to Amazon Connect.
     */
    override suspend fun createConnectClientAddIn(input: CreateConnectClientAddInRequest): CreateConnectClientAddInResponse {
        val op = SdkHttpOperation.build<CreateConnectClientAddInRequest, CreateConnectClientAddInResponse> {
            serializer = CreateConnectClientAddInOperationSerializer()
            deserializer = CreateConnectClientAddInOperationDeserializer()
            operationName = "CreateConnectClientAddIn"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates the specified connection alias for use with cross-Region redirection. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     */
    override suspend fun createConnectionAlias(input: CreateConnectionAliasRequest): CreateConnectionAliasResponse {
        val op = SdkHttpOperation.build<CreateConnectionAliasRequest, CreateConnectionAliasResponse> {
            serializer = CreateConnectionAliasOperationSerializer()
            deserializer = CreateConnectionAliasOperationDeserializer()
            operationName = "CreateConnectionAlias"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an IP access control group.
     *
     * An IP access control group provides you with the ability to control the IP addresses from which users are allowed to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and then associate the group with your directory. You can add rules when you create the group or at any time using AuthorizeIpRules.
     *
     * There is a default IP access control group associated with your directory. If you don't associate an IP access control group with your directory, the default group is used. The default group includes a default rule that allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for your directory.
     */
    override suspend fun createIpGroup(input: CreateIpGroupRequest): CreateIpGroupResponse {
        val op = SdkHttpOperation.build<CreateIpGroupRequest, CreateIpGroupResponse> {
            serializer = CreateIpGroupOperationSerializer()
            deserializer = CreateIpGroupOperationDeserializer()
            operationName = "CreateIpGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a standby WorkSpace in a secondary Region.
     */
    override suspend fun createStandbyWorkspaces(input: CreateStandbyWorkspacesRequest): CreateStandbyWorkspacesResponse {
        val op = SdkHttpOperation.build<CreateStandbyWorkspacesRequest, CreateStandbyWorkspacesResponse> {
            serializer = CreateStandbyWorkspacesOperationSerializer()
            deserializer = CreateStandbyWorkspacesOperationDeserializer()
            operationName = "CreateStandbyWorkspaces"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates the specified tags for the specified WorkSpaces resource.
     */
    override suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse {
        val op = SdkHttpOperation.build<CreateTagsRequest, CreateTagsResponse> {
            serializer = CreateTagsOperationSerializer()
            deserializer = CreateTagsOperationDeserializer()
            operationName = "CreateTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has the latest drivers and other updates required by the Amazon WorkSpaces components.
     *
     * To determine which WorkSpace images need to be updated with the latest Amazon WorkSpaces requirements, use [ DescribeWorkspaceImages](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html).
     *
     * + Only Windows 10, Windows Server 2016, and Windows Server 2019 WorkSpace images can be programmatically updated at this time.
     * + Microsoft Windows updates and other application updates are not included in the update process.
     * + The source WorkSpace image is not deleted. You can delete the source image after you've verified your new updated image and created a new bundle.
     */
    override suspend fun createUpdatedWorkspaceImage(input: CreateUpdatedWorkspaceImageRequest): CreateUpdatedWorkspaceImageResponse {
        val op = SdkHttpOperation.build<CreateUpdatedWorkspaceImageRequest, CreateUpdatedWorkspaceImageResponse> {
            serializer = CreateUpdatedWorkspaceImageOperationSerializer()
            deserializer = CreateUpdatedWorkspaceImageOperationDeserializer()
            operationName = "CreateUpdatedWorkspaceImage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see [ Create a Custom WorkSpaces Image and Bundle](https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html).
     */
    override suspend fun createWorkspaceBundle(input: CreateWorkspaceBundleRequest): CreateWorkspaceBundleResponse {
        val op = SdkHttpOperation.build<CreateWorkspaceBundleRequest, CreateWorkspaceBundleResponse> {
            serializer = CreateWorkspaceBundleOperationSerializer()
            deserializer = CreateWorkspaceBundleOperationDeserializer()
            operationName = "CreateWorkspaceBundle"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new WorkSpace image from an existing WorkSpace.
     */
    override suspend fun createWorkspaceImage(input: CreateWorkspaceImageRequest): CreateWorkspaceImageResponse {
        val op = SdkHttpOperation.build<CreateWorkspaceImageRequest, CreateWorkspaceImageResponse> {
            serializer = CreateWorkspaceImageOperationSerializer()
            deserializer = CreateWorkspaceImageOperationDeserializer()
            operationName = "CreateWorkspaceImage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates one or more WorkSpaces.
     *
     * This operation is asynchronous and returns before the WorkSpaces are created.
     *
     * + The `MANUAL` running mode value is only supported by Amazon WorkSpaces Core. Contact your account team to be allow-listed to use this value. For more information, see [Amazon WorkSpaces Core](http://aws.amazon.com/workspaces/core/).
     * + You don't need to specify the `PCOIP` protocol for Linux bundles because `WSP` is the default protocol for those bundles.
     * + Ensure you review your running mode to ensure you are using a running mode that is optimal for your needs and budget. For more information on switching running modes, see [ Can I switch between hourly and monthly billing?](https://aws.amazon.com/workspaces/faqs/#:~:text=Q%3A%20Can%20I%20switch%20between%20hourly%20and%20monthly%20billing%3F)
     */
    override suspend fun createWorkspaces(input: CreateWorkspacesRequest): CreateWorkspacesResponse {
        val op = SdkHttpOperation.build<CreateWorkspacesRequest, CreateWorkspacesResponse> {
            serializer = CreateWorkspacesOperationSerializer()
            deserializer = CreateWorkspacesOperationDeserializer()
            operationName = "CreateWorkspaces"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes customized client branding. Client branding allows you to customize your WorkSpace's client login portal. You can tailor your login portal company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.
     *
     * After you delete your customized client branding, your login portal reverts to the default client branding.
     */
    override suspend fun deleteClientBranding(input: DeleteClientBrandingRequest): DeleteClientBrandingResponse {
        val op = SdkHttpOperation.build<DeleteClientBrandingRequest, DeleteClientBrandingResponse> {
            serializer = DeleteClientBrandingOperationSerializer()
            deserializer = DeleteClientBrandingOperationDeserializer()
            operationName = "DeleteClientBranding"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a client-add-in for Amazon Connect that is configured within a directory.
     */
    override suspend fun deleteConnectClientAddIn(input: DeleteConnectClientAddInRequest): DeleteConnectClientAddInResponse {
        val op = SdkHttpOperation.build<DeleteConnectClientAddInRequest, DeleteConnectClientAddInResponse> {
            serializer = DeleteConnectClientAddInOperationSerializer()
            deserializer = DeleteConnectClientAddInOperationDeserializer()
            operationName = "DeleteConnectClientAddIn"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified connection alias. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     *
     * **If you will no longer be using a fully qualified domain name (FQDN) as the registration code for your WorkSpaces users, you must take certain precautions to prevent potential security issues.** For more information, see [ Security Considerations if You Stop Using Cross-Region Redirection](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations).
     *
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.
     */
    override suspend fun deleteConnectionAlias(input: DeleteConnectionAliasRequest): DeleteConnectionAliasResponse {
        val op = SdkHttpOperation.build<DeleteConnectionAliasRequest, DeleteConnectionAliasResponse> {
            serializer = DeleteConnectionAliasOperationSerializer()
            deserializer = DeleteConnectionAliasOperationDeserializer()
            operationName = "DeleteConnectionAlias"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified IP access control group.
     *
     * You cannot delete an IP access control group that is associated with a directory.
     */
    override suspend fun deleteIpGroup(input: DeleteIpGroupRequest): DeleteIpGroupResponse {
        val op = SdkHttpOperation.build<DeleteIpGroupRequest, DeleteIpGroupResponse> {
            serializer = DeleteIpGroupOperationSerializer()
            deserializer = DeleteIpGroupOperationDeserializer()
            operationName = "DeleteIpGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified tags from the specified WorkSpaces resource.
     */
    override suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse {
        val op = SdkHttpOperation.build<DeleteTagsRequest, DeleteTagsResponse> {
            serializer = DeleteTagsOperationSerializer()
            deserializer = DeleteTagsOperationDeserializer()
            operationName = "DeleteTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see [ Delete a Custom WorkSpaces Bundle or Image](https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html).
     */
    override suspend fun deleteWorkspaceBundle(input: DeleteWorkspaceBundleRequest): DeleteWorkspaceBundleResponse {
        val op = SdkHttpOperation.build<DeleteWorkspaceBundleRequest, DeleteWorkspaceBundleResponse> {
            serializer = DeleteWorkspaceBundleOperationSerializer()
            deserializer = DeleteWorkspaceBundleOperationDeserializer()
            operationName = "DeleteWorkspaceBundle"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified image from your account. To delete an image, you must first delete any bundles that are associated with the image and unshare the image if it is shared with other accounts.
     */
    override suspend fun deleteWorkspaceImage(input: DeleteWorkspaceImageRequest): DeleteWorkspaceImageResponse {
        val op = SdkHttpOperation.build<DeleteWorkspaceImageRequest, DeleteWorkspaceImageResponse> {
            serializer = DeleteWorkspaceImageOperationSerializer()
            deserializer = DeleteWorkspaceImageOperationDeserializer()
            operationName = "DeleteWorkspaceImage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deploys associated applications to the specified WorkSpace
     */
    override suspend fun deployWorkspaceApplications(input: DeployWorkspaceApplicationsRequest): DeployWorkspaceApplicationsResponse {
        val op = SdkHttpOperation.build<DeployWorkspaceApplicationsRequest, DeployWorkspaceApplicationsResponse> {
            serializer = DeployWorkspaceApplicationsOperationSerializer()
            deserializer = DeployWorkspaceApplicationsOperationDeserializer()
            operationName = "DeployWorkspaceApplications"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister the directory.
     *
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the [Directory Service pricing terms](http://aws.amazon.com/directoryservice/pricing/).
     *
     * To delete empty directories, see [ Delete the Directory for Your WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html). If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.
     */
    override suspend fun deregisterWorkspaceDirectory(input: DeregisterWorkspaceDirectoryRequest): DeregisterWorkspaceDirectoryResponse {
        val op = SdkHttpOperation.build<DeregisterWorkspaceDirectoryRequest, DeregisterWorkspaceDirectoryResponse> {
            serializer = DeregisterWorkspaceDirectoryOperationSerializer()
            deserializer = DeregisterWorkspaceDirectoryOperationDeserializer()
            operationName = "DeregisterWorkspaceDirectory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.
     */
    override suspend fun describeAccount(input: DescribeAccountRequest): DescribeAccountResponse {
        val op = SdkHttpOperation.build<DescribeAccountRequest, DescribeAccountResponse> {
            serializer = DescribeAccountOperationSerializer()
            deserializer = DescribeAccountOperationDeserializer()
            operationName = "DescribeAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the specified account.
     */
    override suspend fun describeAccountModifications(input: DescribeAccountModificationsRequest): DescribeAccountModificationsResponse {
        val op = SdkHttpOperation.build<DescribeAccountModificationsRequest, DescribeAccountModificationsResponse> {
            serializer = DescribeAccountModificationsOperationSerializer()
            deserializer = DescribeAccountModificationsOperationDeserializer()
            operationName = "DescribeAccountModifications"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the associations between the application and the specified associated resources.
     */
    override suspend fun describeApplicationAssociations(input: DescribeApplicationAssociationsRequest): DescribeApplicationAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeApplicationAssociationsRequest, DescribeApplicationAssociationsResponse> {
            serializer = DescribeApplicationAssociationsOperationSerializer()
            deserializer = DescribeApplicationAssociationsOperationDeserializer()
            operationName = "DescribeApplicationAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified applications by filtering based on their compute types, license availability, operating systems, and owners.
     */
    override suspend fun describeApplications(input: DescribeApplicationsRequest): DescribeApplicationsResponse {
        val op = SdkHttpOperation.build<DescribeApplicationsRequest, DescribeApplicationsResponse> {
            serializer = DescribeApplicationsOperationSerializer()
            deserializer = DescribeApplicationsOperationDeserializer()
            operationName = "DescribeApplications"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the associations between the applications and the specified bundle.
     */
    override suspend fun describeBundleAssociations(input: DescribeBundleAssociationsRequest): DescribeBundleAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeBundleAssociationsRequest, DescribeBundleAssociationsResponse> {
            serializer = DescribeBundleAssociationsOperationSerializer()
            deserializer = DescribeBundleAssociationsOperationDeserializer()
            operationName = "DescribeBundleAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified client branding. Client branding allows you to customize the log in page of various device types for your users. You can add your company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.
     *
     * Only device types that have branding information configured will be shown in the response.
     */
    override suspend fun describeClientBranding(input: DescribeClientBrandingRequest): DescribeClientBrandingResponse {
        val op = SdkHttpOperation.build<DescribeClientBrandingRequest, DescribeClientBrandingResponse> {
            serializer = DescribeClientBrandingOperationSerializer()
            deserializer = DescribeClientBrandingOperationDeserializer()
            operationName = "DescribeClientBranding"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
     */
    override suspend fun describeClientProperties(input: DescribeClientPropertiesRequest): DescribeClientPropertiesResponse {
        val op = SdkHttpOperation.build<DescribeClientPropertiesRequest, DescribeClientPropertiesResponse> {
            serializer = DescribeClientPropertiesOperationSerializer()
            deserializer = DescribeClientPropertiesOperationDeserializer()
            operationName = "DescribeClientProperties"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of Amazon Connect client add-ins that have been created.
     */
    override suspend fun describeConnectClientAddIns(input: DescribeConnectClientAddInsRequest): DescribeConnectClientAddInsResponse {
        val op = SdkHttpOperation.build<DescribeConnectClientAddInsRequest, DescribeConnectClientAddInsResponse> {
            serializer = DescribeConnectClientAddInsOperationSerializer()
            deserializer = DescribeConnectClientAddInsOperationDeserializer()
            operationName = "DescribeConnectClientAddIns"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the permissions that the owner of a connection alias has granted to another Amazon Web Services account for the specified connection alias. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     */
    override suspend fun describeConnectionAliasPermissions(input: DescribeConnectionAliasPermissionsRequest): DescribeConnectionAliasPermissionsResponse {
        val op = SdkHttpOperation.build<DescribeConnectionAliasPermissionsRequest, DescribeConnectionAliasPermissionsResponse> {
            serializer = DescribeConnectionAliasPermissionsOperationSerializer()
            deserializer = DescribeConnectionAliasPermissionsOperationDeserializer()
            operationName = "DescribeConnectionAliasPermissions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     */
    override suspend fun describeConnectionAliases(input: DescribeConnectionAliasesRequest): DescribeConnectionAliasesResponse {
        val op = SdkHttpOperation.build<DescribeConnectionAliasesRequest, DescribeConnectionAliasesResponse> {
            serializer = DescribeConnectionAliasesOperationSerializer()
            deserializer = DescribeConnectionAliasesOperationDeserializer()
            operationName = "DescribeConnectionAliases"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the associations between the applications and the specified image.
     */
    override suspend fun describeImageAssociations(input: DescribeImageAssociationsRequest): DescribeImageAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeImageAssociationsRequest, DescribeImageAssociationsResponse> {
            serializer = DescribeImageAssociationsOperationSerializer()
            deserializer = DescribeImageAssociationsOperationDeserializer()
            operationName = "DescribeImageAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your IP access control groups.
     */
    override suspend fun describeIpGroups(input: DescribeIpGroupsRequest): DescribeIpGroupsResponse {
        val op = SdkHttpOperation.build<DescribeIpGroupsRequest, DescribeIpGroupsResponse> {
            serializer = DescribeIpGroupsOperationSerializer()
            deserializer = DescribeIpGroupsOperationDeserializer()
            operationName = "DescribeIpGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified tags for the specified WorkSpaces resource.
     */
    override suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse {
        val op = SdkHttpOperation.build<DescribeTagsRequest, DescribeTagsResponse> {
            serializer = DescribeTagsOperationSerializer()
            deserializer = DescribeTagsOperationDeserializer()
            operationName = "DescribeTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the associations betweens applications and the specified WorkSpace.
     */
    override suspend fun describeWorkspaceAssociations(input: DescribeWorkspaceAssociationsRequest): DescribeWorkspaceAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeWorkspaceAssociationsRequest, DescribeWorkspaceAssociationsResponse> {
            serializer = DescribeWorkspaceAssociationsOperationSerializer()
            deserializer = DescribeWorkspaceAssociationsOperationDeserializer()
            operationName = "DescribeWorkspaceAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes the available WorkSpace bundles.
     *
     * You can filter the results using either bundle ID or owner, but not both.
     */
    override suspend fun describeWorkspaceBundles(input: DescribeWorkspaceBundlesRequest): DescribeWorkspaceBundlesResponse {
        val op = SdkHttpOperation.build<DescribeWorkspaceBundlesRequest, DescribeWorkspaceBundlesResponse> {
            serializer = DescribeWorkspaceBundlesOperationSerializer()
            deserializer = DescribeWorkspaceBundlesOperationDeserializer()
            operationName = "DescribeWorkspaceBundles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the available directories that are registered with Amazon WorkSpaces.
     */
    override suspend fun describeWorkspaceDirectories(input: DescribeWorkspaceDirectoriesRequest): DescribeWorkspaceDirectoriesResponse {
        val op = SdkHttpOperation.build<DescribeWorkspaceDirectoriesRequest, DescribeWorkspaceDirectoriesResponse> {
            serializer = DescribeWorkspaceDirectoriesOperationSerializer()
            deserializer = DescribeWorkspaceDirectoriesOperationDeserializer()
            operationName = "DescribeWorkspaceDirectories"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the permissions that the owner of an image has granted to other Amazon Web Services accounts for an image.
     */
    override suspend fun describeWorkspaceImagePermissions(input: DescribeWorkspaceImagePermissionsRequest): DescribeWorkspaceImagePermissionsResponse {
        val op = SdkHttpOperation.build<DescribeWorkspaceImagePermissionsRequest, DescribeWorkspaceImagePermissionsResponse> {
            serializer = DescribeWorkspaceImagePermissionsOperationSerializer()
            deserializer = DescribeWorkspaceImagePermissionsOperationDeserializer()
            operationName = "DescribeWorkspaceImagePermissions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise, all images in the account are described.
     */
    override suspend fun describeWorkspaceImages(input: DescribeWorkspaceImagesRequest): DescribeWorkspaceImagesResponse {
        val op = SdkHttpOperation.build<DescribeWorkspaceImagesRequest, DescribeWorkspaceImagesResponse> {
            serializer = DescribeWorkspaceImagesOperationSerializer()
            deserializer = DescribeWorkspaceImagesOperationDeserializer()
            operationName = "DescribeWorkspaceImages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the snapshots for the specified WorkSpace.
     */
    override suspend fun describeWorkspaceSnapshots(input: DescribeWorkspaceSnapshotsRequest): DescribeWorkspaceSnapshotsResponse {
        val op = SdkHttpOperation.build<DescribeWorkspaceSnapshotsRequest, DescribeWorkspaceSnapshotsResponse> {
            serializer = DescribeWorkspaceSnapshotsOperationSerializer()
            deserializer = DescribeWorkspaceSnapshotsOperationDeserializer()
            operationName = "DescribeWorkspaceSnapshots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified WorkSpaces.
     *
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify only one filter at a time.
     */
    override suspend fun describeWorkspaces(input: DescribeWorkspacesRequest): DescribeWorkspacesResponse {
        val op = SdkHttpOperation.build<DescribeWorkspacesRequest, DescribeWorkspacesResponse> {
            serializer = DescribeWorkspacesOperationSerializer()
            deserializer = DescribeWorkspacesOperationDeserializer()
            operationName = "DescribeWorkspaces"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the connection status of the specified WorkSpaces.
     */
    override suspend fun describeWorkspacesConnectionStatus(input: DescribeWorkspacesConnectionStatusRequest): DescribeWorkspacesConnectionStatusResponse {
        val op = SdkHttpOperation.build<DescribeWorkspacesConnectionStatusRequest, DescribeWorkspacesConnectionStatusResponse> {
            serializer = DescribeWorkspacesConnectionStatusOperationSerializer()
            deserializer = DescribeWorkspacesConnectionStatusOperationDeserializer()
            operationName = "DescribeWorkspacesConnectionStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region redirection between two directories in different Regions. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     *
     * Before performing this operation, call [ DescribeConnectionAliases](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html) to make sure that the current state of the connection alias is `CREATED`.
     */
    override suspend fun disassociateConnectionAlias(input: DisassociateConnectionAliasRequest): DisassociateConnectionAliasResponse {
        val op = SdkHttpOperation.build<DisassociateConnectionAliasRequest, DisassociateConnectionAliasResponse> {
            serializer = DisassociateConnectionAliasOperationSerializer()
            deserializer = DisassociateConnectionAliasOperationDeserializer()
            operationName = "DisassociateConnectionAlias"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified IP access control group from the specified directory.
     */
    override suspend fun disassociateIpGroups(input: DisassociateIpGroupsRequest): DisassociateIpGroupsResponse {
        val op = SdkHttpOperation.build<DisassociateIpGroupsRequest, DisassociateIpGroupsResponse> {
            serializer = DisassociateIpGroupsOperationSerializer()
            deserializer = DisassociateIpGroupsOperationDeserializer()
            operationName = "DisassociateIpGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified application from a WorkSpace.
     */
    override suspend fun disassociateWorkspaceApplication(input: DisassociateWorkspaceApplicationRequest): DisassociateWorkspaceApplicationResponse {
        val op = SdkHttpOperation.build<DisassociateWorkspaceApplicationRequest, DisassociateWorkspaceApplicationResponse> {
            serializer = DisassociateWorkspaceApplicationOperationSerializer()
            deserializer = DisassociateWorkspaceApplicationOperationDeserializer()
            operationName = "DisassociateWorkspaceApplication"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Imports client branding. Client branding allows you to customize your WorkSpace's client login portal. You can tailor your login portal company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.
     *
     * After you import client branding, the default branding experience for the specified platform type is replaced with the imported experience
     *
     * + You must specify at least one platform type when importing client branding.
     * + You can import up to 6 MB of data with each request. If your request exceeds this limit, you can import client branding for different platform types using separate requests.
     * + In each platform type, the `SupportEmail` and `SupportLink` parameters are mutually exclusive. You can specify only one parameter for each platform type, but not both.
     * + Imported data can take up to a minute to appear in the WorkSpaces client.
     */
    override suspend fun importClientBranding(input: ImportClientBrandingRequest): ImportClientBrandingResponse {
        val op = SdkHttpOperation.build<ImportClientBrandingRequest, ImportClientBrandingResponse> {
            serializer = ImportClientBrandingOperationSerializer()
            deserializer = ImportClientBrandingOperationDeserializer()
            operationName = "ImportClientBranding"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image. For more information about creating BYOL images, see [ Bring Your Own Windows Desktop Licenses](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
     */
    override suspend fun importWorkspaceImage(input: ImportWorkspaceImageRequest): ImportWorkspaceImageResponse {
        val op = SdkHttpOperation.build<ImportWorkspaceImageRequest, ImportWorkspaceImageResponse> {
            serializer = ImportWorkspaceImageOperationSerializer()
            deserializer = ImportWorkspaceImageOperationDeserializer()
            operationName = "ImportWorkspaceImage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management interface when you enable Bring Your Own License (BYOL).
     *
     * This operation can be run only by Amazon Web Services accounts that are enabled for BYOL. If your account isn't enabled for BYOL, you'll receive an `AccessDeniedException` error.
     *
     * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage the WorkSpace.
     */
    override suspend fun listAvailableManagementCidrRanges(input: ListAvailableManagementCidrRangesRequest): ListAvailableManagementCidrRangesResponse {
        val op = SdkHttpOperation.build<ListAvailableManagementCidrRangesRequest, ListAvailableManagementCidrRangesResponse> {
            serializer = ListAvailableManagementCidrRangesOperationSerializer()
            deserializer = ListAvailableManagementCidrRangesOperationDeserializer()
            operationName = "ListAvailableManagementCidrRanges"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user volume.
     *
     * The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the user volume from the last available snapshot of the original WorkSpace. During migration, the original `D:\Users\%USERNAME%` user profile folder is renamed to `D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated`. A new `D:\Users\%USERNAME%\` folder is generated by the new OS. Certain files in the old user profile are moved to the new user profile.
     *
     * For available migration scenarios, details about what happens during migration, and best practices, see [Migrate a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html).
     */
    override suspend fun migrateWorkspace(input: MigrateWorkspaceRequest): MigrateWorkspaceResponse {
        val op = SdkHttpOperation.build<MigrateWorkspaceRequest, MigrateWorkspaceResponse> {
            serializer = MigrateWorkspaceOperationSerializer()
            deserializer = MigrateWorkspaceOperationDeserializer()
            operationName = "MigrateWorkspace"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the configuration of Bring Your Own License (BYOL) for the specified account.
     */
    override suspend fun modifyAccount(input: ModifyAccountRequest): ModifyAccountResponse {
        val op = SdkHttpOperation.build<ModifyAccountRequest, ModifyAccountResponse> {
            serializer = ModifyAccountOperationSerializer()
            deserializer = ModifyAccountOperationDeserializer()
            operationName = "ModifyAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the properties of the certificate-based authentication you want to use with your WorkSpaces.
     */
    override suspend fun modifyCertificateBasedAuthProperties(input: ModifyCertificateBasedAuthPropertiesRequest): ModifyCertificateBasedAuthPropertiesResponse {
        val op = SdkHttpOperation.build<ModifyCertificateBasedAuthPropertiesRequest, ModifyCertificateBasedAuthPropertiesResponse> {
            serializer = ModifyCertificateBasedAuthPropertiesOperationSerializer()
            deserializer = ModifyCertificateBasedAuthPropertiesOperationDeserializer()
            operationName = "ModifyCertificateBasedAuthProperties"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the properties of the specified Amazon WorkSpaces clients.
     */
    override suspend fun modifyClientProperties(input: ModifyClientPropertiesRequest): ModifyClientPropertiesResponse {
        val op = SdkHttpOperation.build<ModifyClientPropertiesRequest, ModifyClientPropertiesResponse> {
            serializer = ModifyClientPropertiesOperationSerializer()
            deserializer = ModifyClientPropertiesOperationDeserializer()
            operationName = "ModifyClientProperties"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies multiple properties related to SAML 2.0 authentication, including the enablement status, user access URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.
     */
    override suspend fun modifySamlProperties(input: ModifySamlPropertiesRequest): ModifySamlPropertiesResponse {
        val op = SdkHttpOperation.build<ModifySamlPropertiesRequest, ModifySamlPropertiesResponse> {
            serializer = ModifySamlPropertiesOperationSerializer()
            deserializer = ModifySamlPropertiesOperationDeserializer()
            operationName = "ModifySamlProperties"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the self-service WorkSpace management capabilities for your users. For more information, see [Enable Self-Service WorkSpace Management Capabilities for Your Users](https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html).
     */
    override suspend fun modifySelfservicePermissions(input: ModifySelfservicePermissionsRequest): ModifySelfservicePermissionsResponse {
        val op = SdkHttpOperation.build<ModifySelfservicePermissionsRequest, ModifySelfservicePermissionsResponse> {
            serializer = ModifySelfservicePermissionsOperationSerializer()
            deserializer = ModifySelfservicePermissionsOperationDeserializer()
            operationName = "ModifySelfservicePermissions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see [ Control Device Access](https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access).
     */
    override suspend fun modifyWorkspaceAccessProperties(input: ModifyWorkspaceAccessPropertiesRequest): ModifyWorkspaceAccessPropertiesResponse {
        val op = SdkHttpOperation.build<ModifyWorkspaceAccessPropertiesRequest, ModifyWorkspaceAccessPropertiesResponse> {
            serializer = ModifyWorkspaceAccessPropertiesOperationSerializer()
            deserializer = ModifyWorkspaceAccessPropertiesOperationDeserializer()
            operationName = "ModifyWorkspaceAccessProperties"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modify the default properties used to create WorkSpaces.
     */
    override suspend fun modifyWorkspaceCreationProperties(input: ModifyWorkspaceCreationPropertiesRequest): ModifyWorkspaceCreationPropertiesResponse {
        val op = SdkHttpOperation.build<ModifyWorkspaceCreationPropertiesRequest, ModifyWorkspaceCreationPropertiesResponse> {
            serializer = ModifyWorkspaceCreationPropertiesOperationSerializer()
            deserializer = ModifyWorkspaceCreationPropertiesOperationDeserializer()
            operationName = "ModifyWorkspaceCreationProperties"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified WorkSpace properties. For important information about how to modify the size of the root and user volumes, see [ Modify a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
     *
     * The `MANUAL` running mode value is only supported by Amazon WorkSpaces Core. Contact your account team to be allow-listed to use this value. For more information, see [Amazon WorkSpaces Core](http://aws.amazon.com/workspaces/core/).
     */
    override suspend fun modifyWorkspaceProperties(input: ModifyWorkspacePropertiesRequest): ModifyWorkspacePropertiesResponse {
        val op = SdkHttpOperation.build<ModifyWorkspacePropertiesRequest, ModifyWorkspacePropertiesResponse> {
            serializer = ModifyWorkspacePropertiesOperationSerializer()
            deserializer = ModifyWorkspacePropertiesOperationDeserializer()
            operationName = "ModifyWorkspaceProperties"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the state of the specified WorkSpace.
     *
     * To maintain a WorkSpace without being interrupted, set the WorkSpace state to `ADMIN_MAINTENANCE`. WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the `ADMIN_MAINTENANCE` state.
     */
    override suspend fun modifyWorkspaceState(input: ModifyWorkspaceStateRequest): ModifyWorkspaceStateResponse {
        val op = SdkHttpOperation.build<ModifyWorkspaceStateRequest, ModifyWorkspaceStateResponse> {
            serializer = ModifyWorkspaceStateOperationSerializer()
            deserializer = ModifyWorkspaceStateOperationDeserializer()
            operationName = "ModifyWorkspaceState"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Reboots the specified WorkSpaces.
     *
     * You cannot reboot a WorkSpace unless its state is `AVAILABLE` or `UNHEALTHY`.
     *
     * This operation is asynchronous and returns before the WorkSpaces have rebooted.
     */
    override suspend fun rebootWorkspaces(input: RebootWorkspacesRequest): RebootWorkspacesResponse {
        val op = SdkHttpOperation.build<RebootWorkspacesRequest, RebootWorkspacesResponse> {
            serializer = RebootWorkspacesOperationSerializer()
            deserializer = RebootWorkspacesOperationDeserializer()
            operationName = "RebootWorkspaces"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Rebuilds the specified WorkSpace.
     *
     * You cannot rebuild a WorkSpace unless its state is `AVAILABLE`, `ERROR`, `UNHEALTHY`, `STOPPED`, or `REBOOTING`.
     *
     * Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see [Rebuild a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html).
     *
     * This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.
     */
    override suspend fun rebuildWorkspaces(input: RebuildWorkspacesRequest): RebuildWorkspacesResponse {
        val op = SdkHttpOperation.build<RebuildWorkspacesRequest, RebuildWorkspacesResponse> {
            serializer = RebuildWorkspacesOperationSerializer()
            deserializer = RebuildWorkspacesOperationDeserializer()
            operationName = "RebuildWorkspaces"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is registered. If this is the first time you are registering a directory, you will need to create the workspaces_DefaultRole role before you can register a directory. For more information, see [ Creating the workspaces_DefaultRole Role](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role).
     */
    override suspend fun registerWorkspaceDirectory(input: RegisterWorkspaceDirectoryRequest): RegisterWorkspaceDirectoryResponse {
        val op = SdkHttpOperation.build<RegisterWorkspaceDirectoryRequest, RegisterWorkspaceDirectoryResponse> {
            serializer = RegisterWorkspaceDirectoryOperationSerializer()
            deserializer = RegisterWorkspaceDirectoryOperationDeserializer()
            operationName = "RegisterWorkspaceDirectory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Restores the specified WorkSpace to its last known healthy state.
     *
     * You cannot restore a WorkSpace unless its state is ` AVAILABLE`, `ERROR`, `UNHEALTHY`, or `STOPPED`.
     *
     * Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see [Restore a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html).
     *
     * This operation is asynchronous and returns before the WorkSpace is completely restored.
     */
    override suspend fun restoreWorkspace(input: RestoreWorkspaceRequest): RestoreWorkspaceResponse {
        val op = SdkHttpOperation.build<RestoreWorkspaceRequest, RestoreWorkspaceResponse> {
            serializer = RestoreWorkspaceOperationSerializer()
            deserializer = RestoreWorkspaceOperationDeserializer()
            operationName = "RestoreWorkspace"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more rules from the specified IP access control group.
     */
    override suspend fun revokeIpRules(input: RevokeIpRulesRequest): RevokeIpRulesResponse {
        val op = SdkHttpOperation.build<RevokeIpRulesRequest, RevokeIpRulesResponse> {
            serializer = RevokeIpRulesOperationSerializer()
            deserializer = RevokeIpRulesOperationDeserializer()
            operationName = "RevokeIpRules"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts the specified WorkSpaces.
     *
     * You cannot start a WorkSpace unless it has a running mode of `AutoStop` and a state of `STOPPED`.
     */
    override suspend fun startWorkspaces(input: StartWorkspacesRequest): StartWorkspacesResponse {
        val op = SdkHttpOperation.build<StartWorkspacesRequest, StartWorkspacesResponse> {
            serializer = StartWorkspacesOperationSerializer()
            deserializer = StartWorkspacesOperationDeserializer()
            operationName = "StartWorkspaces"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops the specified WorkSpaces.
     *
     * You cannot stop a WorkSpace unless it has a running mode of `AutoStop` and a state of `AVAILABLE`, `IMPAIRED`, `UNHEALTHY`, or `ERROR`.
     */
    override suspend fun stopWorkspaces(input: StopWorkspacesRequest): StopWorkspacesResponse {
        val op = SdkHttpOperation.build<StopWorkspacesRequest, StopWorkspacesResponse> {
            serializer = StopWorkspacesOperationSerializer()
            deserializer = StopWorkspacesOperationDeserializer()
            operationName = "StopWorkspaces"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Terminates the specified WorkSpaces.
     *
     * Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to archive any user data, contact Amazon Web Services Support before terminating the WorkSpace.
     *
     * You can terminate a WorkSpace that is in any state except `SUSPENDED`.
     *
     * This operation is asynchronous and returns before the WorkSpaces have been completely terminated. After a WorkSpace is terminated, the `TERMINATED` state is returned only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using [ DescribeWorkSpaces](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html). If the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.
     *
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the [Directory Service pricing terms](http://aws.amazon.com/directoryservice/pricing/).
     *
     * To delete empty directories, see [ Delete the Directory for Your WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html). If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.
     */
    override suspend fun terminateWorkspaces(input: TerminateWorkspacesRequest): TerminateWorkspacesResponse {
        val op = SdkHttpOperation.build<TerminateWorkspacesRequest, TerminateWorkspacesResponse> {
            serializer = TerminateWorkspacesOperationSerializer()
            deserializer = TerminateWorkspacesOperationDeserializer()
            operationName = "TerminateWorkspaces"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a Amazon Connect client add-in. Use this action to update the name and endpoint URL of a Amazon Connect client add-in.
     */
    override suspend fun updateConnectClientAddIn(input: UpdateConnectClientAddInRequest): UpdateConnectClientAddInResponse {
        val op = SdkHttpOperation.build<UpdateConnectClientAddInRequest, UpdateConnectClientAddInResponse> {
            serializer = UpdateConnectClientAddInOperationSerializer()
            deserializer = UpdateConnectClientAddInOperationDeserializer()
            operationName = "UpdateConnectClientAddIn"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Shares or unshares a connection alias with one account by specifying whether that account has permission to associate the connection alias with a directory. If the association permission is granted, the connection alias is shared with that account. If the association permission is revoked, the connection alias is unshared with the account. For more information, see [ Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
     *
     * + Before performing this operation, call [ DescribeConnectionAliases](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html) to make sure that the current state of the connection alias is `CREATED`.
     * + To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.
     */
    override suspend fun updateConnectionAliasPermission(input: UpdateConnectionAliasPermissionRequest): UpdateConnectionAliasPermissionResponse {
        val op = SdkHttpOperation.build<UpdateConnectionAliasPermissionRequest, UpdateConnectionAliasPermissionResponse> {
            serializer = UpdateConnectionAliasPermissionOperationSerializer()
            deserializer = UpdateConnectionAliasPermissionOperationDeserializer()
            operationName = "UpdateConnectionAliasPermission"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Replaces the current rules of the specified IP access control group with the specified rules.
     */
    override suspend fun updateRulesOfIpGroup(input: UpdateRulesOfIpGroupRequest): UpdateRulesOfIpGroupResponse {
        val op = SdkHttpOperation.build<UpdateRulesOfIpGroupRequest, UpdateRulesOfIpGroupResponse> {
            serializer = UpdateRulesOfIpGroupOperationSerializer()
            deserializer = UpdateRulesOfIpGroupOperationDeserializer()
            operationName = "UpdateRulesOfIpGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see [ Update a Custom WorkSpaces Bundle](https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html).
     *
     * Existing WorkSpaces aren't automatically updated when you update the bundle that they're based on. To update existing WorkSpaces that are based on a bundle that you've updated, you must either rebuild the WorkSpaces or delete and recreate them.
     */
    override suspend fun updateWorkspaceBundle(input: UpdateWorkspaceBundleRequest): UpdateWorkspaceBundleResponse {
        val op = SdkHttpOperation.build<UpdateWorkspaceBundleRequest, UpdateWorkspaceBundleResponse> {
            serializer = UpdateWorkspaceBundleOperationSerializer()
            deserializer = UpdateWorkspaceBundleOperationDeserializer()
            operationName = "UpdateWorkspaceBundle"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Shares or unshares an image with one account in the same Amazon Web Services Region by specifying whether that account has permission to copy the image. If the copy image permission is granted, the image is shared with that account. If the copy image permission is revoked, the image is unshared with the account.
     *
     * After an image has been shared, the recipient account can copy the image to other Regions as needed.
     *
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     *
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services Support.
     *
     * For more information about sharing images, see [ Share or Unshare a Custom WorkSpaces Image](https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html).
     *
     * + To delete an image that has been shared, you must unshare the image before you delete it.
     * + Sharing Bring Your Own License (BYOL) images across Amazon Web Services accounts isn't supported at this time in Amazon Web Services GovCloud (US). To share BYOL images across accounts in Amazon Web Services GovCloud (US), contact Amazon Web Services Support.
     */
    override suspend fun updateWorkspaceImagePermission(input: UpdateWorkspaceImagePermissionRequest): UpdateWorkspaceImagePermissionResponse {
        val op = SdkHttpOperation.build<UpdateWorkspaceImagePermissionRequest, UpdateWorkspaceImagePermissionResponse> {
            serializer = UpdateWorkspaceImagePermissionOperationSerializer()
            deserializer = UpdateWorkspaceImagePermissionOperationDeserializer()
            operationName = "UpdateWorkspaceImagePermission"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("WorkspacesService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "workspaces")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
