/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.workspaces.endpoints;

import aws.sdk.kotlin.runtime.endpoint.functions.PartitionConfig;
import aws.sdk.kotlin.services.workspaces.endpoints.WorkSpacesEndpointParameters;
import aws.sdk.kotlin.services.workspaces.endpoints.WorkSpacesEndpointProvider;
import aws.sdk.kotlin.services.workspaces.endpoints.internal.PartitionsKt;
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint;
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException;
import aws.smithy.kotlin.runtime.net.Url;
import aws.smithy.kotlin.runtime.net.UrlDecoding;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\b"}, d2={"Laws/sdk/kotlin/services/workspaces/endpoints/DefaultWorkSpacesEndpointProvider;", "Laws/sdk/kotlin/services/workspaces/endpoints/WorkSpacesEndpointProvider;", "()V", "resolveEndpoint", "Laws/smithy/kotlin/runtime/client/endpoints/Endpoint;", "params", "Laws/sdk/kotlin/services/workspaces/endpoints/WorkSpacesEndpointParameters;", "(Laws/sdk/kotlin/services/workspaces/endpoints/WorkSpacesEndpointParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "workspaces"})
public final class DefaultWorkSpacesEndpointProvider
implements WorkSpacesEndpointProvider {
    @Nullable
    public Object resolveEndpoint(@NotNull WorkSpacesEndpointParameters params, @NotNull Continuation<? super Endpoint> $completion) {
        if (params.getEndpoint() != null) {
            if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true))) {
                throw new EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                throw new EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return new Endpoint(Url.Companion.parse(params.getEndpoint(), UrlDecoding.Companion.getDecodeAll().minus((UrlDecoding)UrlDecoding.DecodePath.INSTANCE)), null, 2, null);
        }
        if (params.getRegion() != null) {
            DefaultWorkSpacesEndpointProvider $this$resolveEndpoint_u24lambda_u240 = this;
            boolean bl = false;
            PartitionConfig partitionResult = PartitionsKt.partition(params.getRegion());
            if (partitionResult != null) {
                if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true)) && Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsFIPS()) && Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsDualStack())) {
                        return new Endpoint(Url.Companion.parse("https://workspaces-fips." + params.getRegion() + '.' + partitionResult.getDualStackDnsSuffix(), UrlDecoding.Companion.getDecodeAll().minus((UrlDecoding)UrlDecoding.DecodePath.INSTANCE)), null, 2, null);
                    }
                    throw new EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both");
                }
                if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsFIPS())) {
                        return new Endpoint(Url.Companion.parse("https://workspaces-fips." + params.getRegion() + '.' + partitionResult.getDnsSuffix(), UrlDecoding.Companion.getDecodeAll().minus((UrlDecoding)UrlDecoding.DecodePath.INSTANCE)), null, 2, null);
                    }
                    throw new EndpointProviderException("FIPS is enabled but this partition does not support FIPS");
                }
                if (Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsDualStack())) {
                        return new Endpoint(Url.Companion.parse("https://workspaces." + params.getRegion() + '.' + partitionResult.getDualStackDnsSuffix(), UrlDecoding.Companion.getDecodeAll().minus((UrlDecoding)UrlDecoding.DecodePath.INSTANCE)), null, 2, null);
                    }
                    throw new EndpointProviderException("DualStack is enabled but this partition does not support DualStack");
                }
                return new Endpoint(Url.Companion.parse("https://workspaces." + params.getRegion() + '.' + partitionResult.getDnsSuffix(), UrlDecoding.Companion.getDecodeAll().minus((UrlDecoding)UrlDecoding.DecodePath.INSTANCE)), null, 2, null);
            }
        }
        throw new EndpointProviderException("Invalid Configuration: Missing Region");
    }
}

