// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model



/**
 * Describes a WorkSpace.
 */
public class Workspace private constructor(builder: Builder) {
    /**
     * The identifier of the bundle used to create the WorkSpace.
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * The name of the WorkSpace, as seen by the operating system. The format of this name varies. For more information, see [ Launch a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/launch-workspaces-tutorials.html).
     */
    public val computerName: kotlin.String? = builder.computerName
    /**
     * The identifier of the Directory Service directory for the WorkSpace.
     */
    public val directoryId: kotlin.String? = builder.directoryId
    /**
     * The error code that is returned if the WorkSpace cannot be created.
     */
    public val errorCode: kotlin.String? = builder.errorCode
    /**
     * The text of the error message that is returned if the WorkSpace cannot be created.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The IP address of the WorkSpace.
     */
    public val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * The modification states of the WorkSpace.
     */
    public val modificationStates: List<ModificationState>? = builder.modificationStates
    /**
     * The standby WorkSpace or primary WorkSpace related to the specified WorkSpace.
     */
    public val relatedWorkspaces: List<RelatedWorkspaceProperties>? = builder.relatedWorkspaces
    /**
     * Indicates whether the data stored on the root volume is encrypted.
     */
    public val rootVolumeEncryptionEnabled: kotlin.Boolean? = builder.rootVolumeEncryptionEnabled
    /**
     * The operational state of the WorkSpace.
     *
     * After a WorkSpace is terminated, the `TERMINATED` state is returned only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using [ DescribeWorkSpaces](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html). If the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.
     */
    public val state: aws.sdk.kotlin.services.workspaces.model.WorkspaceState? = builder.state
    /**
     * The identifier of the subnet for the WorkSpace.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * The user for the WorkSpace.
     */
    public val userName: kotlin.String? = builder.userName
    /**
     * Indicates whether the data stored on the user volume is encrypted.
     */
    public val userVolumeEncryptionEnabled: kotlin.Boolean? = builder.userVolumeEncryptionEnabled
    /**
     * The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not support asymmetric KMS keys.
     */
    public val volumeEncryptionKey: kotlin.String? = builder.volumeEncryptionKey
    /**
     * The identifier of the WorkSpace.
     */
    public val workspaceId: kotlin.String? = builder.workspaceId
    /**
     * The properties of the WorkSpace.
     */
    public val workspaceProperties: aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties? = builder.workspaceProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.Workspace = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Workspace(")
        append("bundleId=$bundleId,")
        append("computerName=$computerName,")
        append("directoryId=$directoryId,")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("ipAddress=$ipAddress,")
        append("modificationStates=$modificationStates,")
        append("relatedWorkspaces=$relatedWorkspaces,")
        append("rootVolumeEncryptionEnabled=$rootVolumeEncryptionEnabled,")
        append("state=$state,")
        append("subnetId=$subnetId,")
        append("userName=$userName,")
        append("userVolumeEncryptionEnabled=$userVolumeEncryptionEnabled,")
        append("volumeEncryptionKey=$volumeEncryptionKey,")
        append("workspaceId=$workspaceId,")
        append("workspaceProperties=$workspaceProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bundleId?.hashCode() ?: 0
        result = 31 * result + (computerName?.hashCode() ?: 0)
        result = 31 * result + (directoryId?.hashCode() ?: 0)
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (modificationStates?.hashCode() ?: 0)
        result = 31 * result + (relatedWorkspaces?.hashCode() ?: 0)
        result = 31 * result + (rootVolumeEncryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        result = 31 * result + (userVolumeEncryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (volumeEncryptionKey?.hashCode() ?: 0)
        result = 31 * result + (workspaceId?.hashCode() ?: 0)
        result = 31 * result + (workspaceProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Workspace

        if (bundleId != other.bundleId) return false
        if (computerName != other.computerName) return false
        if (directoryId != other.directoryId) return false
        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (ipAddress != other.ipAddress) return false
        if (modificationStates != other.modificationStates) return false
        if (relatedWorkspaces != other.relatedWorkspaces) return false
        if (rootVolumeEncryptionEnabled != other.rootVolumeEncryptionEnabled) return false
        if (state != other.state) return false
        if (subnetId != other.subnetId) return false
        if (userName != other.userName) return false
        if (userVolumeEncryptionEnabled != other.userVolumeEncryptionEnabled) return false
        if (volumeEncryptionKey != other.volumeEncryptionKey) return false
        if (workspaceId != other.workspaceId) return false
        if (workspaceProperties != other.workspaceProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.Workspace = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the bundle used to create the WorkSpace.
         */
        public var bundleId: kotlin.String? = null
        /**
         * The name of the WorkSpace, as seen by the operating system. The format of this name varies. For more information, see [ Launch a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/launch-workspaces-tutorials.html).
         */
        public var computerName: kotlin.String? = null
        /**
         * The identifier of the Directory Service directory for the WorkSpace.
         */
        public var directoryId: kotlin.String? = null
        /**
         * The error code that is returned if the WorkSpace cannot be created.
         */
        public var errorCode: kotlin.String? = null
        /**
         * The text of the error message that is returned if the WorkSpace cannot be created.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * The IP address of the WorkSpace.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * The modification states of the WorkSpace.
         */
        public var modificationStates: List<ModificationState>? = null
        /**
         * The standby WorkSpace or primary WorkSpace related to the specified WorkSpace.
         */
        public var relatedWorkspaces: List<RelatedWorkspaceProperties>? = null
        /**
         * Indicates whether the data stored on the root volume is encrypted.
         */
        public var rootVolumeEncryptionEnabled: kotlin.Boolean? = null
        /**
         * The operational state of the WorkSpace.
         *
         * After a WorkSpace is terminated, the `TERMINATED` state is returned only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using [ DescribeWorkSpaces](https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html). If the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.
         */
        public var state: aws.sdk.kotlin.services.workspaces.model.WorkspaceState? = null
        /**
         * The identifier of the subnet for the WorkSpace.
         */
        public var subnetId: kotlin.String? = null
        /**
         * The user for the WorkSpace.
         */
        public var userName: kotlin.String? = null
        /**
         * Indicates whether the data stored on the user volume is encrypted.
         */
        public var userVolumeEncryptionEnabled: kotlin.Boolean? = null
        /**
         * The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not support asymmetric KMS keys.
         */
        public var volumeEncryptionKey: kotlin.String? = null
        /**
         * The identifier of the WorkSpace.
         */
        public var workspaceId: kotlin.String? = null
        /**
         * The properties of the WorkSpace.
         */
        public var workspaceProperties: aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.Workspace) : this() {
            this.bundleId = x.bundleId
            this.computerName = x.computerName
            this.directoryId = x.directoryId
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.ipAddress = x.ipAddress
            this.modificationStates = x.modificationStates
            this.relatedWorkspaces = x.relatedWorkspaces
            this.rootVolumeEncryptionEnabled = x.rootVolumeEncryptionEnabled
            this.state = x.state
            this.subnetId = x.subnetId
            this.userName = x.userName
            this.userVolumeEncryptionEnabled = x.userVolumeEncryptionEnabled
            this.volumeEncryptionKey = x.volumeEncryptionKey
            this.workspaceId = x.workspaceId
            this.workspaceProperties = x.workspaceProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.Workspace = Workspace(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties] inside the given [block]
         */
        public fun workspaceProperties(block: aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties.Builder.() -> kotlin.Unit) {
            this.workspaceProperties = aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties.invoke(block)
        }
    }
}
