// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.transform

import aws.sdk.kotlin.services.workspaces.model.DescribeWorkspaceSnapshotsResponse
import aws.sdk.kotlin.services.workspaces.model.Snapshot
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeWorkspaceSnapshotsOperationDeserializer: HttpDeserialize<DescribeWorkspaceSnapshotsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeWorkspaceSnapshotsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeWorkspaceSnapshotsError(context, response)
        }
        val builder = DescribeWorkspaceSnapshotsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeWorkspaceSnapshotsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeWorkspaceSnapshotsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValuesException" -> InvalidParameterValuesExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeWorkspaceSnapshotsOperationBody(builder: DescribeWorkspaceSnapshotsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REBUILDSNAPSHOTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RebuildSnapshots"))
    val RESTORESNAPSHOTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RestoreSnapshots"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REBUILDSNAPSHOTS_DESCRIPTOR)
        field(RESTORESNAPSHOTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REBUILDSNAPSHOTS_DESCRIPTOR.index -> builder.rebuildSnapshots =
                    deserializer.deserializeList(REBUILDSNAPSHOTS_DESCRIPTOR) {
                        val col0 = mutableListOf<Snapshot>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSnapshotDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESTORESNAPSHOTS_DESCRIPTOR.index -> builder.restoreSnapshots =
                    deserializer.deserializeList(RESTORESNAPSHOTS_DESCRIPTOR) {
                        val col0 = mutableListOf<Snapshot>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSnapshotDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
