// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workspaces.model.FailedWorkspaceChangeRequest
import aws.sdk.kotlin.services.workspaces.model.StopWorkspacesResponse
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class StopWorkspacesOperationDeserializer: HttpDeserialize<StopWorkspacesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StopWorkspacesResponse {
        if (!response.status.isSuccess()) {
            throwStopWorkspacesError(context, response)
        }
        val builder = StopWorkspacesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStopWorkspacesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStopWorkspacesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStopWorkspacesOperationBody(builder: StopWorkspacesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILEDREQUESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FailedRequests"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILEDREQUESTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILEDREQUESTS_DESCRIPTOR.index -> builder.failedRequests =
                    deserializer.deserializeList(FAILEDREQUESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<FailedWorkspaceChangeRequest>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFailedWorkspaceChangeRequestDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
