// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workspaces.model.DedicatedTenancySupportResultEnum
import aws.sdk.kotlin.services.workspaces.model.DescribeAccountResponse
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeAccountOperationDeserializer: HttpDeserialize<DescribeAccountResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAccountResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAccountError(context, response)
        }
        val builder = DescribeAccountResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAccountOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAccountError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAccountOperationBody(builder: DescribeAccountResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEDICATEDTENANCYMANAGEMENTCIDRRANGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DedicatedTenancyManagementCidrRange"))
    val DEDICATEDTENANCYSUPPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DedicatedTenancySupport"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEDICATEDTENANCYMANAGEMENTCIDRRANGE_DESCRIPTOR)
        field(DEDICATEDTENANCYSUPPORT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEDICATEDTENANCYMANAGEMENTCIDRRANGE_DESCRIPTOR.index -> builder.dedicatedTenancyManagementCidrRange = deserializeString()
                DEDICATEDTENANCYSUPPORT_DESCRIPTOR.index -> builder.dedicatedTenancySupport = deserializeString().let { DedicatedTenancySupportResultEnum.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
