// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workspaces.model.CreateWorkspacesResponse
import aws.sdk.kotlin.services.workspaces.model.FailedCreateWorkspaceRequest
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.sdk.kotlin.services.workspaces.model.Workspace
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateWorkspacesOperationDeserializer: HttpDeserialize<CreateWorkspacesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateWorkspacesResponse {
        if (!response.status.isSuccess()) {
            throwCreateWorkspacesError(context, response)
        }
        val builder = CreateWorkspacesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateWorkspacesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateWorkspacesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValuesException" -> InvalidParameterValuesExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceLimitExceededException" -> ResourceLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateWorkspacesOperationBody(builder: CreateWorkspacesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILEDREQUESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FailedRequests"))
    val PENDINGREQUESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PendingRequests"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILEDREQUESTS_DESCRIPTOR)
        field(PENDINGREQUESTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILEDREQUESTS_DESCRIPTOR.index -> builder.failedRequests =
                    deserializer.deserializeList(FAILEDREQUESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<FailedCreateWorkspaceRequest>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFailedCreateWorkspaceRequestDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PENDINGREQUESTS_DESCRIPTOR.index -> builder.pendingRequests =
                    deserializer.deserializeList(PENDINGREQUESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<Workspace>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWorkspaceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
