// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workspaces.model.CreateWorkspaceImageResponse
import aws.sdk.kotlin.services.workspaces.model.OperatingSystem
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.sdk.kotlin.services.workspaces.model.WorkspaceImageRequiredTenancy
import aws.sdk.kotlin.services.workspaces.model.WorkspaceImageState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateWorkspaceImageOperationDeserializer: HttpDeserialize<CreateWorkspaceImageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateWorkspaceImageResponse {
        if (!response.status.isSuccess()) {
            throwCreateWorkspaceImageError(context, response)
        }
        val builder = CreateWorkspaceImageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateWorkspaceImageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateWorkspaceImageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValuesException" -> InvalidParameterValuesExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidResourceStateException" -> InvalidResourceStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotSupportedException" -> OperationNotSupportedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceLimitExceededException" -> ResourceLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateWorkspaceImageOperationBody(builder: CreateWorkspaceImageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("Created"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val IMAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageId"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OPERATINGSYSTEM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OperatingSystem"))
    val OWNERACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OwnerAccountId"))
    val REQUIREDTENANCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("RequiredTenancy"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATED_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(IMAGEID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OPERATINGSYSTEM_DESCRIPTOR)
        field(OWNERACCOUNTID_DESCRIPTOR)
        field(REQUIREDTENANCY_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATED_DESCRIPTOR.index -> builder.created = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                IMAGEID_DESCRIPTOR.index -> builder.imageId = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OPERATINGSYSTEM_DESCRIPTOR.index -> builder.operatingSystem = deserializeOperatingSystemDocument(deserializer)
                OWNERACCOUNTID_DESCRIPTOR.index -> builder.ownerAccountId = deserializeString()
                REQUIREDTENANCY_DESCRIPTOR.index -> builder.requiredTenancy = deserializeString().let { WorkspaceImageRequiredTenancy.fromValue(it) }
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { WorkspaceImageState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
