// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmailmessageflow.transform

import aws.sdk.kotlin.services.workmailmessageflow.model.PutRawMessageContentResponse
import aws.sdk.kotlin.services.workmailmessageflow.model.WorkMailMessageFlowException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutRawMessageContentOperationDeserializer: HttpDeserialize<PutRawMessageContentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutRawMessageContentResponse {
        if (!response.status.isSuccess()) {
            throwPutRawMessageContentError(context, response)
        }
        val builder = PutRawMessageContentResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwPutRawMessageContentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailMessageFlowException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidContentLocation" -> InvalidContentLocationDeserializer().deserialize(context, wrappedResponse)
        "MessageFrozen" -> MessageFrozenDeserializer().deserialize(context, wrappedResponse)
        "MessageRejected" -> MessageRejectedDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkMailMessageFlowException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
