// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmailmessageflow.model



/**
 * Amazon S3 object representing the updated message content, in MIME format.
 *
 * The region for the S3 bucket containing the S3 object must match the region used for WorkMail operations. Also, for WorkMail to process an S3 object, it must have permission to access that object. For more information, see [ Updating message content with AWS Lambda](https://docs.aws.amazon.com/workmail/latest/adminguide/update-with-lambda.html).
 */
public class S3Reference private constructor(builder: Builder) {
    /**
     * The S3 bucket name.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The S3 key object name.
     */
    public val key: kotlin.String? = builder.key
    /**
     * If you enable versioning for the bucket, you can specify the object version.
     */
    public val objectVersion: kotlin.String? = builder.objectVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workmailmessageflow.model.S3Reference = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Reference(")
        append("bucket=$bucket,")
        append("key=$key,")
        append("objectVersion=$objectVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (objectVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Reference

        if (bucket != other.bucket) return false
        if (key != other.key) return false
        if (objectVersion != other.objectVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workmailmessageflow.model.S3Reference = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The S3 bucket name.
         */
        public var bucket: kotlin.String? = null
        /**
         * The S3 key object name.
         */
        public var key: kotlin.String? = null
        /**
         * If you enable versioning for the bucket, you can specify the object version.
         */
        public var objectVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workmailmessageflow.model.S3Reference) : this() {
            this.bucket = x.bucket
            this.key = x.key
            this.objectVersion = x.objectVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workmailmessageflow.model.S3Reference = S3Reference(this)
    }
}
