// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmailmessageflow.serde

import aws.sdk.kotlin.services.workmailmessageflow.model.PutRawMessageContentResponse
import aws.sdk.kotlin.services.workmailmessageflow.model.WorkMailMessageFlowException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutRawMessageContentOperationDeserializer: HttpDeserializer.NonStreaming<PutRawMessageContentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutRawMessageContentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutRawMessageContentError(context, call, payload)
        }
        val builder = PutRawMessageContentResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutRawMessageContentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailMessageFlowException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidContentLocation" -> InvalidContentLocationDeserializer().deserialize(context, wrappedCall, payload)
        "MessageFrozen" -> MessageFrozenDeserializer().deserialize(context, wrappedCall, payload)
        "MessageRejected" -> MessageRejectedDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkMailMessageFlowException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
