// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmailmessageflow.transform

import aws.sdk.kotlin.services.workmailmessageflow.model.GetRawMessageContentResponse
import aws.sdk.kotlin.services.workmailmessageflow.model.WorkMailMessageFlowException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.http.toByteStream
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class GetRawMessageContentOperationDeserializer: HttpDeserialize<GetRawMessageContentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRawMessageContentResponse {
        if (!response.status.isSuccess()) {
            throwGetRawMessageContentError(context, response)
        }
        val builder = GetRawMessageContentResponse.Builder()

        builder.messageContent = response.body.toByteStream()

        return builder.build()
    }
}

private suspend fun throwGetRawMessageContentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailMessageFlowException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkMailMessageFlowException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
