// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workmail.model.ListMobileDeviceAccessOverridesResponse
import aws.sdk.kotlin.services.workmail.model.MobileDeviceAccessOverride
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListMobileDeviceAccessOverridesOperationDeserializer: HttpDeserialize<ListMobileDeviceAccessOverridesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListMobileDeviceAccessOverridesResponse {
        if (!response.status.isSuccess()) {
            throwListMobileDeviceAccessOverridesError(context, response)
        }
        val builder = ListMobileDeviceAccessOverridesResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListMobileDeviceAccessOverridesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeListMobileDeviceAccessOverridesOperationBody(builder: ListMobileDeviceAccessOverridesResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OVERRIDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Overrides"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(OVERRIDES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                OVERRIDES_DESCRIPTOR.index -> builder.overrides =
                    deserializer.deserializeList(OVERRIDES_DESCRIPTOR) {
                        val col0 = mutableListOf<MobileDeviceAccessOverride>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMobileDeviceAccessOverrideDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwListMobileDeviceAccessOverridesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer()
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer()
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer()
        else -> throw WorkMailException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
