// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workmail.model.GetMobileDeviceAccessOverrideResponse
import aws.sdk.kotlin.services.workmail.model.MobileDeviceAccessRuleEffect
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetMobileDeviceAccessOverrideOperationDeserializer: HttpDeserialize<GetMobileDeviceAccessOverrideResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetMobileDeviceAccessOverrideResponse {
        if (!response.status.isSuccess()) {
            throwGetMobileDeviceAccessOverrideError(context, response)
        }
        val builder = GetMobileDeviceAccessOverrideResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMobileDeviceAccessOverrideOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeGetMobileDeviceAccessOverrideOperationBody(builder: GetMobileDeviceAccessOverrideResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATECREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DateCreated"))
    val DATEMODIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DateModified"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DEVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceId"))
    val EFFECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Effect"))
    val USERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UserId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATECREATED_DESCRIPTOR)
        field(DATEMODIFIED_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DEVICEID_DESCRIPTOR)
        field(EFFECT_DESCRIPTOR)
        field(USERID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATECREATED_DESCRIPTOR.index -> builder.dateCreated = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATEMODIFIED_DESCRIPTOR.index -> builder.dateModified = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DEVICEID_DESCRIPTOR.index -> builder.deviceId = deserializeString()
                EFFECT_DESCRIPTOR.index -> builder.effect = deserializeString().let { MobileDeviceAccessRuleEffect.fromValue(it) }
                USERID_DESCRIPTOR.index -> builder.userId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetMobileDeviceAccessOverrideError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer()
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer()
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        else -> throw WorkMailException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
