// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workmail.model.GetMobileDeviceAccessEffectResponse
import aws.sdk.kotlin.services.workmail.model.MobileDeviceAccessMatchedRule
import aws.sdk.kotlin.services.workmail.model.MobileDeviceAccessRuleEffect
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetMobileDeviceAccessEffectOperationDeserializer: HttpDeserialize<GetMobileDeviceAccessEffectResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetMobileDeviceAccessEffectResponse {
        if (!response.status.isSuccess()) {
            throwGetMobileDeviceAccessEffectError(context, response)
        }
        val builder = GetMobileDeviceAccessEffectResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMobileDeviceAccessEffectOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeGetMobileDeviceAccessEffectOperationBody(builder: GetMobileDeviceAccessEffectResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EFFECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Effect"))
    val MATCHEDRULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MatchedRules"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EFFECT_DESCRIPTOR)
        field(MATCHEDRULES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EFFECT_DESCRIPTOR.index -> builder.effect = deserializeString().let { MobileDeviceAccessRuleEffect.fromValue(it) }
                MATCHEDRULES_DESCRIPTOR.index -> builder.matchedRules =
                    deserializer.deserializeList(MATCHEDRULES_DESCRIPTOR) {
                        val col0 = mutableListOf<MobileDeviceAccessMatchedRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMobileDeviceAccessMatchedRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetMobileDeviceAccessEffectError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer()
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer()
        else -> throw WorkMailException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
