// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workmail.model.DnsRecord
import aws.sdk.kotlin.services.workmail.model.DnsRecordVerificationStatus
import aws.sdk.kotlin.services.workmail.model.GetMailDomainResponse
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetMailDomainOperationDeserializer: HttpDeserialize<GetMailDomainResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetMailDomainResponse {
        if (!response.status.isSuccess()) {
            throwGetMailDomainError(context, response)
        }
        val builder = GetMailDomainResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMailDomainOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeGetMailDomainOperationBody(builder: GetMailDomainResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DKIMVERIFICATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DkimVerificationStatus"))
    val ISDEFAULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsDefault"))
    val ISTESTDOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsTestDomain"))
    val OWNERSHIPVERIFICATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OwnershipVerificationStatus"))
    val RECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Records"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DKIMVERIFICATIONSTATUS_DESCRIPTOR)
        field(ISDEFAULT_DESCRIPTOR)
        field(ISTESTDOMAIN_DESCRIPTOR)
        field(OWNERSHIPVERIFICATIONSTATUS_DESCRIPTOR)
        field(RECORDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DKIMVERIFICATIONSTATUS_DESCRIPTOR.index -> builder.dkimVerificationStatus = deserializeString().let { DnsRecordVerificationStatus.fromValue(it) }
                ISDEFAULT_DESCRIPTOR.index -> builder.isDefault = deserializeBoolean()
                ISTESTDOMAIN_DESCRIPTOR.index -> builder.isTestDomain = deserializeBoolean()
                OWNERSHIPVERIFICATIONSTATUS_DESCRIPTOR.index -> builder.ownershipVerificationStatus = deserializeString().let { DnsRecordVerificationStatus.fromValue(it) }
                RECORDS_DESCRIPTOR.index -> builder.records =
                    deserializer.deserializeList(RECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<DnsRecord>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDnsRecordDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetMailDomainError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "MailDomainNotFoundException" -> MailDomainNotFoundExceptionDeserializer()
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer()
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer()
        else -> throw WorkMailException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
