// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workmail.model.DescribeResourceResponse
import aws.sdk.kotlin.services.workmail.model.EntityState
import aws.sdk.kotlin.services.workmail.model.ResourceType
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeResourceOperationDeserializer: HttpDeserialize<DescribeResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeResourceResponse {
        if (!response.status.isSuccess()) {
            throwDescribeResourceError(context, response)
        }
        val builder = DescribeResourceResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeResourceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeResourceOperationBody(builder: DescribeResourceResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOOKINGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BookingOptions"))
    val DISABLEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DisabledDate"))
    val EMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Email"))
    val ENABLEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EnabledDate"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val RESOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceId"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOOKINGOPTIONS_DESCRIPTOR)
        field(DISABLEDDATE_DESCRIPTOR)
        field(EMAIL_DESCRIPTOR)
        field(ENABLEDDATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RESOURCEID_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOOKINGOPTIONS_DESCRIPTOR.index -> builder.bookingOptions = deserializeBookingOptionsDocument(deserializer)
                DISABLEDDATE_DESCRIPTOR.index -> builder.disabledDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                EMAIL_DESCRIPTOR.index -> builder.email = deserializeString()
                ENABLEDDATE_DESCRIPTOR.index -> builder.enabledDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                RESOURCEID_DESCRIPTOR.index -> builder.resourceId = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { EntityState.fromValue(it) }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { ResourceType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeResourceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer()
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer()
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer()
        else -> throw WorkMailException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
