// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workmail.model.DescribeOrganizationResponse
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeOrganizationOperationDeserializer: HttpDeserialize<DescribeOrganizationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeOrganizationResponse {
        if (!response.status.isSuccess()) {
            throwDescribeOrganizationError(context, response)
        }
        val builder = DescribeOrganizationResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeOrganizationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeOrganizationOperationBody(builder: DescribeOrganizationResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ARN"))
    val ALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Alias"))
    val COMPLETEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompletedDate"))
    val DEFAULTMAILDOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultMailDomain"))
    val DIRECTORYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DirectoryId"))
    val DIRECTORYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DirectoryType"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val ORGANIZATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OrganizationId"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ALIAS_DESCRIPTOR)
        field(COMPLETEDDATE_DESCRIPTOR)
        field(DEFAULTMAILDOMAIN_DESCRIPTOR)
        field(DIRECTORYID_DESCRIPTOR)
        field(DIRECTORYTYPE_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(ORGANIZATIONID_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ALIAS_DESCRIPTOR.index -> builder.alias = deserializeString()
                COMPLETEDDATE_DESCRIPTOR.index -> builder.completedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEFAULTMAILDOMAIN_DESCRIPTOR.index -> builder.defaultMailDomain = deserializeString()
                DIRECTORYID_DESCRIPTOR.index -> builder.directoryId = deserializeString()
                DIRECTORYTYPE_DESCRIPTOR.index -> builder.directoryType = deserializeString()
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                ORGANIZATIONID_DESCRIPTOR.index -> builder.organizationId = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeOrganizationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer()
        else -> throw WorkMailException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
