// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workmail.model.DescribeMailboxExportJobResponse
import aws.sdk.kotlin.services.workmail.model.MailboxExportJobState
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeMailboxExportJobOperationDeserializer: HttpDeserialize<DescribeMailboxExportJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeMailboxExportJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeMailboxExportJobError(context, response)
        }
        val builder = DescribeMailboxExportJobResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeMailboxExportJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeMailboxExportJobOperationBody(builder: DescribeMailboxExportJobResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val ENTITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EntityId"))
    val ERRORINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorInfo"))
    val ESTIMATEDPROGRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("EstimatedProgress"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyArn"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val S3BUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3BucketName"))
    val S3PATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3Path"))
    val S3PREFIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3Prefix"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(ENTITYID_DESCRIPTOR)
        field(ERRORINFO_DESCRIPTOR)
        field(ESTIMATEDPROGRESS_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(S3BUCKETNAME_DESCRIPTOR)
        field(S3PATH_DESCRIPTOR)
        field(S3PREFIX_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ENTITYID_DESCRIPTOR.index -> builder.entityId = deserializeString()
                ERRORINFO_DESCRIPTOR.index -> builder.errorInfo = deserializeString()
                ESTIMATEDPROGRESS_DESCRIPTOR.index -> builder.estimatedProgress = deserializeInt()
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                S3BUCKETNAME_DESCRIPTOR.index -> builder.s3BucketName = deserializeString()
                S3PATH_DESCRIPTOR.index -> builder.s3Path = deserializeString()
                S3PREFIX_DESCRIPTOR.index -> builder.s3Prefix = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { MailboxExportJobState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeMailboxExportJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer()
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer()
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer()
        else -> throw WorkMailException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
