// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.workmail.model.CreateAliasResponse
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class CreateAliasOperationDeserializer: HttpDeserialize<CreateAliasResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateAliasResponse {
        if (!response.status.isSuccess()) {
            throwCreateAliasError(context, response)
        }
        val builder = CreateAliasResponse.builder()

        return builder.build()
    }
}

private suspend fun throwCreateAliasError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "EmailAddressInUseException" -> EmailAddressInUseExceptionDeserializer()
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer()
        "EntityStateException" -> EntityStateExceptionDeserializer()
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "MailDomainNotFoundException" -> MailDomainNotFoundExceptionDeserializer()
        "MailDomainStateException" -> MailDomainStateExceptionDeserializer()
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer()
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer()
        else -> throw WorkMailException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
