// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The representation of an Amazon WorkMail user.
 */
class User private constructor(builder: BuilderImpl) {
    /**
     * The date indicating when the user was disabled from Amazon WorkMail use.
     */
    val disabledDate: Instant? = builder.disabledDate
    /**
     * The display name of the user.
     */
    val displayName: String? = builder.displayName
    /**
     * The email of the user.
     */
    val email: String? = builder.email
    /**
     * The date indicating when the user was enabled for Amazon WorkMail use.
     */
    val enabledDate: Instant? = builder.enabledDate
    /**
     * The identifier of the user.
     */
    val id: String? = builder.id
    /**
     * The name of the user.
     */
    val name: String? = builder.name
    /**
     * The state of the user, which can be ENABLED, DISABLED, or DELETED.
     */
    val state: EntityState? = builder.state
    /**
     * The role of the user.
     */
    val userRole: UserRole? = builder.userRole

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): User = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("User(")
        append("disabledDate=$disabledDate,")
        append("displayName=$displayName,")
        append("email=$email,")
        append("enabledDate=$enabledDate,")
        append("id=$id,")
        append("name=$name,")
        append("state=$state,")
        append("userRole=$userRole)")
    }

    override fun hashCode(): kotlin.Int {
        var result = disabledDate?.hashCode() ?: 0
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (enabledDate?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (userRole?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as User

        if (disabledDate != other.disabledDate) return false
        if (displayName != other.displayName) return false
        if (email != other.email) return false
        if (enabledDate != other.enabledDate) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (state != other.state) return false
        if (userRole != other.userRole) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): User = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): User
        /**
         * The date indicating when the user was disabled from Amazon WorkMail use.
         */
        fun disabledDate(disabledDate: Instant): FluentBuilder
        /**
         * The display name of the user.
         */
        fun displayName(displayName: String): FluentBuilder
        /**
         * The email of the user.
         */
        fun email(email: String): FluentBuilder
        /**
         * The date indicating when the user was enabled for Amazon WorkMail use.
         */
        fun enabledDate(enabledDate: Instant): FluentBuilder
        /**
         * The identifier of the user.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name of the user.
         */
        fun name(name: String): FluentBuilder
        /**
         * The state of the user, which can be ENABLED, DISABLED, or DELETED.
         */
        fun state(state: EntityState): FluentBuilder
        /**
         * The role of the user.
         */
        fun userRole(userRole: UserRole): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date indicating when the user was disabled from Amazon WorkMail use.
         */
        var disabledDate: Instant?
        /**
         * The display name of the user.
         */
        var displayName: String?
        /**
         * The email of the user.
         */
        var email: String?
        /**
         * The date indicating when the user was enabled for Amazon WorkMail use.
         */
        var enabledDate: Instant?
        /**
         * The identifier of the user.
         */
        var id: String?
        /**
         * The name of the user.
         */
        var name: String?
        /**
         * The state of the user, which can be ENABLED, DISABLED, or DELETED.
         */
        var state: EntityState?
        /**
         * The role of the user.
         */
        var userRole: UserRole?

        fun build(): User
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var disabledDate: Instant? = null
        override var displayName: String? = null
        override var email: String? = null
        override var enabledDate: Instant? = null
        override var id: String? = null
        override var name: String? = null
        override var state: EntityState? = null
        override var userRole: UserRole? = null

        constructor(x: User) : this() {
            this.disabledDate = x.disabledDate
            this.displayName = x.displayName
            this.email = x.email
            this.enabledDate = x.enabledDate
            this.id = x.id
            this.name = x.name
            this.state = x.state
            this.userRole = x.userRole
        }

        override fun build(): User = User(this)
        override fun disabledDate(disabledDate: Instant): FluentBuilder = apply { this.disabledDate = disabledDate }
        override fun displayName(displayName: String): FluentBuilder = apply { this.displayName = displayName }
        override fun email(email: String): FluentBuilder = apply { this.email = email }
        override fun enabledDate(enabledDate: Instant): FluentBuilder = apply { this.enabledDate = enabledDate }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun state(state: EntityState): FluentBuilder = apply { this.state = state }
        override fun userRole(userRole: UserRole): FluentBuilder = apply { this.userRole = userRole }
    }
}
