// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model



class PutMailboxPermissionsRequest private constructor(builder: BuilderImpl) {
    /**
     * The identifier of the user, group, or resource for which to update mailbox
     * permissions.
     */
    val entityId: String? = builder.entityId
    /**
     * The identifier of the user, group, or resource to which to grant the
     * permissions.
     */
    val granteeId: String? = builder.granteeId
    /**
     * The identifier of the organization under which the user, group, or resource
     * exists.
     */
    val organizationId: String? = builder.organizationId
    /**
     * The permissions granted to the grantee. SEND_AS allows the grantee to send email as
     * the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF
     * allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not
     * mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full
     * access to the mailbox, irrespective of other folder-level permissions set on the
     * mailbox.
     */
    val permissionValues: List<PermissionType>? = builder.permissionValues

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PutMailboxPermissionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PutMailboxPermissionsRequest(")
        append("entityId=$entityId,")
        append("granteeId=$granteeId,")
        append("organizationId=$organizationId,")
        append("permissionValues=$permissionValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = entityId?.hashCode() ?: 0
        result = 31 * result + (granteeId?.hashCode() ?: 0)
        result = 31 * result + (organizationId?.hashCode() ?: 0)
        result = 31 * result + (permissionValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutMailboxPermissionsRequest

        if (entityId != other.entityId) return false
        if (granteeId != other.granteeId) return false
        if (organizationId != other.organizationId) return false
        if (permissionValues != other.permissionValues) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PutMailboxPermissionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PutMailboxPermissionsRequest
        /**
         * The identifier of the user, group, or resource for which to update mailbox
         * permissions.
         */
        fun entityId(entityId: String): FluentBuilder
        /**
         * The identifier of the user, group, or resource to which to grant the
         * permissions.
         */
        fun granteeId(granteeId: String): FluentBuilder
        /**
         * The identifier of the organization under which the user, group, or resource
         * exists.
         */
        fun organizationId(organizationId: String): FluentBuilder
        /**
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as
         * the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF
         * allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not
         * mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full
         * access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         */
        fun permissionValues(permissionValues: List<PermissionType>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier of the user, group, or resource for which to update mailbox
         * permissions.
         */
        var entityId: String?
        /**
         * The identifier of the user, group, or resource to which to grant the
         * permissions.
         */
        var granteeId: String?
        /**
         * The identifier of the organization under which the user, group, or resource
         * exists.
         */
        var organizationId: String?
        /**
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as
         * the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF
         * allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not
         * mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full
         * access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         */
        var permissionValues: List<PermissionType>?

        fun build(): PutMailboxPermissionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var entityId: String? = null
        override var granteeId: String? = null
        override var organizationId: String? = null
        override var permissionValues: List<PermissionType>? = null

        constructor(x: PutMailboxPermissionsRequest) : this() {
            this.entityId = x.entityId
            this.granteeId = x.granteeId
            this.organizationId = x.organizationId
            this.permissionValues = x.permissionValues
        }

        override fun build(): PutMailboxPermissionsRequest = PutMailboxPermissionsRequest(this)
        override fun entityId(entityId: String): FluentBuilder = apply { this.entityId = entityId }
        override fun granteeId(granteeId: String): FluentBuilder = apply { this.granteeId = granteeId }
        override fun organizationId(organizationId: String): FluentBuilder = apply { this.organizationId = organizationId }
        override fun permissionValues(permissionValues: List<PermissionType>): FluentBuilder = apply { this.permissionValues = permissionValues }
    }
}
