// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model



/**
 * Permission granted to a user, group, or resource to access a certain aspect of
 * another user, group, or resource mailbox.
 */
class Permission private constructor(builder: BuilderImpl) {
    /**
     * The identifier of the user, group, or resource to which the permissions are
     * granted.
     */
    val granteeId: String? = builder.granteeId
    /**
     * The type of user, group, or resource referred to in GranteeId.
     */
    val granteeType: MemberType? = builder.granteeType
    /**
     * The permissions granted to the grantee. SEND_AS allows the grantee to send email as
     * the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF
     * allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not
     * mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full
     * access to the mailbox, irrespective of other folder-level permissions set on the
     * mailbox.
     */
    val permissionValues: List<PermissionType>? = builder.permissionValues

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Permission = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Permission(")
        append("granteeId=$granteeId,")
        append("granteeType=$granteeType,")
        append("permissionValues=$permissionValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = granteeId?.hashCode() ?: 0
        result = 31 * result + (granteeType?.hashCode() ?: 0)
        result = 31 * result + (permissionValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Permission

        if (granteeId != other.granteeId) return false
        if (granteeType != other.granteeType) return false
        if (permissionValues != other.permissionValues) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Permission = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Permission
        /**
         * The identifier of the user, group, or resource to which the permissions are
         * granted.
         */
        fun granteeId(granteeId: String): FluentBuilder
        /**
         * The type of user, group, or resource referred to in GranteeId.
         */
        fun granteeType(granteeType: MemberType): FluentBuilder
        /**
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as
         * the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF
         * allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not
         * mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full
         * access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         */
        fun permissionValues(permissionValues: List<PermissionType>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier of the user, group, or resource to which the permissions are
         * granted.
         */
        var granteeId: String?
        /**
         * The type of user, group, or resource referred to in GranteeId.
         */
        var granteeType: MemberType?
        /**
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as
         * the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF
         * allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not
         * mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full
         * access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         */
        var permissionValues: List<PermissionType>?

        fun build(): Permission
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var granteeId: String? = null
        override var granteeType: MemberType? = null
        override var permissionValues: List<PermissionType>? = null

        constructor(x: Permission) : this() {
            this.granteeId = x.granteeId
            this.granteeType = x.granteeType
            this.permissionValues = x.permissionValues
        }

        override fun build(): Permission = Permission(this)
        override fun granteeId(granteeId: String): FluentBuilder = apply { this.granteeId = granteeId }
        override fun granteeType(granteeType: MemberType): FluentBuilder = apply { this.granteeType = granteeType }
        override fun permissionValues(permissionValues: List<PermissionType>): FluentBuilder = apply { this.permissionValues = permissionValues }
    }
}
