// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A rule that controls access to mobile devices for an Amazon WorkMail group.
 */
class MobileDeviceAccessRule private constructor(builder: BuilderImpl) {
    /**
     * The date and time at which an access rule was created.
     */
    val dateCreated: Instant? = builder.dateCreated
    /**
     * The date and time at which an access rule was modified.
     */
    val dateModified: Instant? = builder.dateModified
    /**
     * The description of a mobile access rule.
     */
    val description: String? = builder.description
    /**
     * Device models that a rule will match.
     */
    val deviceModels: List<String>? = builder.deviceModels
    /**
     * Device operating systems that a rule will match.
     */
    val deviceOperatingSystems: List<String>? = builder.deviceOperatingSystems
    /**
     * Device types that a rule will match.
     */
    val deviceTypes: List<String>? = builder.deviceTypes
    /**
     * Device user agents that a rule will match.
     */
    val deviceUserAgents: List<String>? = builder.deviceUserAgents
    /**
     * The effect of the rule when it matches. Allowed values are ALLOW or DENY.
     */
    val effect: MobileDeviceAccessRuleEffect? = builder.effect
    /**
     * The ID assigned to a mobile access rule.
     */
    val mobileDeviceAccessRuleId: String? = builder.mobileDeviceAccessRuleId
    /**
     * The name of a mobile access rule.
     */
    val name: String? = builder.name
    /**
     * Device models that a rule will not match. All other device models will match.
     */
    val notDeviceModels: List<String>? = builder.notDeviceModels
    /**
     * Device operating systems that a rule will not match. All other device types will match.
     */
    val notDeviceOperatingSystems: List<String>? = builder.notDeviceOperatingSystems
    /**
     * Device types that a rule will not match. All other device types will match.
     */
    val notDeviceTypes: List<String>? = builder.notDeviceTypes
    /**
     * Device user agents that a rule will not match. All other device user agents will match.
     */
    val notDeviceUserAgents: List<String>? = builder.notDeviceUserAgents

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MobileDeviceAccessRule = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MobileDeviceAccessRule(")
        append("dateCreated=$dateCreated,")
        append("dateModified=$dateModified,")
        append("description=$description,")
        append("deviceModels=$deviceModels,")
        append("deviceOperatingSystems=$deviceOperatingSystems,")
        append("deviceTypes=$deviceTypes,")
        append("deviceUserAgents=$deviceUserAgents,")
        append("effect=$effect,")
        append("mobileDeviceAccessRuleId=$mobileDeviceAccessRuleId,")
        append("name=$name,")
        append("notDeviceModels=$notDeviceModels,")
        append("notDeviceOperatingSystems=$notDeviceOperatingSystems,")
        append("notDeviceTypes=$notDeviceTypes,")
        append("notDeviceUserAgents=$notDeviceUserAgents)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dateCreated?.hashCode() ?: 0
        result = 31 * result + (dateModified?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (deviceModels?.hashCode() ?: 0)
        result = 31 * result + (deviceOperatingSystems?.hashCode() ?: 0)
        result = 31 * result + (deviceTypes?.hashCode() ?: 0)
        result = 31 * result + (deviceUserAgents?.hashCode() ?: 0)
        result = 31 * result + (effect?.hashCode() ?: 0)
        result = 31 * result + (mobileDeviceAccessRuleId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notDeviceModels?.hashCode() ?: 0)
        result = 31 * result + (notDeviceOperatingSystems?.hashCode() ?: 0)
        result = 31 * result + (notDeviceTypes?.hashCode() ?: 0)
        result = 31 * result + (notDeviceUserAgents?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MobileDeviceAccessRule

        if (dateCreated != other.dateCreated) return false
        if (dateModified != other.dateModified) return false
        if (description != other.description) return false
        if (deviceModels != other.deviceModels) return false
        if (deviceOperatingSystems != other.deviceOperatingSystems) return false
        if (deviceTypes != other.deviceTypes) return false
        if (deviceUserAgents != other.deviceUserAgents) return false
        if (effect != other.effect) return false
        if (mobileDeviceAccessRuleId != other.mobileDeviceAccessRuleId) return false
        if (name != other.name) return false
        if (notDeviceModels != other.notDeviceModels) return false
        if (notDeviceOperatingSystems != other.notDeviceOperatingSystems) return false
        if (notDeviceTypes != other.notDeviceTypes) return false
        if (notDeviceUserAgents != other.notDeviceUserAgents) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MobileDeviceAccessRule = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MobileDeviceAccessRule
        /**
         * The date and time at which an access rule was created.
         */
        fun dateCreated(dateCreated: Instant): FluentBuilder
        /**
         * The date and time at which an access rule was modified.
         */
        fun dateModified(dateModified: Instant): FluentBuilder
        /**
         * The description of a mobile access rule.
         */
        fun description(description: String): FluentBuilder
        /**
         * Device models that a rule will match.
         */
        fun deviceModels(deviceModels: List<String>): FluentBuilder
        /**
         * Device operating systems that a rule will match.
         */
        fun deviceOperatingSystems(deviceOperatingSystems: List<String>): FluentBuilder
        /**
         * Device types that a rule will match.
         */
        fun deviceTypes(deviceTypes: List<String>): FluentBuilder
        /**
         * Device user agents that a rule will match.
         */
        fun deviceUserAgents(deviceUserAgents: List<String>): FluentBuilder
        /**
         * The effect of the rule when it matches. Allowed values are ALLOW or DENY.
         */
        fun effect(effect: MobileDeviceAccessRuleEffect): FluentBuilder
        /**
         * The ID assigned to a mobile access rule.
         */
        fun mobileDeviceAccessRuleId(mobileDeviceAccessRuleId: String): FluentBuilder
        /**
         * The name of a mobile access rule.
         */
        fun name(name: String): FluentBuilder
        /**
         * Device models that a rule will not match. All other device models will match.
         */
        fun notDeviceModels(notDeviceModels: List<String>): FluentBuilder
        /**
         * Device operating systems that a rule will not match. All other device types will match.
         */
        fun notDeviceOperatingSystems(notDeviceOperatingSystems: List<String>): FluentBuilder
        /**
         * Device types that a rule will not match. All other device types will match.
         */
        fun notDeviceTypes(notDeviceTypes: List<String>): FluentBuilder
        /**
         * Device user agents that a rule will not match. All other device user agents will match.
         */
        fun notDeviceUserAgents(notDeviceUserAgents: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date and time at which an access rule was created.
         */
        var dateCreated: Instant?
        /**
         * The date and time at which an access rule was modified.
         */
        var dateModified: Instant?
        /**
         * The description of a mobile access rule.
         */
        var description: String?
        /**
         * Device models that a rule will match.
         */
        var deviceModels: List<String>?
        /**
         * Device operating systems that a rule will match.
         */
        var deviceOperatingSystems: List<String>?
        /**
         * Device types that a rule will match.
         */
        var deviceTypes: List<String>?
        /**
         * Device user agents that a rule will match.
         */
        var deviceUserAgents: List<String>?
        /**
         * The effect of the rule when it matches. Allowed values are ALLOW or DENY.
         */
        var effect: MobileDeviceAccessRuleEffect?
        /**
         * The ID assigned to a mobile access rule.
         */
        var mobileDeviceAccessRuleId: String?
        /**
         * The name of a mobile access rule.
         */
        var name: String?
        /**
         * Device models that a rule will not match. All other device models will match.
         */
        var notDeviceModels: List<String>?
        /**
         * Device operating systems that a rule will not match. All other device types will match.
         */
        var notDeviceOperatingSystems: List<String>?
        /**
         * Device types that a rule will not match. All other device types will match.
         */
        var notDeviceTypes: List<String>?
        /**
         * Device user agents that a rule will not match. All other device user agents will match.
         */
        var notDeviceUserAgents: List<String>?

        fun build(): MobileDeviceAccessRule
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dateCreated: Instant? = null
        override var dateModified: Instant? = null
        override var description: String? = null
        override var deviceModels: List<String>? = null
        override var deviceOperatingSystems: List<String>? = null
        override var deviceTypes: List<String>? = null
        override var deviceUserAgents: List<String>? = null
        override var effect: MobileDeviceAccessRuleEffect? = null
        override var mobileDeviceAccessRuleId: String? = null
        override var name: String? = null
        override var notDeviceModels: List<String>? = null
        override var notDeviceOperatingSystems: List<String>? = null
        override var notDeviceTypes: List<String>? = null
        override var notDeviceUserAgents: List<String>? = null

        constructor(x: MobileDeviceAccessRule) : this() {
            this.dateCreated = x.dateCreated
            this.dateModified = x.dateModified
            this.description = x.description
            this.deviceModels = x.deviceModels
            this.deviceOperatingSystems = x.deviceOperatingSystems
            this.deviceTypes = x.deviceTypes
            this.deviceUserAgents = x.deviceUserAgents
            this.effect = x.effect
            this.mobileDeviceAccessRuleId = x.mobileDeviceAccessRuleId
            this.name = x.name
            this.notDeviceModels = x.notDeviceModels
            this.notDeviceOperatingSystems = x.notDeviceOperatingSystems
            this.notDeviceTypes = x.notDeviceTypes
            this.notDeviceUserAgents = x.notDeviceUserAgents
        }

        override fun build(): MobileDeviceAccessRule = MobileDeviceAccessRule(this)
        override fun dateCreated(dateCreated: Instant): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun dateModified(dateModified: Instant): FluentBuilder = apply { this.dateModified = dateModified }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun deviceModels(deviceModels: List<String>): FluentBuilder = apply { this.deviceModels = deviceModels }
        override fun deviceOperatingSystems(deviceOperatingSystems: List<String>): FluentBuilder = apply { this.deviceOperatingSystems = deviceOperatingSystems }
        override fun deviceTypes(deviceTypes: List<String>): FluentBuilder = apply { this.deviceTypes = deviceTypes }
        override fun deviceUserAgents(deviceUserAgents: List<String>): FluentBuilder = apply { this.deviceUserAgents = deviceUserAgents }
        override fun effect(effect: MobileDeviceAccessRuleEffect): FluentBuilder = apply { this.effect = effect }
        override fun mobileDeviceAccessRuleId(mobileDeviceAccessRuleId: String): FluentBuilder = apply { this.mobileDeviceAccessRuleId = mobileDeviceAccessRuleId }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun notDeviceModels(notDeviceModels: List<String>): FluentBuilder = apply { this.notDeviceModels = notDeviceModels }
        override fun notDeviceOperatingSystems(notDeviceOperatingSystems: List<String>): FluentBuilder = apply { this.notDeviceOperatingSystems = notDeviceOperatingSystems }
        override fun notDeviceTypes(notDeviceTypes: List<String>): FluentBuilder = apply { this.notDeviceTypes = notDeviceTypes }
        override fun notDeviceUserAgents(notDeviceUserAgents: List<String>): FluentBuilder = apply { this.notDeviceUserAgents = notDeviceUserAgents }
    }
}
