// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The representation of a user or group.
 */
class Member private constructor(builder: BuilderImpl) {
    /**
     * The date indicating when the member was disabled from Amazon WorkMail use.
     */
    val disabledDate: Instant? = builder.disabledDate
    /**
     * The date indicating when the member was enabled for Amazon WorkMail use.
     */
    val enabledDate: Instant? = builder.enabledDate
    /**
     * The identifier of the member.
     */
    val id: String? = builder.id
    /**
     * The name of the member.
     */
    val name: String? = builder.name
    /**
     * The state of the member, which can be ENABLED, DISABLED, or DELETED.
     */
    val state: EntityState? = builder.state
    /**
     * A member can be a user or group.
     */
    val type: MemberType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Member = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Member(")
        append("disabledDate=$disabledDate,")
        append("enabledDate=$enabledDate,")
        append("id=$id,")
        append("name=$name,")
        append("state=$state,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = disabledDate?.hashCode() ?: 0
        result = 31 * result + (enabledDate?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Member

        if (disabledDate != other.disabledDate) return false
        if (enabledDate != other.enabledDate) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (state != other.state) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Member = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Member
        /**
         * The date indicating when the member was disabled from Amazon WorkMail use.
         */
        fun disabledDate(disabledDate: Instant): FluentBuilder
        /**
         * The date indicating when the member was enabled for Amazon WorkMail use.
         */
        fun enabledDate(enabledDate: Instant): FluentBuilder
        /**
         * The identifier of the member.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name of the member.
         */
        fun name(name: String): FluentBuilder
        /**
         * The state of the member, which can be ENABLED, DISABLED, or DELETED.
         */
        fun state(state: EntityState): FluentBuilder
        /**
         * A member can be a user or group.
         */
        fun type(type: MemberType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date indicating when the member was disabled from Amazon WorkMail use.
         */
        var disabledDate: Instant?
        /**
         * The date indicating when the member was enabled for Amazon WorkMail use.
         */
        var enabledDate: Instant?
        /**
         * The identifier of the member.
         */
        var id: String?
        /**
         * The name of the member.
         */
        var name: String?
        /**
         * The state of the member, which can be ENABLED, DISABLED, or DELETED.
         */
        var state: EntityState?
        /**
         * A member can be a user or group.
         */
        var type: MemberType?

        fun build(): Member
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var disabledDate: Instant? = null
        override var enabledDate: Instant? = null
        override var id: String? = null
        override var name: String? = null
        override var state: EntityState? = null
        override var type: MemberType? = null

        constructor(x: Member) : this() {
            this.disabledDate = x.disabledDate
            this.enabledDate = x.enabledDate
            this.id = x.id
            this.name = x.name
            this.state = x.state
            this.type = x.type
        }

        override fun build(): Member = Member(this)
        override fun disabledDate(disabledDate: Instant): FluentBuilder = apply { this.disabledDate = disabledDate }
        override fun enabledDate(enabledDate: Instant): FluentBuilder = apply { this.enabledDate = enabledDate }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun state(state: EntityState): FluentBuilder = apply { this.state = state }
        override fun type(type: MemberType): FluentBuilder = apply { this.type = type }
    }
}
