// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a mailbox export job, including the user or resource ID associated
 * with the mailbox and the S3 bucket that the mailbox contents are exported to.
 */
class MailboxExportJob private constructor(builder: BuilderImpl) {
    /**
     * The mailbox export job description.
     */
    val description: String? = builder.description
    /**
     * The mailbox export job end timestamp.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The identifier of the user or resource associated with the mailbox.
     */
    val entityId: String? = builder.entityId
    /**
     * The estimated progress of the mailbox export job, in percentage points.
     */
    val estimatedProgress: Int = builder.estimatedProgress
    /**
     * The identifier of the mailbox export job.
     */
    val jobId: String? = builder.jobId
    /**
     * The name of the S3 bucket.
     */
    val s3BucketName: String? = builder.s3BucketName
    /**
     * The path to the S3 bucket and file that the mailbox export job exports to.
     */
    val s3Path: String? = builder.s3Path
    /**
     * The mailbox export job start timestamp.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The state of the mailbox export job.
     */
    val state: MailboxExportJobState? = builder.state

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MailboxExportJob = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MailboxExportJob(")
        append("description=$description,")
        append("endTime=$endTime,")
        append("entityId=$entityId,")
        append("estimatedProgress=$estimatedProgress,")
        append("jobId=$jobId,")
        append("s3BucketName=$s3BucketName,")
        append("s3Path=$s3Path,")
        append("startTime=$startTime,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (entityId?.hashCode() ?: 0)
        result = 31 * result + (estimatedProgress)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3Path?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MailboxExportJob

        if (description != other.description) return false
        if (endTime != other.endTime) return false
        if (entityId != other.entityId) return false
        if (estimatedProgress != other.estimatedProgress) return false
        if (jobId != other.jobId) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3Path != other.s3Path) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MailboxExportJob = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MailboxExportJob
        /**
         * The mailbox export job description.
         */
        fun description(description: String): FluentBuilder
        /**
         * The mailbox export job end timestamp.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The identifier of the user or resource associated with the mailbox.
         */
        fun entityId(entityId: String): FluentBuilder
        /**
         * The estimated progress of the mailbox export job, in percentage points.
         */
        fun estimatedProgress(estimatedProgress: Int): FluentBuilder
        /**
         * The identifier of the mailbox export job.
         */
        fun jobId(jobId: String): FluentBuilder
        /**
         * The name of the S3 bucket.
         */
        fun s3BucketName(s3BucketName: String): FluentBuilder
        /**
         * The path to the S3 bucket and file that the mailbox export job exports to.
         */
        fun s3Path(s3Path: String): FluentBuilder
        /**
         * The mailbox export job start timestamp.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The state of the mailbox export job.
         */
        fun state(state: MailboxExportJobState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The mailbox export job description.
         */
        var description: String?
        /**
         * The mailbox export job end timestamp.
         */
        var endTime: Instant?
        /**
         * The identifier of the user or resource associated with the mailbox.
         */
        var entityId: String?
        /**
         * The estimated progress of the mailbox export job, in percentage points.
         */
        var estimatedProgress: Int
        /**
         * The identifier of the mailbox export job.
         */
        var jobId: String?
        /**
         * The name of the S3 bucket.
         */
        var s3BucketName: String?
        /**
         * The path to the S3 bucket and file that the mailbox export job exports to.
         */
        var s3Path: String?
        /**
         * The mailbox export job start timestamp.
         */
        var startTime: Instant?
        /**
         * The state of the mailbox export job.
         */
        var state: MailboxExportJobState?

        fun build(): MailboxExportJob
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var endTime: Instant? = null
        override var entityId: String? = null
        override var estimatedProgress: Int = 0
        override var jobId: String? = null
        override var s3BucketName: String? = null
        override var s3Path: String? = null
        override var startTime: Instant? = null
        override var state: MailboxExportJobState? = null

        constructor(x: MailboxExportJob) : this() {
            this.description = x.description
            this.endTime = x.endTime
            this.entityId = x.entityId
            this.estimatedProgress = x.estimatedProgress
            this.jobId = x.jobId
            this.s3BucketName = x.s3BucketName
            this.s3Path = x.s3Path
            this.startTime = x.startTime
            this.state = x.state
        }

        override fun build(): MailboxExportJob = MailboxExportJob(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun entityId(entityId: String): FluentBuilder = apply { this.entityId = entityId }
        override fun estimatedProgress(estimatedProgress: Int): FluentBuilder = apply { this.estimatedProgress = estimatedProgress }
        override fun jobId(jobId: String): FluentBuilder = apply { this.jobId = jobId }
        override fun s3BucketName(s3BucketName: String): FluentBuilder = apply { this.s3BucketName = s3BucketName }
        override fun s3Path(s3Path: String): FluentBuilder = apply { this.s3Path = s3Path }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun state(state: MailboxExportJobState): FluentBuilder = apply { this.state = state }
    }
}
