// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model



class ListMobileDeviceAccessOverridesRequest private constructor(builder: BuilderImpl) {
    /**
     * The mobile device to which the access override applies.
     */
    val deviceId: String? = builder.deviceId
    /**
     * The maximum number of results to return in a single call.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to use to retrieve the next page of results. The first call does not require a token.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The Amazon WorkMail organization under which to list mobile device access overrides.
     */
    val organizationId: String? = builder.organizationId
    /**
     * The WorkMail user under which you list the mobile device access overrides. Accepts the following types of user identities:
     * User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     * Email address: user@domain.tld
     * User name: user
     */
    val userId: String? = builder.userId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListMobileDeviceAccessOverridesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListMobileDeviceAccessOverridesRequest(")
        append("deviceId=$deviceId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("organizationId=$organizationId,")
        append("userId=$userId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (organizationId?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListMobileDeviceAccessOverridesRequest

        if (deviceId != other.deviceId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (organizationId != other.organizationId) return false
        if (userId != other.userId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListMobileDeviceAccessOverridesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListMobileDeviceAccessOverridesRequest
        /**
         * The mobile device to which the access override applies.
         */
        fun deviceId(deviceId: String): FluentBuilder
        /**
         * The maximum number of results to return in a single call.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to use to retrieve the next page of results. The first call does not require a token.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The Amazon WorkMail organization under which to list mobile device access overrides.
         */
        fun organizationId(organizationId: String): FluentBuilder
        /**
         * The WorkMail user under which you list the mobile device access overrides. Accepts the following types of user identities:
         * User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
         * Email address: user@domain.tld
         * User name: user
         */
        fun userId(userId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The mobile device to which the access override applies.
         */
        var deviceId: String?
        /**
         * The maximum number of results to return in a single call.
         */
        var maxResults: Int?
        /**
         * The token to use to retrieve the next page of results. The first call does not require a token.
         */
        var nextToken: String?
        /**
         * The Amazon WorkMail organization under which to list mobile device access overrides.
         */
        var organizationId: String?
        /**
         * The WorkMail user under which you list the mobile device access overrides. Accepts the following types of user identities:
         * User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
         * Email address: user@domain.tld
         * User name: user
         */
        var userId: String?

        fun build(): ListMobileDeviceAccessOverridesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deviceId: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var organizationId: String? = null
        override var userId: String? = null

        constructor(x: ListMobileDeviceAccessOverridesRequest) : this() {
            this.deviceId = x.deviceId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.organizationId = x.organizationId
            this.userId = x.userId
        }

        override fun build(): ListMobileDeviceAccessOverridesRequest = ListMobileDeviceAccessOverridesRequest(this)
        override fun deviceId(deviceId: String): FluentBuilder = apply { this.deviceId = deviceId }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun organizationId(organizationId: String): FluentBuilder = apply { this.organizationId = organizationId }
        override fun userId(userId: String): FluentBuilder = apply { this.userId = userId }
    }
}
