// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model



class ListMailboxPermissionsRequest private constructor(builder: BuilderImpl) {
    /**
     * The identifier of the user, group, or resource for which to list mailbox
     * permissions.
     */
    val entityId: String? = builder.entityId
    /**
     * The maximum number of results to return in a single call.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to use to retrieve the next page of results. The first call does not
     * contain any tokens.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The identifier of the organization under which the user, group, or resource
     * exists.
     */
    val organizationId: String? = builder.organizationId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListMailboxPermissionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListMailboxPermissionsRequest(")
        append("entityId=$entityId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("organizationId=$organizationId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = entityId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (organizationId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListMailboxPermissionsRequest

        if (entityId != other.entityId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (organizationId != other.organizationId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListMailboxPermissionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListMailboxPermissionsRequest
        /**
         * The identifier of the user, group, or resource for which to list mailbox
         * permissions.
         */
        fun entityId(entityId: String): FluentBuilder
        /**
         * The maximum number of results to return in a single call.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to use to retrieve the next page of results. The first call does not
         * contain any tokens.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The identifier of the organization under which the user, group, or resource
         * exists.
         */
        fun organizationId(organizationId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier of the user, group, or resource for which to list mailbox
         * permissions.
         */
        var entityId: String?
        /**
         * The maximum number of results to return in a single call.
         */
        var maxResults: Int?
        /**
         * The token to use to retrieve the next page of results. The first call does not
         * contain any tokens.
         */
        var nextToken: String?
        /**
         * The identifier of the organization under which the user, group, or resource
         * exists.
         */
        var organizationId: String?

        fun build(): ListMailboxPermissionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var entityId: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var organizationId: String? = null

        constructor(x: ListMailboxPermissionsRequest) : this() {
            this.entityId = x.entityId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.organizationId = x.organizationId
        }

        override fun build(): ListMailboxPermissionsRequest = ListMailboxPermissionsRequest(this)
        override fun entityId(entityId: String): FluentBuilder = apply { this.entityId = entityId }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun organizationId(organizationId: String): FluentBuilder = apply { this.organizationId = organizationId }
    }
}
