// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model



class ListGroupMembersRequest private constructor(builder: BuilderImpl) {
    /**
     * The identifier for the group to which the members (users or groups) are
     * associated.
     */
    val groupId: String? = builder.groupId
    /**
     * The maximum number of results to return in a single call.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to use to retrieve the next page of results. The first call does not
     * contain any tokens.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The identifier for the organization under which the group exists.
     */
    val organizationId: String? = builder.organizationId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListGroupMembersRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListGroupMembersRequest(")
        append("groupId=$groupId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("organizationId=$organizationId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (organizationId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListGroupMembersRequest

        if (groupId != other.groupId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (organizationId != other.organizationId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListGroupMembersRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListGroupMembersRequest
        /**
         * The identifier for the group to which the members (users or groups) are
         * associated.
         */
        fun groupId(groupId: String): FluentBuilder
        /**
         * The maximum number of results to return in a single call.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to use to retrieve the next page of results. The first call does not
         * contain any tokens.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The identifier for the organization under which the group exists.
         */
        fun organizationId(organizationId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier for the group to which the members (users or groups) are
         * associated.
         */
        var groupId: String?
        /**
         * The maximum number of results to return in a single call.
         */
        var maxResults: Int?
        /**
         * The token to use to retrieve the next page of results. The first call does not
         * contain any tokens.
         */
        var nextToken: String?
        /**
         * The identifier for the organization under which the group exists.
         */
        var organizationId: String?

        fun build(): ListGroupMembersRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var groupId: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var organizationId: String? = null

        constructor(x: ListGroupMembersRequest) : this() {
            this.groupId = x.groupId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.organizationId = x.organizationId
        }

        override fun build(): ListGroupMembersRequest = ListGroupMembersRequest(this)
        override fun groupId(groupId: String): FluentBuilder = apply { this.groupId = groupId }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun organizationId(organizationId: String): FluentBuilder = apply { this.organizationId = organizationId }
    }
}
