// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model



/**
 * The domain to associate with an Amazon WorkMail organization.
 * When you configure a domain hosted in Amazon Route 53 (Route 53), all recommended DNS records are added to the organization when you create it. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a domain in the Amazon WorkMail Administrator Guide.
 */
class Domain private constructor(builder: BuilderImpl) {
    /**
     * The fully qualified domain name.
     */
    val domainName: String? = builder.domainName
    /**
     * The hosted zone ID for a domain hosted in Route 53. Required when configuring a domain hosted in Route 53.
     */
    val hostedZoneId: String? = builder.hostedZoneId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Domain = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Domain(")
        append("domainName=$domainName,")
        append("hostedZoneId=$hostedZoneId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Domain

        if (domainName != other.domainName) return false
        if (hostedZoneId != other.hostedZoneId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Domain = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Domain
        /**
         * The fully qualified domain name.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * The hosted zone ID for a domain hosted in Route 53. Required when configuring a domain hosted in Route 53.
         */
        fun hostedZoneId(hostedZoneId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The fully qualified domain name.
         */
        var domainName: String?
        /**
         * The hosted zone ID for a domain hosted in Route 53. Required when configuring a domain hosted in Route 53.
         */
        var hostedZoneId: String?

        fun build(): Domain
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var domainName: String? = null
        override var hostedZoneId: String? = null

        constructor(x: Domain) : this() {
            this.domainName = x.domainName
            this.hostedZoneId = x.hostedZoneId
        }

        override fun build(): Domain = Domain(this)
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun hostedZoneId(hostedZoneId: String): FluentBuilder = apply { this.hostedZoneId = hostedZoneId }
    }
}
