// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeMailboxExportJobResponse private constructor(builder: BuilderImpl) {
    /**
     * The mailbox export job description.
     */
    val description: String? = builder.description
    /**
     * The mailbox export job end timestamp.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The identifier of the user or resource associated with the mailbox.
     */
    val entityId: String? = builder.entityId
    /**
     * Error information for failed mailbox export jobs.
     */
    val errorInfo: String? = builder.errorInfo
    /**
     * The estimated progress of the mailbox export job, in percentage points.
     */
    val estimatedProgress: Int = builder.estimatedProgress
    /**
     * The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS)
     * key that encrypts the exported mailbox content.
     */
    val kmsKeyArn: String? = builder.kmsKeyArn
    /**
     * The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the Amazon Simple
     * Storage Service (Amazon S3) bucket.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The name of the S3 bucket.
     */
    val s3BucketName: String? = builder.s3BucketName
    /**
     * The path to the S3 bucket and file that the mailbox export job is exporting
     * to.
     */
    val s3Path: String? = builder.s3Path
    /**
     * The S3 bucket prefix.
     */
    val s3Prefix: String? = builder.s3Prefix
    /**
     * The mailbox export job start timestamp.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The state of the mailbox export job.
     */
    val state: MailboxExportJobState? = builder.state

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeMailboxExportJobResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeMailboxExportJobResponse(")
        append("description=$description,")
        append("endTime=$endTime,")
        append("entityId=$entityId,")
        append("errorInfo=$errorInfo,")
        append("estimatedProgress=$estimatedProgress,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("roleArn=$roleArn,")
        append("s3BucketName=$s3BucketName,")
        append("s3Path=$s3Path,")
        append("s3Prefix=$s3Prefix,")
        append("startTime=$startTime,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (entityId?.hashCode() ?: 0)
        result = 31 * result + (errorInfo?.hashCode() ?: 0)
        result = 31 * result + (estimatedProgress)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3Path?.hashCode() ?: 0)
        result = 31 * result + (s3Prefix?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeMailboxExportJobResponse

        if (description != other.description) return false
        if (endTime != other.endTime) return false
        if (entityId != other.entityId) return false
        if (errorInfo != other.errorInfo) return false
        if (estimatedProgress != other.estimatedProgress) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (roleArn != other.roleArn) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3Path != other.s3Path) return false
        if (s3Prefix != other.s3Prefix) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeMailboxExportJobResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeMailboxExportJobResponse
        /**
         * The mailbox export job description.
         */
        fun description(description: String): FluentBuilder
        /**
         * The mailbox export job end timestamp.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The identifier of the user or resource associated with the mailbox.
         */
        fun entityId(entityId: String): FluentBuilder
        /**
         * Error information for failed mailbox export jobs.
         */
        fun errorInfo(errorInfo: String): FluentBuilder
        /**
         * The estimated progress of the mailbox export job, in percentage points.
         */
        fun estimatedProgress(estimatedProgress: Int): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS)
         * key that encrypts the exported mailbox content.
         */
        fun kmsKeyArn(kmsKeyArn: String): FluentBuilder
        /**
         * The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the Amazon Simple
         * Storage Service (Amazon S3) bucket.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The name of the S3 bucket.
         */
        fun s3BucketName(s3BucketName: String): FluentBuilder
        /**
         * The path to the S3 bucket and file that the mailbox export job is exporting
         * to.
         */
        fun s3Path(s3Path: String): FluentBuilder
        /**
         * The S3 bucket prefix.
         */
        fun s3Prefix(s3Prefix: String): FluentBuilder
        /**
         * The mailbox export job start timestamp.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The state of the mailbox export job.
         */
        fun state(state: MailboxExportJobState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The mailbox export job description.
         */
        var description: String?
        /**
         * The mailbox export job end timestamp.
         */
        var endTime: Instant?
        /**
         * The identifier of the user or resource associated with the mailbox.
         */
        var entityId: String?
        /**
         * Error information for failed mailbox export jobs.
         */
        var errorInfo: String?
        /**
         * The estimated progress of the mailbox export job, in percentage points.
         */
        var estimatedProgress: Int
        /**
         * The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS)
         * key that encrypts the exported mailbox content.
         */
        var kmsKeyArn: String?
        /**
         * The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the Amazon Simple
         * Storage Service (Amazon S3) bucket.
         */
        var roleArn: String?
        /**
         * The name of the S3 bucket.
         */
        var s3BucketName: String?
        /**
         * The path to the S3 bucket and file that the mailbox export job is exporting
         * to.
         */
        var s3Path: String?
        /**
         * The S3 bucket prefix.
         */
        var s3Prefix: String?
        /**
         * The mailbox export job start timestamp.
         */
        var startTime: Instant?
        /**
         * The state of the mailbox export job.
         */
        var state: MailboxExportJobState?

        fun build(): DescribeMailboxExportJobResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var endTime: Instant? = null
        override var entityId: String? = null
        override var errorInfo: String? = null
        override var estimatedProgress: Int = 0
        override var kmsKeyArn: String? = null
        override var roleArn: String? = null
        override var s3BucketName: String? = null
        override var s3Path: String? = null
        override var s3Prefix: String? = null
        override var startTime: Instant? = null
        override var state: MailboxExportJobState? = null

        constructor(x: DescribeMailboxExportJobResponse) : this() {
            this.description = x.description
            this.endTime = x.endTime
            this.entityId = x.entityId
            this.errorInfo = x.errorInfo
            this.estimatedProgress = x.estimatedProgress
            this.kmsKeyArn = x.kmsKeyArn
            this.roleArn = x.roleArn
            this.s3BucketName = x.s3BucketName
            this.s3Path = x.s3Path
            this.s3Prefix = x.s3Prefix
            this.startTime = x.startTime
            this.state = x.state
        }

        override fun build(): DescribeMailboxExportJobResponse = DescribeMailboxExportJobResponse(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun entityId(entityId: String): FluentBuilder = apply { this.entityId = entityId }
        override fun errorInfo(errorInfo: String): FluentBuilder = apply { this.errorInfo = errorInfo }
        override fun estimatedProgress(estimatedProgress: Int): FluentBuilder = apply { this.estimatedProgress = estimatedProgress }
        override fun kmsKeyArn(kmsKeyArn: String): FluentBuilder = apply { this.kmsKeyArn = kmsKeyArn }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun s3BucketName(s3BucketName: String): FluentBuilder = apply { this.s3BucketName = s3BucketName }
        override fun s3Path(s3Path: String): FluentBuilder = apply { this.s3Path = s3Path }
        override fun s3Prefix(s3Prefix: String): FluentBuilder = apply { this.s3Prefix = s3Prefix }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun state(state: MailboxExportJobState): FluentBuilder = apply { this.state = state }
    }
}
