// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model



class CreateOrganizationRequest private constructor(builder: BuilderImpl) {
    /**
     * The organization alias.
     */
    val alias: String? = builder.alias
    /**
     * The idempotency token associated with the request.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The AWS Directory Service directory ID.
     */
    val directoryId: String? = builder.directoryId
    /**
     * The email domains to associate with the organization.
     */
    val domains: List<Domain>? = builder.domains
    /**
     * When true, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can only be set to true if an AD Connector directory ID is included in the request.
     */
    val enableInteroperability: Boolean = builder.enableInteroperability
    /**
     * The Amazon Resource Name (ARN) of a customer managed master key from AWS
     * KMS.
     */
    val kmsKeyArn: String? = builder.kmsKeyArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateOrganizationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateOrganizationRequest(")
        append("alias=$alias,")
        append("clientToken=$clientToken,")
        append("directoryId=$directoryId,")
        append("domains=$domains,")
        append("enableInteroperability=$enableInteroperability,")
        append("kmsKeyArn=$kmsKeyArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (directoryId?.hashCode() ?: 0)
        result = 31 * result + (domains?.hashCode() ?: 0)
        result = 31 * result + (enableInteroperability.hashCode())
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateOrganizationRequest

        if (alias != other.alias) return false
        if (clientToken != other.clientToken) return false
        if (directoryId != other.directoryId) return false
        if (domains != other.domains) return false
        if (enableInteroperability != other.enableInteroperability) return false
        if (kmsKeyArn != other.kmsKeyArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateOrganizationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateOrganizationRequest
        /**
         * The organization alias.
         */
        fun alias(alias: String): FluentBuilder
        /**
         * The idempotency token associated with the request.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The AWS Directory Service directory ID.
         */
        fun directoryId(directoryId: String): FluentBuilder
        /**
         * The email domains to associate with the organization.
         */
        fun domains(domains: List<Domain>): FluentBuilder
        /**
         * When true, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can only be set to true if an AD Connector directory ID is included in the request.
         */
        fun enableInteroperability(enableInteroperability: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of a customer managed master key from AWS
         * KMS.
         */
        fun kmsKeyArn(kmsKeyArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The organization alias.
         */
        var alias: String?
        /**
         * The idempotency token associated with the request.
         */
        var clientToken: String?
        /**
         * The AWS Directory Service directory ID.
         */
        var directoryId: String?
        /**
         * The email domains to associate with the organization.
         */
        var domains: List<Domain>?
        /**
         * When true, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can only be set to true if an AD Connector directory ID is included in the request.
         */
        var enableInteroperability: Boolean
        /**
         * The Amazon Resource Name (ARN) of a customer managed master key from AWS
         * KMS.
         */
        var kmsKeyArn: String?

        fun build(): CreateOrganizationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alias: String? = null
        override var clientToken: String? = null
        override var directoryId: String? = null
        override var domains: List<Domain>? = null
        override var enableInteroperability: Boolean = false
        override var kmsKeyArn: String? = null

        constructor(x: CreateOrganizationRequest) : this() {
            this.alias = x.alias
            this.clientToken = x.clientToken
            this.directoryId = x.directoryId
            this.domains = x.domains
            this.enableInteroperability = x.enableInteroperability
            this.kmsKeyArn = x.kmsKeyArn
        }

        override fun build(): CreateOrganizationRequest = CreateOrganizationRequest(this)
        override fun alias(alias: String): FluentBuilder = apply { this.alias = alias }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun directoryId(directoryId: String): FluentBuilder = apply { this.directoryId = directoryId }
        override fun domains(domains: List<Domain>): FluentBuilder = apply { this.domains = domains }
        override fun enableInteroperability(enableInteroperability: Boolean): FluentBuilder = apply { this.enableInteroperability = enableInteroperability }
        override fun kmsKeyArn(kmsKeyArn: String): FluentBuilder = apply { this.kmsKeyArn = kmsKeyArn }
    }
}
