// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A rule that controls access to an Amazon WorkMail organization.
 */
class AccessControlRule private constructor(builder: BuilderImpl) {
    /**
     * Access protocol actions to include in the rule. Valid values include
     * ActiveSync, AutoDiscover, EWS, IMAP,
     * SMTP, WindowsOutlook, and WebMail.
     */
    val actions: List<String>? = builder.actions
    /**
     * The date that the rule was created.
     */
    val dateCreated: Instant? = builder.dateCreated
    /**
     * The date that the rule was modified.
     */
    val dateModified: Instant? = builder.dateModified
    /**
     * The rule description.
     */
    val description: String? = builder.description
    /**
     * The rule effect.
     */
    val effect: AccessControlRuleEffect? = builder.effect
    /**
     * IPv4 CIDR ranges to include in the rule.
     */
    val ipRanges: List<String>? = builder.ipRanges
    /**
     * The rule name.
     */
    val name: String? = builder.name
    /**
     * Access protocol actions to exclude from the rule. Valid values include
     * ActiveSync, AutoDiscover, EWS, IMAP,
     * SMTP, WindowsOutlook, and WebMail.
     */
    val notActions: List<String>? = builder.notActions
    /**
     * IPv4 CIDR ranges to exclude from the rule.
     */
    val notIpRanges: List<String>? = builder.notIpRanges
    /**
     * User IDs to exclude from the rule.
     */
    val notUserIds: List<String>? = builder.notUserIds
    /**
     * User IDs to include in the rule.
     */
    val userIds: List<String>? = builder.userIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AccessControlRule = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AccessControlRule(")
        append("actions=$actions,")
        append("dateCreated=$dateCreated,")
        append("dateModified=$dateModified,")
        append("description=$description,")
        append("effect=$effect,")
        append("ipRanges=$ipRanges,")
        append("name=$name,")
        append("notActions=$notActions,")
        append("notIpRanges=$notIpRanges,")
        append("notUserIds=$notUserIds,")
        append("userIds=$userIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateModified?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (effect?.hashCode() ?: 0)
        result = 31 * result + (ipRanges?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notActions?.hashCode() ?: 0)
        result = 31 * result + (notIpRanges?.hashCode() ?: 0)
        result = 31 * result + (notUserIds?.hashCode() ?: 0)
        result = 31 * result + (userIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AccessControlRule

        if (actions != other.actions) return false
        if (dateCreated != other.dateCreated) return false
        if (dateModified != other.dateModified) return false
        if (description != other.description) return false
        if (effect != other.effect) return false
        if (ipRanges != other.ipRanges) return false
        if (name != other.name) return false
        if (notActions != other.notActions) return false
        if (notIpRanges != other.notIpRanges) return false
        if (notUserIds != other.notUserIds) return false
        if (userIds != other.userIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AccessControlRule = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AccessControlRule
        /**
         * Access protocol actions to include in the rule. Valid values include
         * ActiveSync, AutoDiscover, EWS, IMAP,
         * SMTP, WindowsOutlook, and WebMail.
         */
        fun actions(actions: List<String>): FluentBuilder
        /**
         * The date that the rule was created.
         */
        fun dateCreated(dateCreated: Instant): FluentBuilder
        /**
         * The date that the rule was modified.
         */
        fun dateModified(dateModified: Instant): FluentBuilder
        /**
         * The rule description.
         */
        fun description(description: String): FluentBuilder
        /**
         * The rule effect.
         */
        fun effect(effect: AccessControlRuleEffect): FluentBuilder
        /**
         * IPv4 CIDR ranges to include in the rule.
         */
        fun ipRanges(ipRanges: List<String>): FluentBuilder
        /**
         * The rule name.
         */
        fun name(name: String): FluentBuilder
        /**
         * Access protocol actions to exclude from the rule. Valid values include
         * ActiveSync, AutoDiscover, EWS, IMAP,
         * SMTP, WindowsOutlook, and WebMail.
         */
        fun notActions(notActions: List<String>): FluentBuilder
        /**
         * IPv4 CIDR ranges to exclude from the rule.
         */
        fun notIpRanges(notIpRanges: List<String>): FluentBuilder
        /**
         * User IDs to exclude from the rule.
         */
        fun notUserIds(notUserIds: List<String>): FluentBuilder
        /**
         * User IDs to include in the rule.
         */
        fun userIds(userIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Access protocol actions to include in the rule. Valid values include
         * ActiveSync, AutoDiscover, EWS, IMAP,
         * SMTP, WindowsOutlook, and WebMail.
         */
        var actions: List<String>?
        /**
         * The date that the rule was created.
         */
        var dateCreated: Instant?
        /**
         * The date that the rule was modified.
         */
        var dateModified: Instant?
        /**
         * The rule description.
         */
        var description: String?
        /**
         * The rule effect.
         */
        var effect: AccessControlRuleEffect?
        /**
         * IPv4 CIDR ranges to include in the rule.
         */
        var ipRanges: List<String>?
        /**
         * The rule name.
         */
        var name: String?
        /**
         * Access protocol actions to exclude from the rule. Valid values include
         * ActiveSync, AutoDiscover, EWS, IMAP,
         * SMTP, WindowsOutlook, and WebMail.
         */
        var notActions: List<String>?
        /**
         * IPv4 CIDR ranges to exclude from the rule.
         */
        var notIpRanges: List<String>?
        /**
         * User IDs to exclude from the rule.
         */
        var notUserIds: List<String>?
        /**
         * User IDs to include in the rule.
         */
        var userIds: List<String>?

        fun build(): AccessControlRule
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actions: List<String>? = null
        override var dateCreated: Instant? = null
        override var dateModified: Instant? = null
        override var description: String? = null
        override var effect: AccessControlRuleEffect? = null
        override var ipRanges: List<String>? = null
        override var name: String? = null
        override var notActions: List<String>? = null
        override var notIpRanges: List<String>? = null
        override var notUserIds: List<String>? = null
        override var userIds: List<String>? = null

        constructor(x: AccessControlRule) : this() {
            this.actions = x.actions
            this.dateCreated = x.dateCreated
            this.dateModified = x.dateModified
            this.description = x.description
            this.effect = x.effect
            this.ipRanges = x.ipRanges
            this.name = x.name
            this.notActions = x.notActions
            this.notIpRanges = x.notIpRanges
            this.notUserIds = x.notUserIds
            this.userIds = x.userIds
        }

        override fun build(): AccessControlRule = AccessControlRule(this)
        override fun actions(actions: List<String>): FluentBuilder = apply { this.actions = actions }
        override fun dateCreated(dateCreated: Instant): FluentBuilder = apply { this.dateCreated = dateCreated }
        override fun dateModified(dateModified: Instant): FluentBuilder = apply { this.dateModified = dateModified }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun effect(effect: AccessControlRuleEffect): FluentBuilder = apply { this.effect = effect }
        override fun ipRanges(ipRanges: List<String>): FluentBuilder = apply { this.ipRanges = ipRanges }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun notActions(notActions: List<String>): FluentBuilder = apply { this.notActions = notActions }
        override fun notIpRanges(notIpRanges: List<String>): FluentBuilder = apply { this.notIpRanges = notIpRanges }
        override fun notUserIds(notUserIds: List<String>): FluentBuilder = apply { this.notUserIds = notUserIds }
        override fun userIds(userIds: List<String>): FluentBuilder = apply { this.userIds = userIds }
    }
}
