// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.workmail.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.workmail.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * Amazon WorkMail is a secure, managed business email and calendaring service with support for
 * existing desktop and mobile email clients. You can access your email, contacts, and
 * calendars using Microsoft Outlook, your browser, or other native iOS and Android email
 * applications. You can integrate WorkMail with your existing corporate directory and control
 * both the keys that encrypt your data and the location in which your data is
 * stored.
 * The WorkMail API is designed for the following scenarios:
 * Listing and describing organizations
 * Managing users
 * Managing groups
 * Managing resources
 * All WorkMail API operations are Amazon-authenticated and certificate-signed. They not
 * only require the use of the AWS SDK, but also allow for the exclusive use of AWS Identity and Access Management
 * users and roles to help facilitate access, trust, and permission policies. By creating a
 * role and allowing an IAM user to access the WorkMail site, the IAM user gains full
 * administrative visibility into the entire WorkMail organization (or as set in the IAM
 * policy). This includes, but is not limited to, the ability to create, update, and delete
 * users, groups, and resources. This allows developers to perform the scenarios listed above,
 * as well as give users the ability to grant access on a selective basis using the IAM
 * model.
 */
interface WorkMailClient : SdkClient {

    override val serviceName: String
        get() = "WorkMail"
    /**
     * WorkMailClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): WorkMailClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultWorkMailClient(config)
        }

        operator fun invoke(config: Config): WorkMailClient = DefaultWorkMailClient(config)

        /**
         * Construct a [WorkMailClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): WorkMailClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return WorkMailClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Adds a member (user or group) to the resource's set of delegates.
     */
    suspend fun associateDelegateToResource(input: AssociateDelegateToResourceRequest): AssociateDelegateToResourceResponse

    /**
     * Adds a member (user or group) to the resource's set of delegates.
     */
    suspend fun associateDelegateToResource(block: AssociateDelegateToResourceRequest.DslBuilder.() -> Unit) = associateDelegateToResource(AssociateDelegateToResourceRequest.builder().apply(block).build())

    /**
     * Adds a member (user or group) to the group's set.
     */
    suspend fun associateMemberToGroup(input: AssociateMemberToGroupRequest): AssociateMemberToGroupResponse

    /**
     * Adds a member (user or group) to the group's set.
     */
    suspend fun associateMemberToGroup(block: AssociateMemberToGroupRequest.DslBuilder.() -> Unit) = associateMemberToGroup(AssociateMemberToGroupRequest.builder().apply(block).build())

    /**
     * Cancels a mailbox export job.
     * If the mailbox export job is near completion, it might not be possible to cancel
     * it.
     */
    suspend fun cancelMailboxExportJob(input: CancelMailboxExportJobRequest): CancelMailboxExportJobResponse

    /**
     * Cancels a mailbox export job.
     * If the mailbox export job is near completion, it might not be possible to cancel
     * it.
     */
    suspend fun cancelMailboxExportJob(block: CancelMailboxExportJobRequest.DslBuilder.() -> Unit) = cancelMailboxExportJob(CancelMailboxExportJobRequest.builder().apply(block).build())

    /**
     * Adds an alias to the set of a given member (user or group) of Amazon WorkMail.
     */
    suspend fun createAlias(input: CreateAliasRequest): CreateAliasResponse

    /**
     * Adds an alias to the set of a given member (user or group) of Amazon WorkMail.
     */
    suspend fun createAlias(block: CreateAliasRequest.DslBuilder.() -> Unit) = createAlias(CreateAliasRequest.builder().apply(block).build())

    /**
     * Creates a group that can be used in Amazon WorkMail by calling the RegisterToWorkMail operation.
     */
    suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Creates a group that can be used in Amazon WorkMail by calling the RegisterToWorkMail operation.
     */
    suspend fun createGroup(block: CreateGroupRequest.DslBuilder.() -> Unit) = createGroup(CreateGroupRequest.builder().apply(block).build())

    /**
     * Creates a new mobile device access rule for the specified Amazon WorkMail organization.
     */
    suspend fun createMobileDeviceAccessRule(input: CreateMobileDeviceAccessRuleRequest): CreateMobileDeviceAccessRuleResponse

    /**
     * Creates a new mobile device access rule for the specified Amazon WorkMail organization.
     */
    suspend fun createMobileDeviceAccessRule(block: CreateMobileDeviceAccessRuleRequest.DslBuilder.() -> Unit) = createMobileDeviceAccessRule(CreateMobileDeviceAccessRuleRequest.builder().apply(block).build())

    /**
     * Creates a new Amazon WorkMail organization. Optionally, you can choose to associate an existing AWS Directory Service directory with your organization. If an AWS Directory Service directory ID is specified, the organization alias must match the directory alias. If you choose not to associate an existing directory with your organization, then we create a new Amazon WorkMail directory for you. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html">Adding an organization in the Amazon WorkMail Administrator Guide.
     * You can associate multiple email domains with an organization, then set your default email domain from the Amazon WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a domain and <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html">Choosing the default domain in the Amazon WorkMail Administrator Guide.
     * Optionally, you can use a customer managed master key from AWS Key Management Service
     * (AWS KMS) to encrypt email for your organization. If you don't associate an AWS KMS key, Amazon WorkMail creates a
     * default AWS managed master key for you.
     */
    suspend fun createOrganization(input: CreateOrganizationRequest): CreateOrganizationResponse

    /**
     * Creates a new Amazon WorkMail organization. Optionally, you can choose to associate an existing AWS Directory Service directory with your organization. If an AWS Directory Service directory ID is specified, the organization alias must match the directory alias. If you choose not to associate an existing directory with your organization, then we create a new Amazon WorkMail directory for you. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html">Adding an organization in the Amazon WorkMail Administrator Guide.
     * You can associate multiple email domains with an organization, then set your default email domain from the Amazon WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a domain and <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html">Choosing the default domain in the Amazon WorkMail Administrator Guide.
     * Optionally, you can use a customer managed master key from AWS Key Management Service
     * (AWS KMS) to encrypt email for your organization. If you don't associate an AWS KMS key, Amazon WorkMail creates a
     * default AWS managed master key for you.
     */
    suspend fun createOrganization(block: CreateOrganizationRequest.DslBuilder.() -> Unit) = createOrganization(CreateOrganizationRequest.builder().apply(block).build())

    /**
     * Creates a new Amazon WorkMail resource.
     */
    suspend fun createResource(input: CreateResourceRequest): CreateResourceResponse

    /**
     * Creates a new Amazon WorkMail resource.
     */
    suspend fun createResource(block: CreateResourceRequest.DslBuilder.() -> Unit) = createResource(CreateResourceRequest.builder().apply(block).build())

    /**
     * Creates a user who can be used in Amazon WorkMail by calling the RegisterToWorkMail operation.
     */
    suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Creates a user who can be used in Amazon WorkMail by calling the RegisterToWorkMail operation.
     */
    suspend fun createUser(block: CreateUserRequest.DslBuilder.() -> Unit) = createUser(CreateUserRequest.builder().apply(block).build())

    /**
     * Deletes an access control rule for the specified WorkMail organization.
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
     */
    suspend fun deleteAccessControlRule(input: DeleteAccessControlRuleRequest): DeleteAccessControlRuleResponse

    /**
     * Deletes an access control rule for the specified WorkMail organization.
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
     */
    suspend fun deleteAccessControlRule(block: DeleteAccessControlRuleRequest.DslBuilder.() -> Unit) = deleteAccessControlRule(DeleteAccessControlRuleRequest.builder().apply(block).build())

    /**
     * Remove one or more specified aliases from a set of aliases for a given
     * user.
     */
    suspend fun deleteAlias(input: DeleteAliasRequest): DeleteAliasResponse

    /**
     * Remove one or more specified aliases from a set of aliases for a given
     * user.
     */
    suspend fun deleteAlias(block: DeleteAliasRequest.DslBuilder.() -> Unit) = deleteAlias(DeleteAliasRequest.builder().apply(block).build())

    /**
     * Deletes a group from Amazon WorkMail.
     */
    suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse

    /**
     * Deletes a group from Amazon WorkMail.
     */
    suspend fun deleteGroup(block: DeleteGroupRequest.DslBuilder.() -> Unit) = deleteGroup(DeleteGroupRequest.builder().apply(block).build())

    /**
     * Deletes permissions granted to a member (user or group).
     */
    suspend fun deleteMailboxPermissions(input: DeleteMailboxPermissionsRequest): DeleteMailboxPermissionsResponse

    /**
     * Deletes permissions granted to a member (user or group).
     */
    suspend fun deleteMailboxPermissions(block: DeleteMailboxPermissionsRequest.DslBuilder.() -> Unit) = deleteMailboxPermissions(DeleteMailboxPermissionsRequest.builder().apply(block).build())

    /**
     * Deletes the mobile device access override for the given WorkMail organization, user, and device.
     * Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
     */
    suspend fun deleteMobileDeviceAccessOverride(input: DeleteMobileDeviceAccessOverrideRequest): DeleteMobileDeviceAccessOverrideResponse

    /**
     * Deletes the mobile device access override for the given WorkMail organization, user, and device.
     * Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
     */
    suspend fun deleteMobileDeviceAccessOverride(block: DeleteMobileDeviceAccessOverrideRequest.DslBuilder.() -> Unit) = deleteMobileDeviceAccessOverride(DeleteMobileDeviceAccessOverrideRequest.builder().apply(block).build())

    /**
     * Deletes a mobile device access rule for the specified Amazon WorkMail organization.
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
     */
    suspend fun deleteMobileDeviceAccessRule(input: DeleteMobileDeviceAccessRuleRequest): DeleteMobileDeviceAccessRuleResponse

    /**
     * Deletes a mobile device access rule for the specified Amazon WorkMail organization.
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
     */
    suspend fun deleteMobileDeviceAccessRule(block: DeleteMobileDeviceAccessRuleRequest.DslBuilder.() -> Unit) = deleteMobileDeviceAccessRule(DeleteMobileDeviceAccessRuleRequest.builder().apply(block).build())

    /**
     * Deletes an Amazon WorkMail organization and all underlying AWS resources managed by Amazon WorkMail as part of the organization. You can choose whether to delete the associated directory. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html">Removing an organization in the Amazon WorkMail Administrator Guide.
     */
    suspend fun deleteOrganization(input: DeleteOrganizationRequest): DeleteOrganizationResponse

    /**
     * Deletes an Amazon WorkMail organization and all underlying AWS resources managed by Amazon WorkMail as part of the organization. You can choose whether to delete the associated directory. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html">Removing an organization in the Amazon WorkMail Administrator Guide.
     */
    suspend fun deleteOrganization(block: DeleteOrganizationRequest.DslBuilder.() -> Unit) = deleteOrganization(DeleteOrganizationRequest.builder().apply(block).build())

    /**
     * Deletes the specified resource.
     */
    suspend fun deleteResource(input: DeleteResourceRequest): DeleteResourceResponse

    /**
     * Deletes the specified resource.
     */
    suspend fun deleteResource(block: DeleteResourceRequest.DslBuilder.() -> Unit) = deleteResource(DeleteResourceRequest.builder().apply(block).build())

    /**
     * Deletes the specified retention policy from the specified organization.
     */
    suspend fun deleteRetentionPolicy(input: DeleteRetentionPolicyRequest): DeleteRetentionPolicyResponse

    /**
     * Deletes the specified retention policy from the specified organization.
     */
    suspend fun deleteRetentionPolicy(block: DeleteRetentionPolicyRequest.DslBuilder.() -> Unit) = deleteRetentionPolicy(DeleteRetentionPolicyRequest.builder().apply(block).build())

    /**
     * Deletes a user from Amazon WorkMail and all subsequent systems. Before you can delete a
     * user, the user state must be DISABLED. Use the DescribeUser
     * action to confirm the user state.
     * Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for
     * 30 days before they are permanently removed.
     */
    suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes a user from Amazon WorkMail and all subsequent systems. Before you can delete a
     * user, the user state must be DISABLED. Use the DescribeUser
     * action to confirm the user state.
     * Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for
     * 30 days before they are permanently removed.
     */
    suspend fun deleteUser(block: DeleteUserRequest.DslBuilder.() -> Unit) = deleteUser(DeleteUserRequest.builder().apply(block).build())

    /**
     * Mark a user, group, or resource as no longer used in Amazon WorkMail. This action
     * disassociates the mailbox and schedules it for clean-up. WorkMail keeps mailboxes for 30 days
     * before they are permanently removed. The functionality in the console is
     * Disable.
     */
    suspend fun deregisterFromWorkMail(input: DeregisterFromWorkMailRequest): DeregisterFromWorkMailResponse

    /**
     * Mark a user, group, or resource as no longer used in Amazon WorkMail. This action
     * disassociates the mailbox and schedules it for clean-up. WorkMail keeps mailboxes for 30 days
     * before they are permanently removed. The functionality in the console is
     * Disable.
     */
    suspend fun deregisterFromWorkMail(block: DeregisterFromWorkMailRequest.DslBuilder.() -> Unit) = deregisterFromWorkMail(DeregisterFromWorkMailRequest.builder().apply(block).build())

    /**
     * Removes a domain from Amazon WorkMail, stops email routing to WorkMail, and removes the authorization allowing WorkMail use. SES keeps the domain because other applications may use it. You must first
     * remove any email address used by WorkMail entities before you remove the domain.
     */
    suspend fun deregisterMailDomain(input: DeregisterMailDomainRequest): DeregisterMailDomainResponse

    /**
     * Removes a domain from Amazon WorkMail, stops email routing to WorkMail, and removes the authorization allowing WorkMail use. SES keeps the domain because other applications may use it. You must first
     * remove any email address used by WorkMail entities before you remove the domain.
     */
    suspend fun deregisterMailDomain(block: DeregisterMailDomainRequest.DslBuilder.() -> Unit) = deregisterMailDomain(DeregisterMailDomainRequest.builder().apply(block).build())

    /**
     * Returns the data available for the group.
     */
    suspend fun describeGroup(input: DescribeGroupRequest): DescribeGroupResponse

    /**
     * Returns the data available for the group.
     */
    suspend fun describeGroup(block: DescribeGroupRequest.DslBuilder.() -> Unit) = describeGroup(DescribeGroupRequest.builder().apply(block).build())

    /**
     * Lists the settings in a DMARC policy for a specified organization.
     */
    suspend fun describeInboundDmarcSettings(input: DescribeInboundDmarcSettingsRequest): DescribeInboundDmarcSettingsResponse

    /**
     * Lists the settings in a DMARC policy for a specified organization.
     */
    suspend fun describeInboundDmarcSettings(block: DescribeInboundDmarcSettingsRequest.DslBuilder.() -> Unit) = describeInboundDmarcSettings(DescribeInboundDmarcSettingsRequest.builder().apply(block).build())

    /**
     * Describes the current status of a mailbox export job.
     */
    suspend fun describeMailboxExportJob(input: DescribeMailboxExportJobRequest): DescribeMailboxExportJobResponse

    /**
     * Describes the current status of a mailbox export job.
     */
    suspend fun describeMailboxExportJob(block: DescribeMailboxExportJobRequest.DslBuilder.() -> Unit) = describeMailboxExportJob(DescribeMailboxExportJobRequest.builder().apply(block).build())

    /**
     * Provides more information regarding a given organization based on its
     * identifier.
     */
    suspend fun describeOrganization(input: DescribeOrganizationRequest): DescribeOrganizationResponse

    /**
     * Provides more information regarding a given organization based on its
     * identifier.
     */
    suspend fun describeOrganization(block: DescribeOrganizationRequest.DslBuilder.() -> Unit) = describeOrganization(DescribeOrganizationRequest.builder().apply(block).build())

    /**
     * Returns the data available for the resource.
     */
    suspend fun describeResource(input: DescribeResourceRequest): DescribeResourceResponse

    /**
     * Returns the data available for the resource.
     */
    suspend fun describeResource(block: DescribeResourceRequest.DslBuilder.() -> Unit) = describeResource(DescribeResourceRequest.builder().apply(block).build())

    /**
     * Provides information regarding the user.
     */
    suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse

    /**
     * Provides information regarding the user.
     */
    suspend fun describeUser(block: DescribeUserRequest.DslBuilder.() -> Unit) = describeUser(DescribeUserRequest.builder().apply(block).build())

    /**
     * Removes a member from the resource's set of delegates.
     */
    suspend fun disassociateDelegateFromResource(input: DisassociateDelegateFromResourceRequest): DisassociateDelegateFromResourceResponse

    /**
     * Removes a member from the resource's set of delegates.
     */
    suspend fun disassociateDelegateFromResource(block: DisassociateDelegateFromResourceRequest.DslBuilder.() -> Unit) = disassociateDelegateFromResource(DisassociateDelegateFromResourceRequest.builder().apply(block).build())

    /**
     * Removes a member from a group.
     */
    suspend fun disassociateMemberFromGroup(input: DisassociateMemberFromGroupRequest): DisassociateMemberFromGroupResponse

    /**
     * Removes a member from a group.
     */
    suspend fun disassociateMemberFromGroup(block: DisassociateMemberFromGroupRequest.DslBuilder.() -> Unit) = disassociateMemberFromGroup(DisassociateMemberFromGroupRequest.builder().apply(block).build())

    /**
     * Gets the effects of an organization's access control rules as they apply to a
     * specified IPv4 address, access protocol action, or user ID.
     */
    suspend fun getAccessControlEffect(input: GetAccessControlEffectRequest): GetAccessControlEffectResponse

    /**
     * Gets the effects of an organization's access control rules as they apply to a
     * specified IPv4 address, access protocol action, or user ID.
     */
    suspend fun getAccessControlEffect(block: GetAccessControlEffectRequest.DslBuilder.() -> Unit) = getAccessControlEffect(GetAccessControlEffectRequest.builder().apply(block).build())

    /**
     * Gets the default retention policy details for the specified organization.
     */
    suspend fun getDefaultRetentionPolicy(input: GetDefaultRetentionPolicyRequest): GetDefaultRetentionPolicyResponse

    /**
     * Gets the default retention policy details for the specified organization.
     */
    suspend fun getDefaultRetentionPolicy(block: GetDefaultRetentionPolicyRequest.DslBuilder.() -> Unit) = getDefaultRetentionPolicy(GetDefaultRetentionPolicyRequest.builder().apply(block).build())

    /**
     * Gets details for a mail domain, including domain records required to configure your domain with recommended security.
     */
    suspend fun getMailDomain(input: GetMailDomainRequest): GetMailDomainResponse

    /**
     * Gets details for a mail domain, including domain records required to configure your domain with recommended security.
     */
    suspend fun getMailDomain(block: GetMailDomainRequest.DslBuilder.() -> Unit) = getMailDomain(GetMailDomainRequest.builder().apply(block).build())

    /**
     * Requests a user's mailbox details for a specified organization and user.
     */
    suspend fun getMailboxDetails(input: GetMailboxDetailsRequest): GetMailboxDetailsResponse

    /**
     * Requests a user's mailbox details for a specified organization and user.
     */
    suspend fun getMailboxDetails(block: GetMailboxDetailsRequest.DslBuilder.() -> Unit) = getMailboxDetails(GetMailboxDetailsRequest.builder().apply(block).build())

    /**
     * Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use this method to test the effects of the current set of mobile device access
     * rules for the Amazon WorkMail organization for a particular user's attributes.
     */
    suspend fun getMobileDeviceAccessEffect(input: GetMobileDeviceAccessEffectRequest): GetMobileDeviceAccessEffectResponse

    /**
     * Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use this method to test the effects of the current set of mobile device access
     * rules for the Amazon WorkMail organization for a particular user's attributes.
     */
    suspend fun getMobileDeviceAccessEffect(block: GetMobileDeviceAccessEffectRequest.DslBuilder.() -> Unit) = getMobileDeviceAccessEffect(GetMobileDeviceAccessEffectRequest.builder().apply(block).build())

    /**
     * Gets the mobile device access override for the given WorkMail organization, user, and device.
     */
    suspend fun getMobileDeviceAccessOverride(input: GetMobileDeviceAccessOverrideRequest): GetMobileDeviceAccessOverrideResponse

    /**
     * Gets the mobile device access override for the given WorkMail organization, user, and device.
     */
    suspend fun getMobileDeviceAccessOverride(block: GetMobileDeviceAccessOverrideRequest.DslBuilder.() -> Unit) = getMobileDeviceAccessOverride(GetMobileDeviceAccessOverrideRequest.builder().apply(block).build())

    /**
     * Lists the access control rules for the specified organization.
     */
    suspend fun listAccessControlRules(input: ListAccessControlRulesRequest): ListAccessControlRulesResponse

    /**
     * Lists the access control rules for the specified organization.
     */
    suspend fun listAccessControlRules(block: ListAccessControlRulesRequest.DslBuilder.() -> Unit) = listAccessControlRules(ListAccessControlRulesRequest.builder().apply(block).build())

    /**
     * Creates a paginated call to list the aliases associated with a given
     * entity.
     */
    suspend fun listAliases(input: ListAliasesRequest): ListAliasesResponse

    /**
     * Creates a paginated call to list the aliases associated with a given
     * entity.
     */
    suspend fun listAliases(block: ListAliasesRequest.DslBuilder.() -> Unit) = listAliases(ListAliasesRequest.builder().apply(block).build())

    /**
     * Returns an overview of the members of a group. Users and groups can be members of a
     * group.
     */
    suspend fun listGroupMembers(input: ListGroupMembersRequest): ListGroupMembersResponse

    /**
     * Returns an overview of the members of a group. Users and groups can be members of a
     * group.
     */
    suspend fun listGroupMembers(block: ListGroupMembersRequest.DslBuilder.() -> Unit) = listGroupMembers(ListGroupMembersRequest.builder().apply(block).build())

    /**
     * Returns summaries of the organization's groups.
     */
    suspend fun listGroups(input: ListGroupsRequest): ListGroupsResponse

    /**
     * Returns summaries of the organization's groups.
     */
    suspend fun listGroups(block: ListGroupsRequest.DslBuilder.() -> Unit) = listGroups(ListGroupsRequest.builder().apply(block).build())

    /**
     * Lists the mail domains in a given Amazon WorkMail organization.
     */
    suspend fun listMailDomains(input: ListMailDomainsRequest): ListMailDomainsResponse

    /**
     * Lists the mail domains in a given Amazon WorkMail organization.
     */
    suspend fun listMailDomains(block: ListMailDomainsRequest.DslBuilder.() -> Unit) = listMailDomains(ListMailDomainsRequest.builder().apply(block).build())

    /**
     * Lists the mailbox export jobs started for the specified organization within the last
     * seven days.
     */
    suspend fun listMailboxExportJobs(input: ListMailboxExportJobsRequest): ListMailboxExportJobsResponse

    /**
     * Lists the mailbox export jobs started for the specified organization within the last
     * seven days.
     */
    suspend fun listMailboxExportJobs(block: ListMailboxExportJobsRequest.DslBuilder.() -> Unit) = listMailboxExportJobs(ListMailboxExportJobsRequest.builder().apply(block).build())

    /**
     * Lists the mailbox permissions associated with a user, group, or resource
     * mailbox.
     */
    suspend fun listMailboxPermissions(input: ListMailboxPermissionsRequest): ListMailboxPermissionsResponse

    /**
     * Lists the mailbox permissions associated with a user, group, or resource
     * mailbox.
     */
    suspend fun listMailboxPermissions(block: ListMailboxPermissionsRequest.DslBuilder.() -> Unit) = listMailboxPermissions(ListMailboxPermissionsRequest.builder().apply(block).build())

    /**
     * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
     */
    suspend fun listMobileDeviceAccessOverrides(input: ListMobileDeviceAccessOverridesRequest): ListMobileDeviceAccessOverridesResponse

    /**
     * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
     */
    suspend fun listMobileDeviceAccessOverrides(block: ListMobileDeviceAccessOverridesRequest.DslBuilder.() -> Unit) = listMobileDeviceAccessOverrides(ListMobileDeviceAccessOverridesRequest.builder().apply(block).build())

    /**
     * Lists the mobile device access rules for the specified Amazon WorkMail organization.
     */
    suspend fun listMobileDeviceAccessRules(input: ListMobileDeviceAccessRulesRequest): ListMobileDeviceAccessRulesResponse

    /**
     * Lists the mobile device access rules for the specified Amazon WorkMail organization.
     */
    suspend fun listMobileDeviceAccessRules(block: ListMobileDeviceAccessRulesRequest.DslBuilder.() -> Unit) = listMobileDeviceAccessRules(ListMobileDeviceAccessRulesRequest.builder().apply(block).build())

    /**
     * Returns summaries of the customer's organizations.
     */
    suspend fun listOrganizations(input: ListOrganizationsRequest): ListOrganizationsResponse

    /**
     * Returns summaries of the customer's organizations.
     */
    suspend fun listOrganizations(block: ListOrganizationsRequest.DslBuilder.() -> Unit) = listOrganizations(ListOrganizationsRequest.builder().apply(block).build())

    /**
     * Lists the delegates associated with a resource. Users and groups can be resource
     * delegates and answer requests on behalf of the resource.
     */
    suspend fun listResourceDelegates(input: ListResourceDelegatesRequest): ListResourceDelegatesResponse

    /**
     * Lists the delegates associated with a resource. Users and groups can be resource
     * delegates and answer requests on behalf of the resource.
     */
    suspend fun listResourceDelegates(block: ListResourceDelegatesRequest.DslBuilder.() -> Unit) = listResourceDelegates(ListResourceDelegatesRequest.builder().apply(block).build())

    /**
     * Returns summaries of the organization's resources.
     */
    suspend fun listResources(input: ListResourcesRequest): ListResourcesResponse

    /**
     * Returns summaries of the organization's resources.
     */
    suspend fun listResources(block: ListResourcesRequest.DslBuilder.() -> Unit) = listResources(ListResourcesRequest.builder().apply(block).build())

    /**
     * Lists the tags applied to an Amazon WorkMail organization resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags applied to an Amazon WorkMail organization resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Returns summaries of the organization's users.
     */
    suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Returns summaries of the organization's users.
     */
    suspend fun listUsers(block: ListUsersRequest.DslBuilder.() -> Unit) = listUsers(ListUsersRequest.builder().apply(block).build())

    /**
     * Adds a new access control rule for the specified organization. The rule allows or
     * denies access to the organization for the specified IPv4 addresses, access protocol
     * actions, and user IDs. Adding a new rule with the same name as an existing rule replaces
     * the older rule.
     */
    suspend fun putAccessControlRule(input: PutAccessControlRuleRequest): PutAccessControlRuleResponse

    /**
     * Adds a new access control rule for the specified organization. The rule allows or
     * denies access to the organization for the specified IPv4 addresses, access protocol
     * actions, and user IDs. Adding a new rule with the same name as an existing rule replaces
     * the older rule.
     */
    suspend fun putAccessControlRule(block: PutAccessControlRuleRequest.DslBuilder.() -> Unit) = putAccessControlRule(PutAccessControlRuleRequest.builder().apply(block).build())

    /**
     * Enables or disables a DMARC policy for a given organization.
     */
    suspend fun putInboundDmarcSettings(input: PutInboundDmarcSettingsRequest): PutInboundDmarcSettingsResponse

    /**
     * Enables or disables a DMARC policy for a given organization.
     */
    suspend fun putInboundDmarcSettings(block: PutInboundDmarcSettingsRequest.DslBuilder.() -> Unit) = putInboundDmarcSettings(PutInboundDmarcSettingsRequest.builder().apply(block).build())

    /**
     * Sets permissions for a user, group, or resource. This replaces any pre-existing
     * permissions.
     */
    suspend fun putMailboxPermissions(input: PutMailboxPermissionsRequest): PutMailboxPermissionsResponse

    /**
     * Sets permissions for a user, group, or resource. This replaces any pre-existing
     * permissions.
     */
    suspend fun putMailboxPermissions(block: PutMailboxPermissionsRequest.DslBuilder.() -> Unit) = putMailboxPermissions(PutMailboxPermissionsRequest.builder().apply(block).build())

    /**
     * Creates or updates a mobile device access override for the given WorkMail organization, user, and device.
     */
    suspend fun putMobileDeviceAccessOverride(input: PutMobileDeviceAccessOverrideRequest): PutMobileDeviceAccessOverrideResponse

    /**
     * Creates or updates a mobile device access override for the given WorkMail organization, user, and device.
     */
    suspend fun putMobileDeviceAccessOverride(block: PutMobileDeviceAccessOverrideRequest.DslBuilder.() -> Unit) = putMobileDeviceAccessOverride(PutMobileDeviceAccessOverrideRequest.builder().apply(block).build())

    /**
     * Puts a retention policy to the specified organization.
     */
    suspend fun putRetentionPolicy(input: PutRetentionPolicyRequest): PutRetentionPolicyResponse

    /**
     * Puts a retention policy to the specified organization.
     */
    suspend fun putRetentionPolicy(block: PutRetentionPolicyRequest.DslBuilder.() -> Unit) = putRetentionPolicy(PutRetentionPolicyRequest.builder().apply(block).build())

    /**
     * Registers a new domain in Amazon WorkMail and SES, and configures it for use by WorkMail. Emails received by SES for this domain are routed to the specified WorkMail organization, and WorkMail has
     * permanent permission to use the specified domain for sending your users' emails.
     */
    suspend fun registerMailDomain(input: RegisterMailDomainRequest): RegisterMailDomainResponse

    /**
     * Registers a new domain in Amazon WorkMail and SES, and configures it for use by WorkMail. Emails received by SES for this domain are routed to the specified WorkMail organization, and WorkMail has
     * permanent permission to use the specified domain for sending your users' emails.
     */
    suspend fun registerMailDomain(block: RegisterMailDomainRequest.DslBuilder.() -> Unit) = registerMailDomain(RegisterMailDomainRequest.builder().apply(block).build())

    /**
     * Registers an existing and disabled user, group, or resource for Amazon WorkMail use by
     * associating a mailbox and calendaring capabilities. It performs no change if the user,
     * group, or resource is enabled and fails if the user, group, or resource is deleted. This
     * operation results in the accumulation of costs. For more information, see <a href="https://aws.amazon.com/workmail/pricing">Pricing. The equivalent console
     * functionality for this operation is Enable.
     * Users can either be created by calling the CreateUser API operation
     * or they can be synchronized from your directory. For more information, see DeregisterFromWorkMail.
     */
    suspend fun registerToWorkMail(input: RegisterToWorkMailRequest): RegisterToWorkMailResponse

    /**
     * Registers an existing and disabled user, group, or resource for Amazon WorkMail use by
     * associating a mailbox and calendaring capabilities. It performs no change if the user,
     * group, or resource is enabled and fails if the user, group, or resource is deleted. This
     * operation results in the accumulation of costs. For more information, see <a href="https://aws.amazon.com/workmail/pricing">Pricing. The equivalent console
     * functionality for this operation is Enable.
     * Users can either be created by calling the CreateUser API operation
     * or they can be synchronized from your directory. For more information, see DeregisterFromWorkMail.
     */
    suspend fun registerToWorkMail(block: RegisterToWorkMailRequest.DslBuilder.() -> Unit) = registerToWorkMail(RegisterToWorkMailRequest.builder().apply(block).build())

    /**
     * Allows the administrator to reset the password for a user.
     */
    suspend fun resetPassword(input: ResetPasswordRequest): ResetPasswordResponse

    /**
     * Allows the administrator to reset the password for a user.
     */
    suspend fun resetPassword(block: ResetPasswordRequest.DslBuilder.() -> Unit) = resetPassword(ResetPasswordRequest.builder().apply(block).build())

    /**
     * Starts a mailbox export job to export MIME-format email messages and calendar items
     * from the specified mailbox to the specified Amazon Simple Storage Service (Amazon S3)
     * bucket. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html">Exporting mailbox content in
     * the Amazon WorkMail Administrator Guide.
     */
    suspend fun startMailboxExportJob(input: StartMailboxExportJobRequest): StartMailboxExportJobResponse

    /**
     * Starts a mailbox export job to export MIME-format email messages and calendar items
     * from the specified mailbox to the specified Amazon Simple Storage Service (Amazon S3)
     * bucket. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html">Exporting mailbox content in
     * the Amazon WorkMail Administrator Guide.
     */
    suspend fun startMailboxExportJob(block: StartMailboxExportJobRequest.DslBuilder.() -> Unit) = startMailboxExportJob(StartMailboxExportJobRequest.builder().apply(block).build())

    /**
     * Applies the specified tags to the specified Amazon WorkMail organization
     * resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Applies the specified tags to the specified Amazon WorkMail organization
     * resource.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Untags the specified tags from the specified Amazon WorkMail organization
     * resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Untags the specified tags from the specified Amazon WorkMail organization
     * resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console to suggest an email address when enabling a mail user. You can only have one default domain.
     */
    suspend fun updateDefaultMailDomain(input: UpdateDefaultMailDomainRequest): UpdateDefaultMailDomainResponse

    /**
     * Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console to suggest an email address when enabling a mail user. You can only have one default domain.
     */
    suspend fun updateDefaultMailDomain(block: UpdateDefaultMailDomainRequest.DslBuilder.() -> Unit) = updateDefaultMailDomain(UpdateDefaultMailDomainRequest.builder().apply(block).build())

    /**
     * Updates a user's current mailbox quota for a specified organization and
     * user.
     */
    suspend fun updateMailboxQuota(input: UpdateMailboxQuotaRequest): UpdateMailboxQuotaResponse

    /**
     * Updates a user's current mailbox quota for a specified organization and
     * user.
     */
    suspend fun updateMailboxQuota(block: UpdateMailboxQuotaRequest.DslBuilder.() -> Unit) = updateMailboxQuota(UpdateMailboxQuotaRequest.builder().apply(block).build())

    /**
     * Updates a mobile device access rule for the specified Amazon WorkMail organization.
     */
    suspend fun updateMobileDeviceAccessRule(input: UpdateMobileDeviceAccessRuleRequest): UpdateMobileDeviceAccessRuleResponse

    /**
     * Updates a mobile device access rule for the specified Amazon WorkMail organization.
     */
    suspend fun updateMobileDeviceAccessRule(block: UpdateMobileDeviceAccessRuleRequest.DslBuilder.() -> Unit) = updateMobileDeviceAccessRule(UpdateMobileDeviceAccessRuleRequest.builder().apply(block).build())

    /**
     * Updates the primary email for a user, group, or resource. The current email is moved
     * into the list of aliases (or swapped between an existing alias and the current primary
     * email), and the email provided in the input is promoted as the primary.
     */
    suspend fun updatePrimaryEmailAddress(input: UpdatePrimaryEmailAddressRequest): UpdatePrimaryEmailAddressResponse

    /**
     * Updates the primary email for a user, group, or resource. The current email is moved
     * into the list of aliases (or swapped between an existing alias and the current primary
     * email), and the email provided in the input is promoted as the primary.
     */
    suspend fun updatePrimaryEmailAddress(block: UpdatePrimaryEmailAddressRequest.DslBuilder.() -> Unit) = updatePrimaryEmailAddress(UpdatePrimaryEmailAddressRequest.builder().apply(block).build())

    /**
     * Updates data for the resource. To have the latest information, it must be preceded by
     * a DescribeResource call. The dataset in the request should be the one
     * expected when performing another DescribeResource call.
     */
    suspend fun updateResource(input: UpdateResourceRequest): UpdateResourceResponse

    /**
     * Updates data for the resource. To have the latest information, it must be preceded by
     * a DescribeResource call. The dataset in the request should be the one
     * expected when performing another DescribeResource call.
     */
    suspend fun updateResource(block: UpdateResourceRequest.DslBuilder.() -> Unit) = updateResource(UpdateResourceRequest.builder().apply(block).build())
}
