// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.workmail.model.*
import aws.sdk.kotlin.services.workmail.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "WorkMail"
const val ServiceApiVersion: String = "2017-10-01"
const val SdkVersion: String = "0.9.1-alpha"

internal class DefaultWorkMailClient(override val config: WorkMailClient.Config) : WorkMailClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Adds a member (user or group) to the resource's set of delegates.
     */
    override suspend fun associateDelegateToResource(input: AssociateDelegateToResourceRequest): AssociateDelegateToResourceResponse {
        val op = SdkHttpOperation.build<AssociateDelegateToResourceRequest, AssociateDelegateToResourceResponse> {
            serializer = AssociateDelegateToResourceOperationSerializer()
            deserializer = AssociateDelegateToResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateDelegateToResource"
            }
        }
        registerAssociateDelegateToResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a member (user or group) to the group's set.
     */
    override suspend fun associateMemberToGroup(input: AssociateMemberToGroupRequest): AssociateMemberToGroupResponse {
        val op = SdkHttpOperation.build<AssociateMemberToGroupRequest, AssociateMemberToGroupResponse> {
            serializer = AssociateMemberToGroupOperationSerializer()
            deserializer = AssociateMemberToGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateMemberToGroup"
            }
        }
        registerAssociateMemberToGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a mailbox export job.
     * If the mailbox export job is near completion, it might not be possible to cancel
     * it.
     */
    override suspend fun cancelMailboxExportJob(input: CancelMailboxExportJobRequest): CancelMailboxExportJobResponse {
        val op = SdkHttpOperation.build<CancelMailboxExportJobRequest, CancelMailboxExportJobResponse> {
            serializer = CancelMailboxExportJobOperationSerializer()
            deserializer = CancelMailboxExportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelMailboxExportJob"
            }
        }
        registerCancelMailboxExportJobMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds an alias to the set of a given member (user or group) of Amazon WorkMail.
     */
    override suspend fun createAlias(input: CreateAliasRequest): CreateAliasResponse {
        val op = SdkHttpOperation.build<CreateAliasRequest, CreateAliasResponse> {
            serializer = CreateAliasOperationSerializer()
            deserializer = CreateAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAlias"
            }
        }
        registerCreateAliasMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a group that can be used in Amazon WorkMail by calling the RegisterToWorkMail operation.
     */
    override suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse {
        val op = SdkHttpOperation.build<CreateGroupRequest, CreateGroupResponse> {
            serializer = CreateGroupOperationSerializer()
            deserializer = CreateGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGroup"
            }
        }
        registerCreateGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new mobile device access rule for the specified Amazon WorkMail organization.
     */
    override suspend fun createMobileDeviceAccessRule(input: CreateMobileDeviceAccessRuleRequest): CreateMobileDeviceAccessRuleResponse {
        val op = SdkHttpOperation.build<CreateMobileDeviceAccessRuleRequest, CreateMobileDeviceAccessRuleResponse> {
            serializer = CreateMobileDeviceAccessRuleOperationSerializer()
            deserializer = CreateMobileDeviceAccessRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMobileDeviceAccessRule"
            }
        }
        registerCreateMobileDeviceAccessRuleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon WorkMail organization. Optionally, you can choose to associate an existing AWS Directory Service directory with your organization. If an AWS Directory Service directory ID is specified, the organization alias must match the directory alias. If you choose not to associate an existing directory with your organization, then we create a new Amazon WorkMail directory for you. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html">Adding an organization in the Amazon WorkMail Administrator Guide.
     * You can associate multiple email domains with an organization, then set your default email domain from the Amazon WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a domain and <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html">Choosing the default domain in the Amazon WorkMail Administrator Guide.
     * Optionally, you can use a customer managed master key from AWS Key Management Service
     * (AWS KMS) to encrypt email for your organization. If you don't associate an AWS KMS key, Amazon WorkMail creates a
     * default AWS managed master key for you.
     */
    override suspend fun createOrganization(input: CreateOrganizationRequest): CreateOrganizationResponse {
        val op = SdkHttpOperation.build<CreateOrganizationRequest, CreateOrganizationResponse> {
            serializer = CreateOrganizationOperationSerializer()
            deserializer = CreateOrganizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateOrganization"
            }
        }
        registerCreateOrganizationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon WorkMail resource.
     */
    override suspend fun createResource(input: CreateResourceRequest): CreateResourceResponse {
        val op = SdkHttpOperation.build<CreateResourceRequest, CreateResourceResponse> {
            serializer = CreateResourceOperationSerializer()
            deserializer = CreateResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateResource"
            }
        }
        registerCreateResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user who can be used in Amazon WorkMail by calling the RegisterToWorkMail operation.
     */
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializer = CreateUserOperationSerializer()
            deserializer = CreateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUser"
            }
        }
        registerCreateUserMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an access control rule for the specified WorkMail organization.
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
     */
    override suspend fun deleteAccessControlRule(input: DeleteAccessControlRuleRequest): DeleteAccessControlRuleResponse {
        val op = SdkHttpOperation.build<DeleteAccessControlRuleRequest, DeleteAccessControlRuleResponse> {
            serializer = DeleteAccessControlRuleOperationSerializer()
            deserializer = DeleteAccessControlRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAccessControlRule"
            }
        }
        registerDeleteAccessControlRuleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Remove one or more specified aliases from a set of aliases for a given
     * user.
     */
    override suspend fun deleteAlias(input: DeleteAliasRequest): DeleteAliasResponse {
        val op = SdkHttpOperation.build<DeleteAliasRequest, DeleteAliasResponse> {
            serializer = DeleteAliasOperationSerializer()
            deserializer = DeleteAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAlias"
            }
        }
        registerDeleteAliasMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a group from Amazon WorkMail.
     */
    override suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse {
        val op = SdkHttpOperation.build<DeleteGroupRequest, DeleteGroupResponse> {
            serializer = DeleteGroupOperationSerializer()
            deserializer = DeleteGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGroup"
            }
        }
        registerDeleteGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes permissions granted to a member (user or group).
     */
    override suspend fun deleteMailboxPermissions(input: DeleteMailboxPermissionsRequest): DeleteMailboxPermissionsResponse {
        val op = SdkHttpOperation.build<DeleteMailboxPermissionsRequest, DeleteMailboxPermissionsResponse> {
            serializer = DeleteMailboxPermissionsOperationSerializer()
            deserializer = DeleteMailboxPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMailboxPermissions"
            }
        }
        registerDeleteMailboxPermissionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the mobile device access override for the given WorkMail organization, user, and device.
     * Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
     */
    override suspend fun deleteMobileDeviceAccessOverride(input: DeleteMobileDeviceAccessOverrideRequest): DeleteMobileDeviceAccessOverrideResponse {
        val op = SdkHttpOperation.build<DeleteMobileDeviceAccessOverrideRequest, DeleteMobileDeviceAccessOverrideResponse> {
            serializer = DeleteMobileDeviceAccessOverrideOperationSerializer()
            deserializer = DeleteMobileDeviceAccessOverrideOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMobileDeviceAccessOverride"
            }
        }
        registerDeleteMobileDeviceAccessOverrideMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a mobile device access rule for the specified Amazon WorkMail organization.
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
     */
    override suspend fun deleteMobileDeviceAccessRule(input: DeleteMobileDeviceAccessRuleRequest): DeleteMobileDeviceAccessRuleResponse {
        val op = SdkHttpOperation.build<DeleteMobileDeviceAccessRuleRequest, DeleteMobileDeviceAccessRuleResponse> {
            serializer = DeleteMobileDeviceAccessRuleOperationSerializer()
            deserializer = DeleteMobileDeviceAccessRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMobileDeviceAccessRule"
            }
        }
        registerDeleteMobileDeviceAccessRuleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon WorkMail organization and all underlying AWS resources managed by Amazon WorkMail as part of the organization. You can choose whether to delete the associated directory. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html">Removing an organization in the Amazon WorkMail Administrator Guide.
     */
    override suspend fun deleteOrganization(input: DeleteOrganizationRequest): DeleteOrganizationResponse {
        val op = SdkHttpOperation.build<DeleteOrganizationRequest, DeleteOrganizationResponse> {
            serializer = DeleteOrganizationOperationSerializer()
            deserializer = DeleteOrganizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteOrganization"
            }
        }
        registerDeleteOrganizationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified resource.
     */
    override suspend fun deleteResource(input: DeleteResourceRequest): DeleteResourceResponse {
        val op = SdkHttpOperation.build<DeleteResourceRequest, DeleteResourceResponse> {
            serializer = DeleteResourceOperationSerializer()
            deserializer = DeleteResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteResource"
            }
        }
        registerDeleteResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified retention policy from the specified organization.
     */
    override suspend fun deleteRetentionPolicy(input: DeleteRetentionPolicyRequest): DeleteRetentionPolicyResponse {
        val op = SdkHttpOperation.build<DeleteRetentionPolicyRequest, DeleteRetentionPolicyResponse> {
            serializer = DeleteRetentionPolicyOperationSerializer()
            deserializer = DeleteRetentionPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRetentionPolicy"
            }
        }
        registerDeleteRetentionPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a user from Amazon WorkMail and all subsequent systems. Before you can delete a
     * user, the user state must be DISABLED. Use the DescribeUser
     * action to confirm the user state.
     * Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for
     * 30 days before they are permanently removed.
     */
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializer = DeleteUserOperationSerializer()
            deserializer = DeleteUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUser"
            }
        }
        registerDeleteUserMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Mark a user, group, or resource as no longer used in Amazon WorkMail. This action
     * disassociates the mailbox and schedules it for clean-up. WorkMail keeps mailboxes for 30 days
     * before they are permanently removed. The functionality in the console is
     * Disable.
     */
    override suspend fun deregisterFromWorkMail(input: DeregisterFromWorkMailRequest): DeregisterFromWorkMailResponse {
        val op = SdkHttpOperation.build<DeregisterFromWorkMailRequest, DeregisterFromWorkMailResponse> {
            serializer = DeregisterFromWorkMailOperationSerializer()
            deserializer = DeregisterFromWorkMailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterFromWorkMail"
            }
        }
        registerDeregisterFromWorkMailMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a domain from Amazon WorkMail, stops email routing to WorkMail, and removes the authorization allowing WorkMail use. SES keeps the domain because other applications may use it. You must first
     * remove any email address used by WorkMail entities before you remove the domain.
     */
    override suspend fun deregisterMailDomain(input: DeregisterMailDomainRequest): DeregisterMailDomainResponse {
        val op = SdkHttpOperation.build<DeregisterMailDomainRequest, DeregisterMailDomainResponse> {
            serializer = DeregisterMailDomainOperationSerializer()
            deserializer = DeregisterMailDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterMailDomain"
            }
        }
        registerDeregisterMailDomainMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the data available for the group.
     */
    override suspend fun describeGroup(input: DescribeGroupRequest): DescribeGroupResponse {
        val op = SdkHttpOperation.build<DescribeGroupRequest, DescribeGroupResponse> {
            serializer = DescribeGroupOperationSerializer()
            deserializer = DescribeGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeGroup"
            }
        }
        registerDescribeGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the settings in a DMARC policy for a specified organization.
     */
    override suspend fun describeInboundDmarcSettings(input: DescribeInboundDmarcSettingsRequest): DescribeInboundDmarcSettingsResponse {
        val op = SdkHttpOperation.build<DescribeInboundDmarcSettingsRequest, DescribeInboundDmarcSettingsResponse> {
            serializer = DescribeInboundDmarcSettingsOperationSerializer()
            deserializer = DescribeInboundDmarcSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInboundDmarcSettings"
            }
        }
        registerDescribeInboundDmarcSettingsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the current status of a mailbox export job.
     */
    override suspend fun describeMailboxExportJob(input: DescribeMailboxExportJobRequest): DescribeMailboxExportJobResponse {
        val op = SdkHttpOperation.build<DescribeMailboxExportJobRequest, DescribeMailboxExportJobResponse> {
            serializer = DescribeMailboxExportJobOperationSerializer()
            deserializer = DescribeMailboxExportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeMailboxExportJob"
            }
        }
        registerDescribeMailboxExportJobMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Provides more information regarding a given organization based on its
     * identifier.
     */
    override suspend fun describeOrganization(input: DescribeOrganizationRequest): DescribeOrganizationResponse {
        val op = SdkHttpOperation.build<DescribeOrganizationRequest, DescribeOrganizationResponse> {
            serializer = DescribeOrganizationOperationSerializer()
            deserializer = DescribeOrganizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOrganization"
            }
        }
        registerDescribeOrganizationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the data available for the resource.
     */
    override suspend fun describeResource(input: DescribeResourceRequest): DescribeResourceResponse {
        val op = SdkHttpOperation.build<DescribeResourceRequest, DescribeResourceResponse> {
            serializer = DescribeResourceOperationSerializer()
            deserializer = DescribeResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeResource"
            }
        }
        registerDescribeResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Provides information regarding the user.
     */
    override suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse {
        val op = SdkHttpOperation.build<DescribeUserRequest, DescribeUserResponse> {
            serializer = DescribeUserOperationSerializer()
            deserializer = DescribeUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUser"
            }
        }
        registerDescribeUserMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a member from the resource's set of delegates.
     */
    override suspend fun disassociateDelegateFromResource(input: DisassociateDelegateFromResourceRequest): DisassociateDelegateFromResourceResponse {
        val op = SdkHttpOperation.build<DisassociateDelegateFromResourceRequest, DisassociateDelegateFromResourceResponse> {
            serializer = DisassociateDelegateFromResourceOperationSerializer()
            deserializer = DisassociateDelegateFromResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateDelegateFromResource"
            }
        }
        registerDisassociateDelegateFromResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a member from a group.
     */
    override suspend fun disassociateMemberFromGroup(input: DisassociateMemberFromGroupRequest): DisassociateMemberFromGroupResponse {
        val op = SdkHttpOperation.build<DisassociateMemberFromGroupRequest, DisassociateMemberFromGroupResponse> {
            serializer = DisassociateMemberFromGroupOperationSerializer()
            deserializer = DisassociateMemberFromGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateMemberFromGroup"
            }
        }
        registerDisassociateMemberFromGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the effects of an organization's access control rules as they apply to a
     * specified IPv4 address, access protocol action, or user ID.
     */
    override suspend fun getAccessControlEffect(input: GetAccessControlEffectRequest): GetAccessControlEffectResponse {
        val op = SdkHttpOperation.build<GetAccessControlEffectRequest, GetAccessControlEffectResponse> {
            serializer = GetAccessControlEffectOperationSerializer()
            deserializer = GetAccessControlEffectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAccessControlEffect"
            }
        }
        registerGetAccessControlEffectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the default retention policy details for the specified organization.
     */
    override suspend fun getDefaultRetentionPolicy(input: GetDefaultRetentionPolicyRequest): GetDefaultRetentionPolicyResponse {
        val op = SdkHttpOperation.build<GetDefaultRetentionPolicyRequest, GetDefaultRetentionPolicyResponse> {
            serializer = GetDefaultRetentionPolicyOperationSerializer()
            deserializer = GetDefaultRetentionPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDefaultRetentionPolicy"
            }
        }
        registerGetDefaultRetentionPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets details for a mail domain, including domain records required to configure your domain with recommended security.
     */
    override suspend fun getMailDomain(input: GetMailDomainRequest): GetMailDomainResponse {
        val op = SdkHttpOperation.build<GetMailDomainRequest, GetMailDomainResponse> {
            serializer = GetMailDomainOperationSerializer()
            deserializer = GetMailDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMailDomain"
            }
        }
        registerGetMailDomainMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Requests a user's mailbox details for a specified organization and user.
     */
    override suspend fun getMailboxDetails(input: GetMailboxDetailsRequest): GetMailboxDetailsResponse {
        val op = SdkHttpOperation.build<GetMailboxDetailsRequest, GetMailboxDetailsResponse> {
            serializer = GetMailboxDetailsOperationSerializer()
            deserializer = GetMailboxDetailsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMailboxDetails"
            }
        }
        registerGetMailboxDetailsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use this method to test the effects of the current set of mobile device access
     * rules for the Amazon WorkMail organization for a particular user's attributes.
     */
    override suspend fun getMobileDeviceAccessEffect(input: GetMobileDeviceAccessEffectRequest): GetMobileDeviceAccessEffectResponse {
        val op = SdkHttpOperation.build<GetMobileDeviceAccessEffectRequest, GetMobileDeviceAccessEffectResponse> {
            serializer = GetMobileDeviceAccessEffectOperationSerializer()
            deserializer = GetMobileDeviceAccessEffectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMobileDeviceAccessEffect"
            }
        }
        registerGetMobileDeviceAccessEffectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the mobile device access override for the given WorkMail organization, user, and device.
     */
    override suspend fun getMobileDeviceAccessOverride(input: GetMobileDeviceAccessOverrideRequest): GetMobileDeviceAccessOverrideResponse {
        val op = SdkHttpOperation.build<GetMobileDeviceAccessOverrideRequest, GetMobileDeviceAccessOverrideResponse> {
            serializer = GetMobileDeviceAccessOverrideOperationSerializer()
            deserializer = GetMobileDeviceAccessOverrideOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMobileDeviceAccessOverride"
            }
        }
        registerGetMobileDeviceAccessOverrideMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the access control rules for the specified organization.
     */
    override suspend fun listAccessControlRules(input: ListAccessControlRulesRequest): ListAccessControlRulesResponse {
        val op = SdkHttpOperation.build<ListAccessControlRulesRequest, ListAccessControlRulesResponse> {
            serializer = ListAccessControlRulesOperationSerializer()
            deserializer = ListAccessControlRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccessControlRules"
            }
        }
        registerListAccessControlRulesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a paginated call to list the aliases associated with a given
     * entity.
     */
    override suspend fun listAliases(input: ListAliasesRequest): ListAliasesResponse {
        val op = SdkHttpOperation.build<ListAliasesRequest, ListAliasesResponse> {
            serializer = ListAliasesOperationSerializer()
            deserializer = ListAliasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAliases"
            }
        }
        registerListAliasesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an overview of the members of a group. Users and groups can be members of a
     * group.
     */
    override suspend fun listGroupMembers(input: ListGroupMembersRequest): ListGroupMembersResponse {
        val op = SdkHttpOperation.build<ListGroupMembersRequest, ListGroupMembersResponse> {
            serializer = ListGroupMembersOperationSerializer()
            deserializer = ListGroupMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGroupMembers"
            }
        }
        registerListGroupMembersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns summaries of the organization's groups.
     */
    override suspend fun listGroups(input: ListGroupsRequest): ListGroupsResponse {
        val op = SdkHttpOperation.build<ListGroupsRequest, ListGroupsResponse> {
            serializer = ListGroupsOperationSerializer()
            deserializer = ListGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGroups"
            }
        }
        registerListGroupsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the mail domains in a given Amazon WorkMail organization.
     */
    override suspend fun listMailDomains(input: ListMailDomainsRequest): ListMailDomainsResponse {
        val op = SdkHttpOperation.build<ListMailDomainsRequest, ListMailDomainsResponse> {
            serializer = ListMailDomainsOperationSerializer()
            deserializer = ListMailDomainsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMailDomains"
            }
        }
        registerListMailDomainsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the mailbox export jobs started for the specified organization within the last
     * seven days.
     */
    override suspend fun listMailboxExportJobs(input: ListMailboxExportJobsRequest): ListMailboxExportJobsResponse {
        val op = SdkHttpOperation.build<ListMailboxExportJobsRequest, ListMailboxExportJobsResponse> {
            serializer = ListMailboxExportJobsOperationSerializer()
            deserializer = ListMailboxExportJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMailboxExportJobs"
            }
        }
        registerListMailboxExportJobsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the mailbox permissions associated with a user, group, or resource
     * mailbox.
     */
    override suspend fun listMailboxPermissions(input: ListMailboxPermissionsRequest): ListMailboxPermissionsResponse {
        val op = SdkHttpOperation.build<ListMailboxPermissionsRequest, ListMailboxPermissionsResponse> {
            serializer = ListMailboxPermissionsOperationSerializer()
            deserializer = ListMailboxPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMailboxPermissions"
            }
        }
        registerListMailboxPermissionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
     */
    override suspend fun listMobileDeviceAccessOverrides(input: ListMobileDeviceAccessOverridesRequest): ListMobileDeviceAccessOverridesResponse {
        val op = SdkHttpOperation.build<ListMobileDeviceAccessOverridesRequest, ListMobileDeviceAccessOverridesResponse> {
            serializer = ListMobileDeviceAccessOverridesOperationSerializer()
            deserializer = ListMobileDeviceAccessOverridesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMobileDeviceAccessOverrides"
            }
        }
        registerListMobileDeviceAccessOverridesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the mobile device access rules for the specified Amazon WorkMail organization.
     */
    override suspend fun listMobileDeviceAccessRules(input: ListMobileDeviceAccessRulesRequest): ListMobileDeviceAccessRulesResponse {
        val op = SdkHttpOperation.build<ListMobileDeviceAccessRulesRequest, ListMobileDeviceAccessRulesResponse> {
            serializer = ListMobileDeviceAccessRulesOperationSerializer()
            deserializer = ListMobileDeviceAccessRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMobileDeviceAccessRules"
            }
        }
        registerListMobileDeviceAccessRulesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns summaries of the customer's organizations.
     */
    override suspend fun listOrganizations(input: ListOrganizationsRequest): ListOrganizationsResponse {
        val op = SdkHttpOperation.build<ListOrganizationsRequest, ListOrganizationsResponse> {
            serializer = ListOrganizationsOperationSerializer()
            deserializer = ListOrganizationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOrganizations"
            }
        }
        registerListOrganizationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the delegates associated with a resource. Users and groups can be resource
     * delegates and answer requests on behalf of the resource.
     */
    override suspend fun listResourceDelegates(input: ListResourceDelegatesRequest): ListResourceDelegatesResponse {
        val op = SdkHttpOperation.build<ListResourceDelegatesRequest, ListResourceDelegatesResponse> {
            serializer = ListResourceDelegatesOperationSerializer()
            deserializer = ListResourceDelegatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListResourceDelegates"
            }
        }
        registerListResourceDelegatesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns summaries of the organization's resources.
     */
    override suspend fun listResources(input: ListResourcesRequest): ListResourcesResponse {
        val op = SdkHttpOperation.build<ListResourcesRequest, ListResourcesResponse> {
            serializer = ListResourcesOperationSerializer()
            deserializer = ListResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListResources"
            }
        }
        registerListResourcesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags applied to an Amazon WorkMail organization resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns summaries of the organization's users.
     */
    override suspend fun listUsers(input: ListUsersRequest): ListUsersResponse {
        val op = SdkHttpOperation.build<ListUsersRequest, ListUsersResponse> {
            serializer = ListUsersOperationSerializer()
            deserializer = ListUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUsers"
            }
        }
        registerListUsersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new access control rule for the specified organization. The rule allows or
     * denies access to the organization for the specified IPv4 addresses, access protocol
     * actions, and user IDs. Adding a new rule with the same name as an existing rule replaces
     * the older rule.
     */
    override suspend fun putAccessControlRule(input: PutAccessControlRuleRequest): PutAccessControlRuleResponse {
        val op = SdkHttpOperation.build<PutAccessControlRuleRequest, PutAccessControlRuleResponse> {
            serializer = PutAccessControlRuleOperationSerializer()
            deserializer = PutAccessControlRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutAccessControlRule"
            }
        }
        registerPutAccessControlRuleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Enables or disables a DMARC policy for a given organization.
     */
    override suspend fun putInboundDmarcSettings(input: PutInboundDmarcSettingsRequest): PutInboundDmarcSettingsResponse {
        val op = SdkHttpOperation.build<PutInboundDmarcSettingsRequest, PutInboundDmarcSettingsResponse> {
            serializer = PutInboundDmarcSettingsOperationSerializer()
            deserializer = PutInboundDmarcSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutInboundDmarcSettings"
            }
        }
        registerPutInboundDmarcSettingsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sets permissions for a user, group, or resource. This replaces any pre-existing
     * permissions.
     */
    override suspend fun putMailboxPermissions(input: PutMailboxPermissionsRequest): PutMailboxPermissionsResponse {
        val op = SdkHttpOperation.build<PutMailboxPermissionsRequest, PutMailboxPermissionsResponse> {
            serializer = PutMailboxPermissionsOperationSerializer()
            deserializer = PutMailboxPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutMailboxPermissions"
            }
        }
        registerPutMailboxPermissionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates or updates a mobile device access override for the given WorkMail organization, user, and device.
     */
    override suspend fun putMobileDeviceAccessOverride(input: PutMobileDeviceAccessOverrideRequest): PutMobileDeviceAccessOverrideResponse {
        val op = SdkHttpOperation.build<PutMobileDeviceAccessOverrideRequest, PutMobileDeviceAccessOverrideResponse> {
            serializer = PutMobileDeviceAccessOverrideOperationSerializer()
            deserializer = PutMobileDeviceAccessOverrideOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutMobileDeviceAccessOverride"
            }
        }
        registerPutMobileDeviceAccessOverrideMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Puts a retention policy to the specified organization.
     */
    override suspend fun putRetentionPolicy(input: PutRetentionPolicyRequest): PutRetentionPolicyResponse {
        val op = SdkHttpOperation.build<PutRetentionPolicyRequest, PutRetentionPolicyResponse> {
            serializer = PutRetentionPolicyOperationSerializer()
            deserializer = PutRetentionPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutRetentionPolicy"
            }
        }
        registerPutRetentionPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Registers a new domain in Amazon WorkMail and SES, and configures it for use by WorkMail. Emails received by SES for this domain are routed to the specified WorkMail organization, and WorkMail has
     * permanent permission to use the specified domain for sending your users' emails.
     */
    override suspend fun registerMailDomain(input: RegisterMailDomainRequest): RegisterMailDomainResponse {
        val op = SdkHttpOperation.build<RegisterMailDomainRequest, RegisterMailDomainResponse> {
            serializer = RegisterMailDomainOperationSerializer()
            deserializer = RegisterMailDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterMailDomain"
            }
        }
        registerRegisterMailDomainMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Registers an existing and disabled user, group, or resource for Amazon WorkMail use by
     * associating a mailbox and calendaring capabilities. It performs no change if the user,
     * group, or resource is enabled and fails if the user, group, or resource is deleted. This
     * operation results in the accumulation of costs. For more information, see <a href="https://aws.amazon.com/workmail/pricing">Pricing. The equivalent console
     * functionality for this operation is Enable.
     * Users can either be created by calling the CreateUser API operation
     * or they can be synchronized from your directory. For more information, see DeregisterFromWorkMail.
     */
    override suspend fun registerToWorkMail(input: RegisterToWorkMailRequest): RegisterToWorkMailResponse {
        val op = SdkHttpOperation.build<RegisterToWorkMailRequest, RegisterToWorkMailResponse> {
            serializer = RegisterToWorkMailOperationSerializer()
            deserializer = RegisterToWorkMailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterToWorkMail"
            }
        }
        registerRegisterToWorkMailMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Allows the administrator to reset the password for a user.
     */
    override suspend fun resetPassword(input: ResetPasswordRequest): ResetPasswordResponse {
        val op = SdkHttpOperation.build<ResetPasswordRequest, ResetPasswordResponse> {
            serializer = ResetPasswordOperationSerializer()
            deserializer = ResetPasswordOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetPassword"
            }
        }
        registerResetPasswordMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a mailbox export job to export MIME-format email messages and calendar items
     * from the specified mailbox to the specified Amazon Simple Storage Service (Amazon S3)
     * bucket. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html">Exporting mailbox content in
     * the Amazon WorkMail Administrator Guide.
     */
    override suspend fun startMailboxExportJob(input: StartMailboxExportJobRequest): StartMailboxExportJobResponse {
        val op = SdkHttpOperation.build<StartMailboxExportJobRequest, StartMailboxExportJobResponse> {
            serializer = StartMailboxExportJobOperationSerializer()
            deserializer = StartMailboxExportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartMailboxExportJob"
            }
        }
        registerStartMailboxExportJobMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Applies the specified tags to the specified Amazon WorkMail organization
     * resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Untags the specified tags from the specified Amazon WorkMail organization
     * resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console to suggest an email address when enabling a mail user. You can only have one default domain.
     */
    override suspend fun updateDefaultMailDomain(input: UpdateDefaultMailDomainRequest): UpdateDefaultMailDomainResponse {
        val op = SdkHttpOperation.build<UpdateDefaultMailDomainRequest, UpdateDefaultMailDomainResponse> {
            serializer = UpdateDefaultMailDomainOperationSerializer()
            deserializer = UpdateDefaultMailDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDefaultMailDomain"
            }
        }
        registerUpdateDefaultMailDomainMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a user's current mailbox quota for a specified organization and
     * user.
     */
    override suspend fun updateMailboxQuota(input: UpdateMailboxQuotaRequest): UpdateMailboxQuotaResponse {
        val op = SdkHttpOperation.build<UpdateMailboxQuotaRequest, UpdateMailboxQuotaResponse> {
            serializer = UpdateMailboxQuotaOperationSerializer()
            deserializer = UpdateMailboxQuotaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMailboxQuota"
            }
        }
        registerUpdateMailboxQuotaMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a mobile device access rule for the specified Amazon WorkMail organization.
     */
    override suspend fun updateMobileDeviceAccessRule(input: UpdateMobileDeviceAccessRuleRequest): UpdateMobileDeviceAccessRuleResponse {
        val op = SdkHttpOperation.build<UpdateMobileDeviceAccessRuleRequest, UpdateMobileDeviceAccessRuleResponse> {
            serializer = UpdateMobileDeviceAccessRuleOperationSerializer()
            deserializer = UpdateMobileDeviceAccessRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMobileDeviceAccessRule"
            }
        }
        registerUpdateMobileDeviceAccessRuleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the primary email for a user, group, or resource. The current email is moved
     * into the list of aliases (or swapped between an existing alias and the current primary
     * email), and the email provided in the input is promoted as the primary.
     */
    override suspend fun updatePrimaryEmailAddress(input: UpdatePrimaryEmailAddressRequest): UpdatePrimaryEmailAddressResponse {
        val op = SdkHttpOperation.build<UpdatePrimaryEmailAddressRequest, UpdatePrimaryEmailAddressResponse> {
            serializer = UpdatePrimaryEmailAddressOperationSerializer()
            deserializer = UpdatePrimaryEmailAddressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePrimaryEmailAddress"
            }
        }
        registerUpdatePrimaryEmailAddressMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates data for the resource. To have the latest information, it must be preceded by
     * a DescribeResource call. The dataset in the request should be the one
     * expected when performing another DescribeResource call.
     */
    override suspend fun updateResource(input: UpdateResourceRequest): UpdateResourceResponse {
        val op = SdkHttpOperation.build<UpdateResourceRequest, UpdateResourceResponse> {
            serializer = UpdateResourceOperationSerializer()
            deserializer = UpdateResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateResource"
            }
        }
        registerUpdateResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
