// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.serde

import aws.sdk.kotlin.services.workmail.model.DescribeMailboxExportJobResponse
import aws.sdk.kotlin.services.workmail.model.MailboxExportJobState
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeMailboxExportJobOperationDeserializer: HttpDeserializer.NonStreaming<DescribeMailboxExportJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeMailboxExportJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeMailboxExportJobError(context, call, payload)
        }
        val builder = DescribeMailboxExportJobResponse.Builder()

        if (payload != null) {
            deserializeDescribeMailboxExportJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeMailboxExportJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeMailboxExportJobOperationBody(builder: DescribeMailboxExportJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val ENTITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EntityId"))
    val ERRORINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorInfo"))
    val ESTIMATEDPROGRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("EstimatedProgress"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyArn"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val S3BUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3BucketName"))
    val S3PATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3Path"))
    val S3PREFIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3Prefix"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(ENTITYID_DESCRIPTOR)
        field(ERRORINFO_DESCRIPTOR)
        field(ESTIMATEDPROGRESS_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(S3BUCKETNAME_DESCRIPTOR)
        field(S3PATH_DESCRIPTOR)
        field(S3PREFIX_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ENTITYID_DESCRIPTOR.index -> builder.entityId = deserializeString()
                ERRORINFO_DESCRIPTOR.index -> builder.errorInfo = deserializeString()
                ESTIMATEDPROGRESS_DESCRIPTOR.index -> builder.estimatedProgress = deserializeInt()
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                S3BUCKETNAME_DESCRIPTOR.index -> builder.s3BucketName = deserializeString()
                S3PATH_DESCRIPTOR.index -> builder.s3Path = deserializeString()
                S3PREFIX_DESCRIPTOR.index -> builder.s3Prefix = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { MailboxExportJobState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
