// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The IAM Identity Center configuration.
 */
public class IdentityCenterConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of IAMIdentity Center Application for WorkMail. Must be created by the WorkMail API, see CreateIdentityCenterApplication.
     */
    public val applicationArn: kotlin.String = requireNotNull(builder.applicationArn) { "A non-null value must be provided for applicationArn" }
    /**
     * The Amazon Resource Name (ARN) of the of IAM Identity Center instance. Must be in the same AWS account and region as WorkMail organization.
     */
    public val instanceArn: kotlin.String = requireNotNull(builder.instanceArn) { "A non-null value must be provided for instanceArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workmail.model.IdentityCenterConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdentityCenterConfiguration(")
        append("applicationArn=$applicationArn,")
        append("instanceArn=$instanceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationArn.hashCode()
        result = 31 * result + (instanceArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdentityCenterConfiguration

        if (applicationArn != other.applicationArn) return false
        if (instanceArn != other.instanceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workmail.model.IdentityCenterConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of IAMIdentity Center Application for WorkMail. Must be created by the WorkMail API, see CreateIdentityCenterApplication.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the of IAM Identity Center instance. Must be in the same AWS account and region as WorkMail organization.
         */
        public var instanceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workmail.model.IdentityCenterConfiguration) : this() {
            this.applicationArn = x.applicationArn
            this.instanceArn = x.instanceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workmail.model.IdentityCenterConfiguration = IdentityCenterConfiguration(this)

        internal fun correctErrors(): Builder {
            if (applicationArn == null) applicationArn = ""
            if (instanceArn == null) instanceArn = ""
            return this
        }
    }
}
