// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * List all the `AvailabilityConfiguration`'s for the given WorkMail organization.
 */
public class AvailabilityConfiguration private constructor(builder: Builder) {
    /**
     * The date and time at which the availability configuration was created.
     */
    public val dateCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateCreated
    /**
     * The date and time at which the availability configuration was last modified.
     */
    public val dateModified: aws.smithy.kotlin.runtime.time.Instant? = builder.dateModified
    /**
     * Displays the domain to which the provider applies.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * If `ProviderType` is `EWS`, then this field contains `RedactedEwsAvailabilityProvider`. Otherwise, it is not required.
     */
    public val ewsProvider: aws.sdk.kotlin.services.workmail.model.RedactedEwsAvailabilityProvider? = builder.ewsProvider
    /**
     * If ProviderType is `LAMBDA` then this field contains `LambdaAvailabilityProvider`. Otherwise, it is not required.
     */
    public val lambdaProvider: aws.sdk.kotlin.services.workmail.model.LambdaAvailabilityProvider? = builder.lambdaProvider
    /**
     * Displays the provider type that applies to this domain.
     */
    public val providerType: aws.sdk.kotlin.services.workmail.model.AvailabilityProviderType? = builder.providerType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workmail.model.AvailabilityConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AvailabilityConfiguration(")
        append("dateCreated=$dateCreated,")
        append("dateModified=$dateModified,")
        append("domainName=$domainName,")
        append("ewsProvider=$ewsProvider,")
        append("lambdaProvider=$lambdaProvider,")
        append("providerType=$providerType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dateCreated?.hashCode() ?: 0
        result = 31 * result + (dateModified?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (ewsProvider?.hashCode() ?: 0)
        result = 31 * result + (lambdaProvider?.hashCode() ?: 0)
        result = 31 * result + (providerType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AvailabilityConfiguration

        if (dateCreated != other.dateCreated) return false
        if (dateModified != other.dateModified) return false
        if (domainName != other.domainName) return false
        if (ewsProvider != other.ewsProvider) return false
        if (lambdaProvider != other.lambdaProvider) return false
        if (providerType != other.providerType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workmail.model.AvailabilityConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time at which the availability configuration was created.
         */
        public var dateCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time at which the availability configuration was last modified.
         */
        public var dateModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Displays the domain to which the provider applies.
         */
        public var domainName: kotlin.String? = null
        /**
         * If `ProviderType` is `EWS`, then this field contains `RedactedEwsAvailabilityProvider`. Otherwise, it is not required.
         */
        public var ewsProvider: aws.sdk.kotlin.services.workmail.model.RedactedEwsAvailabilityProvider? = null
        /**
         * If ProviderType is `LAMBDA` then this field contains `LambdaAvailabilityProvider`. Otherwise, it is not required.
         */
        public var lambdaProvider: aws.sdk.kotlin.services.workmail.model.LambdaAvailabilityProvider? = null
        /**
         * Displays the provider type that applies to this domain.
         */
        public var providerType: aws.sdk.kotlin.services.workmail.model.AvailabilityProviderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workmail.model.AvailabilityConfiguration) : this() {
            this.dateCreated = x.dateCreated
            this.dateModified = x.dateModified
            this.domainName = x.domainName
            this.ewsProvider = x.ewsProvider
            this.lambdaProvider = x.lambdaProvider
            this.providerType = x.providerType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workmail.model.AvailabilityConfiguration = AvailabilityConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.workmail.model.RedactedEwsAvailabilityProvider] inside the given [block]
         */
        public fun ewsProvider(block: aws.sdk.kotlin.services.workmail.model.RedactedEwsAvailabilityProvider.Builder.() -> kotlin.Unit) {
            this.ewsProvider = aws.sdk.kotlin.services.workmail.model.RedactedEwsAvailabilityProvider.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.workmail.model.LambdaAvailabilityProvider] inside the given [block]
         */
        public fun lambdaProvider(block: aws.sdk.kotlin.services.workmail.model.LambdaAvailabilityProvider.Builder.() -> kotlin.Unit) {
            this.lambdaProvider = aws.sdk.kotlin.services.workmail.model.LambdaAvailabilityProvider.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
