// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.serde

import aws.sdk.kotlin.services.workmail.model.GetPersonalAccessTokenMetadataResponse
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetPersonalAccessTokenMetadataOperationDeserializer: HttpDeserializer.NonStreaming<GetPersonalAccessTokenMetadataResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetPersonalAccessTokenMetadataResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPersonalAccessTokenMetadataError(context, call, payload)
        }
        val builder = GetPersonalAccessTokenMetadataResponse.Builder()

        if (payload != null) {
            deserializeGetPersonalAccessTokenMetadataOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetPersonalAccessTokenMetadataError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPersonalAccessTokenMetadataOperationBody(builder: GetPersonalAccessTokenMetadataResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATECREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DateCreated"))
    val DATELASTUSED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DateLastUsed"))
    val EXPIRESTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ExpiresTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PERSONALACCESSTOKENID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PersonalAccessTokenId"))
    val SCOPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Scopes"))
    val USERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UserId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATECREATED_DESCRIPTOR)
        field(DATELASTUSED_DESCRIPTOR)
        field(EXPIRESTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PERSONALACCESSTOKENID_DESCRIPTOR)
        field(SCOPES_DESCRIPTOR)
        field(USERID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATECREATED_DESCRIPTOR.index -> builder.dateCreated = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATELASTUSED_DESCRIPTOR.index -> builder.dateLastUsed = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                EXPIRESTIME_DESCRIPTOR.index -> builder.expiresTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PERSONALACCESSTOKENID_DESCRIPTOR.index -> builder.personalAccessTokenId = deserializeString()
                SCOPES_DESCRIPTOR.index -> builder.scopes =
                    deserializer.deserializeList(SCOPES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USERID_DESCRIPTOR.index -> builder.userId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
