// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.serde

import aws.sdk.kotlin.services.workmail.model.GetImpersonationRoleResponse
import aws.sdk.kotlin.services.workmail.model.ImpersonationRoleType
import aws.sdk.kotlin.services.workmail.model.ImpersonationRule
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetImpersonationRoleOperationDeserializer: HttpDeserializer.NonStreaming<GetImpersonationRoleResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetImpersonationRoleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetImpersonationRoleError(context, call, payload)
        }
        val builder = GetImpersonationRoleResponse.Builder()

        if (payload != null) {
            deserializeGetImpersonationRoleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetImpersonationRoleError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetImpersonationRoleOperationBody(builder: GetImpersonationRoleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATECREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DateCreated"))
    val DATEMODIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DateModified"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val IMPERSONATIONROLEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImpersonationRoleId"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val RULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Rules"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATECREATED_DESCRIPTOR)
        field(DATEMODIFIED_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(IMPERSONATIONROLEID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RULES_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATECREATED_DESCRIPTOR.index -> builder.dateCreated = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATEMODIFIED_DESCRIPTOR.index -> builder.dateModified = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                IMPERSONATIONROLEID_DESCRIPTOR.index -> builder.impersonationRoleId = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                RULES_DESCRIPTOR.index -> builder.rules =
                    deserializer.deserializeList(RULES_DESCRIPTOR) {
                        val col0 = mutableListOf<ImpersonationRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeImpersonationRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { ImpersonationRoleType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
