// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.serde

import aws.sdk.kotlin.services.workmail.model.DescribeUserResponse
import aws.sdk.kotlin.services.workmail.model.EntityState
import aws.sdk.kotlin.services.workmail.model.UserRole
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeUserOperationDeserializer: HttpDeserializer.NonStreaming<DescribeUserResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeUserResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeUserError(context, call, payload)
        }
        val builder = DescribeUserResponse.Builder()

        if (payload != null) {
            deserializeDescribeUserOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeUserError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DirectoryUnavailableException" -> DirectoryUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DirectoryServiceAuthenticationFailedException" -> DirectoryServiceAuthenticationFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeUserOperationBody(builder: DescribeUserResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("City"))
    val COMPANY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Company"))
    val COUNTRY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Country"))
    val DEPARTMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Department"))
    val DISABLEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DisabledDate"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val EMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Email"))
    val ENABLEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EnabledDate"))
    val FIRSTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FirstName"))
    val HIDDENFROMGLOBALADDRESSLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("HiddenFromGlobalAddressList"))
    val IDENTITYPROVIDERIDENTITYSTOREID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityProviderIdentityStoreId"))
    val IDENTITYPROVIDERUSERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityProviderUserId"))
    val INITIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Initials"))
    val JOBTITLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobTitle"))
    val LASTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastName"))
    val MAILBOXDEPROVISIONEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("MailboxDeprovisionedDate"))
    val MAILBOXPROVISIONEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("MailboxProvisionedDate"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OFFICE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Office"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val STREET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Street"))
    val TELEPHONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Telephone"))
    val USERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UserId"))
    val USERROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("UserRole"))
    val ZIPCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ZipCode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CITY_DESCRIPTOR)
        field(COMPANY_DESCRIPTOR)
        field(COUNTRY_DESCRIPTOR)
        field(DEPARTMENT_DESCRIPTOR)
        field(DISABLEDDATE_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(EMAIL_DESCRIPTOR)
        field(ENABLEDDATE_DESCRIPTOR)
        field(FIRSTNAME_DESCRIPTOR)
        field(HIDDENFROMGLOBALADDRESSLIST_DESCRIPTOR)
        field(IDENTITYPROVIDERIDENTITYSTOREID_DESCRIPTOR)
        field(IDENTITYPROVIDERUSERID_DESCRIPTOR)
        field(INITIALS_DESCRIPTOR)
        field(JOBTITLE_DESCRIPTOR)
        field(LASTNAME_DESCRIPTOR)
        field(MAILBOXDEPROVISIONEDDATE_DESCRIPTOR)
        field(MAILBOXPROVISIONEDDATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OFFICE_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(STREET_DESCRIPTOR)
        field(TELEPHONE_DESCRIPTOR)
        field(USERID_DESCRIPTOR)
        field(USERROLE_DESCRIPTOR)
        field(ZIPCODE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CITY_DESCRIPTOR.index -> builder.city = deserializeString()
                COMPANY_DESCRIPTOR.index -> builder.company = deserializeString()
                COUNTRY_DESCRIPTOR.index -> builder.country = deserializeString()
                DEPARTMENT_DESCRIPTOR.index -> builder.department = deserializeString()
                DISABLEDDATE_DESCRIPTOR.index -> builder.disabledDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                EMAIL_DESCRIPTOR.index -> builder.email = deserializeString()
                ENABLEDDATE_DESCRIPTOR.index -> builder.enabledDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                FIRSTNAME_DESCRIPTOR.index -> builder.firstName = deserializeString()
                HIDDENFROMGLOBALADDRESSLIST_DESCRIPTOR.index -> builder.hiddenFromGlobalAddressList = deserializeBoolean()
                IDENTITYPROVIDERIDENTITYSTOREID_DESCRIPTOR.index -> builder.identityProviderIdentityStoreId = deserializeString()
                IDENTITYPROVIDERUSERID_DESCRIPTOR.index -> builder.identityProviderUserId = deserializeString()
                INITIALS_DESCRIPTOR.index -> builder.initials = deserializeString()
                JOBTITLE_DESCRIPTOR.index -> builder.jobTitle = deserializeString()
                LASTNAME_DESCRIPTOR.index -> builder.lastName = deserializeString()
                MAILBOXDEPROVISIONEDDATE_DESCRIPTOR.index -> builder.mailboxDeprovisionedDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MAILBOXPROVISIONEDDATE_DESCRIPTOR.index -> builder.mailboxProvisionedDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OFFICE_DESCRIPTOR.index -> builder.office = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { EntityState.fromValue(it) }
                STREET_DESCRIPTOR.index -> builder.street = deserializeString()
                TELEPHONE_DESCRIPTOR.index -> builder.telephone = deserializeString()
                USERID_DESCRIPTOR.index -> builder.userId = deserializeString()
                USERROLE_DESCRIPTOR.index -> builder.userRole = deserializeString().let { UserRole.fromValue(it) }
                ZIPCODE_DESCRIPTOR.index -> builder.zipCode = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
