// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.serde

import aws.sdk.kotlin.services.workmail.model.BookingOptions
import aws.sdk.kotlin.services.workmail.model.DescribeResourceResponse
import aws.sdk.kotlin.services.workmail.model.EntityState
import aws.sdk.kotlin.services.workmail.model.ResourceType
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeResourceOperationDeserializer: HttpDeserializer.NonStreaming<DescribeResourceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeResourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeResourceError(context, call, payload)
        }
        val builder = DescribeResourceResponse.Builder()

        if (payload != null) {
            deserializeDescribeResourceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeResourceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeResourceOperationBody(builder: DescribeResourceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOOKINGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BookingOptions"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DISABLEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DisabledDate"))
    val EMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Email"))
    val ENABLEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EnabledDate"))
    val HIDDENFROMGLOBALADDRESSLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("HiddenFromGlobalAddressList"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val RESOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceId"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOOKINGOPTIONS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISABLEDDATE_DESCRIPTOR)
        field(EMAIL_DESCRIPTOR)
        field(ENABLEDDATE_DESCRIPTOR)
        field(HIDDENFROMGLOBALADDRESSLIST_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RESOURCEID_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOOKINGOPTIONS_DESCRIPTOR.index -> builder.bookingOptions = deserializeBookingOptionsDocument(deserializer)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DISABLEDDATE_DESCRIPTOR.index -> builder.disabledDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                EMAIL_DESCRIPTOR.index -> builder.email = deserializeString()
                ENABLEDDATE_DESCRIPTOR.index -> builder.enabledDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                HIDDENFROMGLOBALADDRESSLIST_DESCRIPTOR.index -> builder.hiddenFromGlobalAddressList = deserializeBoolean()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                RESOURCEID_DESCRIPTOR.index -> builder.resourceId = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { EntityState.fromValue(it) }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { ResourceType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
