// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.serde

import aws.sdk.kotlin.services.workmail.model.DescribeIdentityProviderConfigurationResponse
import aws.sdk.kotlin.services.workmail.model.IdentityCenterConfiguration
import aws.sdk.kotlin.services.workmail.model.IdentityProviderAuthenticationMode
import aws.sdk.kotlin.services.workmail.model.PersonalAccessTokenConfiguration
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeIdentityProviderConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<DescribeIdentityProviderConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeIdentityProviderConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeIdentityProviderConfigurationError(context, call, payload)
        }
        val builder = DescribeIdentityProviderConfigurationResponse.Builder()

        if (payload != null) {
            deserializeDescribeIdentityProviderConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeIdentityProviderConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeIdentityProviderConfigurationOperationBody(builder: DescribeIdentityProviderConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHENTICATIONMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AuthenticationMode"))
    val IDENTITYCENTERCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("IdentityCenterConfiguration"))
    val PERSONALACCESSTOKENCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PersonalAccessTokenConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHENTICATIONMODE_DESCRIPTOR)
        field(IDENTITYCENTERCONFIGURATION_DESCRIPTOR)
        field(PERSONALACCESSTOKENCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHENTICATIONMODE_DESCRIPTOR.index -> builder.authenticationMode = deserializeString().let { IdentityProviderAuthenticationMode.fromValue(it) }
                IDENTITYCENTERCONFIGURATION_DESCRIPTOR.index -> builder.identityCenterConfiguration = deserializeIdentityCenterConfigurationDocument(deserializer)
                PERSONALACCESSTOKENCONFIGURATION_DESCRIPTOR.index -> builder.personalAccessTokenConfiguration = deserializePersonalAccessTokenConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
